/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.rendering.IGetSeleniumRegion;
import com.applitools.eyes.visualgrid.model.IGetFloatingRegionOffsets;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class FloatingRegionBySelector
implements GetFloatingRegion,
IGetSeleniumRegion,
IGetFloatingRegionOffsets {
    private By selector;
    private int maxUpOffset;
    private int maxDownOffset;
    private int maxLeftOffset;
    private int maxRightOffset;

    public FloatingRegionBySelector(By regionSelector, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.selector = regionSelector;
        this.maxUpOffset = maxUpOffset;
        this.maxDownOffset = maxDownOffset;
        this.maxLeftOffset = maxLeftOffset;
        this.maxRightOffset = maxRightOffset;
    }

    public List<FloatingMatchSettings> getRegions(EyesBase eyesBase, EyesScreenshot screenshot) {
        List elements = ((SeleniumEyes)eyesBase).getDriver().findElements(this.selector);
        ArrayList<FloatingMatchSettings> values = new ArrayList<FloatingMatchSettings>();
        Logger logger = eyesBase.getLogger();
        for (WebElement element : elements) {
            Point locationAsPoint = element.getLocation();
            RectangleSize size = EyesSeleniumUtils.getElementVisibleSize(logger, element);
            Location adjustedLocation = screenshot != null ? screenshot.getLocationInScreenshot(new Location(locationAsPoint.getX(), locationAsPoint.getY()), CoordinatesType.CONTEXT_RELATIVE) : new Location(locationAsPoint.getX(), locationAsPoint.getY());
            values.add(new FloatingMatchSettings(adjustedLocation.getX(), adjustedLocation.getY(), size.getWidth(), size.getHeight(), this.maxUpOffset, this.maxDownOffset, this.maxLeftOffset, this.maxRightOffset));
        }
        return values;
    }

    @Override
    public List<WebElement> getElements(WebDriver webDriver) {
        return webDriver.findElements(this.selector);
    }

    public int getMaxLeftOffset() {
        return this.maxLeftOffset;
    }

    public int getMaxUpOffset() {
        return this.maxUpOffset;
    }

    public int getMaxRightOffset() {
        return this.maxRightOffset;
    }

    public int getMaxDownOffset() {
        return this.maxDownOffset;
    }
}

