/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.triggers;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Mouse;

public class EyesMouse
implements Mouse {
    private final Logger logger;
    private final EyesWebDriver eyesDriver;
    private final Mouse mouse;
    private Location mouseLocation;

    public EyesMouse(Logger logger, EyesWebDriver eyesDriver, Mouse mouse) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)eyesDriver, (String)"eyesDriver");
        ArgumentGuard.notNull((Object)mouse, (String)"mouse");
        this.logger = logger;
        this.eyesDriver = eyesDriver;
        this.mouse = mouse;
        this.mouseLocation = new Location(0, 0);
    }

    protected void moveIfNeeded(Coordinates where) {
        if (where != null) {
            this.mouseMove(where);
        }
    }

    public void click(Coordinates where) {
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("click(" + location + ")");
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.Click);
        this.logger.verbose("Location is " + this.mouseLocation);
        this.mouse.click(where);
    }

    public void doubleClick(Coordinates where) {
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("doubleClick(" + location + ")");
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.DoubleClick);
        this.logger.verbose("Location is " + this.mouseLocation);
        this.mouse.doubleClick(where);
    }

    public void mouseDown(Coordinates where) {
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("mouseDown(" + location + ")");
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.Down);
        this.logger.verbose("Location is " + this.mouseLocation);
        this.mouse.mouseDown(where);
    }

    public void mouseUp(Coordinates where) {
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("mouseUp(" + location + ")");
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.Up);
        this.logger.verbose("Location is " + this.mouseLocation);
        this.mouse.mouseUp(where);
    }

    public void mouseMove(Coordinates where) {
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("mouseMove(" + location + ")");
        if (location != null) {
            int newX = Math.max(0, location.getX());
            int newY = Math.max(0, location.getY());
            this.mouseLocation = new Location(newX, newY);
            this.addMouseTrigger(MouseAction.Move);
        }
        this.mouse.mouseMove(where);
    }

    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        int newY;
        int newX;
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("mouseMove(" + location + ", " + xOffset + ", " + yOffset + ")");
        if (location != null) {
            newX = (int)((long)location.getX() + xOffset);
            newY = (int)((long)location.getY() + yOffset);
        } else {
            newX = (int)((long)this.mouseLocation.getX() + xOffset);
            newY = (int)((long)this.mouseLocation.getY() + yOffset);
        }
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        this.mouseLocation = new Location(newX, newY);
        this.addMouseTrigger(MouseAction.Move);
        this.mouse.mouseMove(where, xOffset, yOffset);
    }

    public void contextClick(Coordinates where) {
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("contextClick(" + location + ")");
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.RightClick);
        this.logger.verbose("Location is " + this.mouseLocation);
        this.mouse.contextClick(where);
    }

    protected void addMouseTrigger(MouseAction action) {
        this.eyesDriver.getEyes().addMouseTrigger(action, Region.EMPTY, this.mouseLocation);
    }
}

