/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class EyesSeleniumUtils {
    public static WebElement getDefaultRootElement(Logger logger, EyesSeleniumDriver driver) {
        WebElement html = driver.findElement(By.tagName((String)"html"));
        WebElement body = driver.findElement(By.tagName((String)"body"));
        EyesRemoteWebElement htmlElement = new EyesRemoteWebElement(logger, driver, html);
        EyesRemoteWebElement bodyElement = new EyesRemoteWebElement(logger, driver, body);
        if (htmlElement.getBoundingClientRect().height < bodyElement.getBoundingClientRect().height) {
            return bodyElement;
        }
        return htmlElement;
    }

    public static WebElement getScrollRootElement(Logger logger, EyesSeleniumDriver driver, IScrollRootElementContainer scrollRootElementContainer) {
        if (EyesDriverUtils.isMobileDevice((WebDriver)driver)) {
            return null;
        }
        if (scrollRootElementContainer == null) {
            return EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        WebElement scrollRootElement = scrollRootElementContainer.getScrollRootElement();
        if (scrollRootElement != null) {
            return scrollRootElement;
        }
        By scrollRootSelector = scrollRootElementContainer.getScrollRootSelector();
        if (scrollRootSelector != null) {
            return driver.findElement(scrollRootSelector);
        }
        logger.log("Warning: Got an empty scroll root element container");
        return EyesSeleniumUtils.getDefaultRootElement(logger, driver);
    }
}

