/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.ScaleProviderIdentityFactory;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.scaling.FixedScaleProviderFactory;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.selenium.Borders;
import com.applitools.eyes.selenium.BoundsAndBorders;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.ContextBasedScaleProviderFactory;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.ISeleniumEyes;
import com.applitools.eyes.selenium.PositionProviderAndMemento;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.capture.DomCapture;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshot;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshotFactory;
import com.applitools.eyes.selenium.capture.FullPageCaptureAlgorithm;
import com.applitools.eyes.selenium.capture.ISizeAdjuster;
import com.applitools.eyes.selenium.capture.ImageProviderFactory;
import com.applitools.eyes.selenium.capture.MobileScreenshotImageProvider;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.ISeleniumFrameCheckTarget;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionProvider;
import com.applitools.eyes.selenium.positioning.ElementPositionProvider;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.positioning.PositionProviderFactory;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensationFactory;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.positioning.SeleniumScrollPositionProvider;
import com.applitools.eyes.selenium.regionVisibility.MoveToRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.NopRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.RegionVisibilityStrategy;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumEyes
extends EyesBase
implements ISeleniumEyes,
IBatchCloser {
    private FrameChain originalFC;
    private WebElement scrollRootElement;
    private PositionProvider currentFramePositionProvider;
    public static final double UNKNOWN_DEVICE_PIXEL_RATIO = 0.0;
    public static final double DEFAULT_DEVICE_PIXEL_RATIO = 1.0;
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private static final int RESPONSE_TIME_DEFAULT_DEADLINE = 10;
    private static final int RESPONSE_TIME_DEFAULT_DIFF_FROM_DEADLINE = 20;
    private EyesSeleniumDriver driver;
    private boolean doNotGetTitle;
    public boolean checkFrameOrElement;
    private Region regionToCheck;
    private String originalOverflow;
    private ImageRotation rotation;
    private double devicePixelRatio;
    private PropertyHandler<RegionVisibilityStrategy> regionVisibilityStrategyHandler;
    private ElementPositionProvider elementPositionProvider;
    private SeleniumJavaScriptExecutor jsExecutor;
    private UserAgent userAgent;
    private ImageProvider imageProvider;
    private RegionPositionCompensation regionPositionCompensation;
    private WebElement targetElement;
    private PositionMemento positionMemento;
    private Region effectiveViewport;
    private EyesScreenshotFactory screenshotFactory;
    private String cachedAUTSessionId;
    private Region fullRegionToCheck;
    private final ConfigurationProvider configurationProvider;
    private boolean stitchContent;
    private ClassicRunner runner;

    public boolean shouldStitchContent() {
        return this.stitchContent;
    }

    public SeleniumEyes(ConfigurationProvider configurationProvider, ClassicRunner runner) {
        this.configurationProvider = configurationProvider;
        this.checkFrameOrElement = false;
        this.doNotGetTitle = false;
        this.devicePixelRatio = 0.0;
        this.regionVisibilityStrategyHandler = new SimplePropertyHandler();
        this.regionVisibilityStrategyHandler.set((Object)new MoveToRegionVisibilityStrategy(this.logger));
        this.runner = runner;
    }

    public String getBaseAgentId() {
        return "eyes.selenium.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    @Override
    public void apiKey(String apiKey) {
        this.setApiKey(apiKey);
    }

    @Override
    public void serverUrl(String serverUrl) {
        this.setServerUrl(serverUrl);
    }

    public void serverUrl(URI serverUrl) {
        this.setServerUrl(serverUrl);
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    public FrameChain getOriginalFC() {
        return this.originalFC;
    }

    public PositionProvider getCurrentFramePositionProvider() {
        return this.currentFramePositionProvider;
    }

    public Region getRegionToCheck() {
        return this.regionToCheck;
    }

    public void setRegionToCheck(Region regionToCheck) {
        this.regionToCheck = regionToCheck;
    }

    public void setScrollToRegion(boolean shouldScroll) {
        this.regionVisibilityStrategyHandler = shouldScroll ? new ReadOnlyPropertyHandler(this.logger, (Object)new MoveToRegionVisibilityStrategy(this.logger)) : new ReadOnlyPropertyHandler(this.logger, (Object)new NopRegionVisibilityStrategy(this.logger));
    }

    public boolean getScrollToRegion() {
        return !(this.regionVisibilityStrategyHandler.get() instanceof NopRegionVisibilityStrategy);
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        if (this.driver != null) {
            this.driver.setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    @Override
    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) throws EyesException {
        this.getConfigurationInstance().setAppName(appName).setTestName(testName);
        if (viewportSize != null && !viewportSize.isEmpty()) {
            this.getConfigurationInstance().setViewportSize(new RectangleSize(viewportSize));
        }
        return this.open(driver);
    }

    @Override
    public WebDriver open(WebDriver driver) throws EyesException {
        this.openLogger();
        this.cachedAUTSessionId = null;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return driver;
        }
        this.initDriver(driver);
        this.jsExecutor = new SeleniumJavaScriptExecutor(this.driver);
        String uaString = this.driver.getUserAgent();
        if (uaString != null) {
            if (uaString.startsWith("useragent:")) {
                uaString = uaString.substring(10);
            }
            this.userAgent = UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        }
        this.initDevicePixelRatio();
        this.screenshotFactory = new EyesWebDriverScreenshotFactory(this.logger, this.driver);
        this.imageProvider = ImageProviderFactory.getImageProvider(this.userAgent, this, this.logger, (TakesScreenshot)this.driver);
        this.regionPositionCompensation = RegionPositionCompensationFactory.getRegionPositionCompensation(this.userAgent, this, this.logger);
        if (!this.getConfigurationInstance().isVisualGrid()) {
            this.openBase();
        }
        this.driver.setRotation(this.rotation);
        this.runner.addBatch(this.getConfigurationInstance().getBatch().getId(), this);
        return this.driver;
    }

    private void initDevicePixelRatio() {
        this.logger.verbose("Trying to extract device pixel ratio...");
        try {
            this.devicePixelRatio = EyesDriverUtils.getDevicePixelRatio((IEyesJsExecutor)this.jsExecutor);
        }
        catch (Exception ex) {
            this.logger.verbose("Failed to extract device pixel ratio! Using default.");
            this.devicePixelRatio = 1.0;
        }
        this.logger.verbose("Device pixel ratio: " + this.devicePixelRatio);
    }

    private void initDriver(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesSeleniumDriver(this.logger, this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesSeleniumDriver) {
            this.driver = (EyesSeleniumDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        if (EyesDriverUtils.isMobileDevice((WebDriver)driver)) {
            this.regionVisibilityStrategyHandler.set((Object)new NopRegionVisibilityStrategy(this.logger));
        }
    }

    public WebElement getScrollRootElement() {
        if (this.scrollRootElement == null) {
            this.scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        }
        return this.scrollRootElement;
    }

    private PositionProvider createPositionProvider() {
        return this.createPositionProvider(this.scrollRootElement);
    }

    private PositionProvider createPositionProvider(WebElement scrollRootElement) {
        StitchMode stitchMode = this.getConfigurationInstance().getStitchMode();
        this.logger.verbose("initializing position provider. stitchMode: " + stitchMode);
        switch (stitchMode) {
            case CSS: {
                return new CssTranslatePositionProvider(this.logger, this.jsExecutor, scrollRootElement);
            }
        }
        return ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.window().timeout(matchTimeout));
    }

    @Override
    public void check(ICheckSettings ... checkSettings) {
        boolean originalForceFPS;
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check(ICheckSettings[%d]): Ignored", checkSettings.length));
            return;
        }
        Boolean forceFullPageScreenshot = this.getConfigurationInstance().getForceFullPageScreenshot();
        boolean bl = originalForceFPS = forceFullPageScreenshot == null ? false : forceFullPageScreenshot;
        if (checkSettings.length > 1) {
            this.getConfigurationInstance().setForceFullPageScreenshot(true);
        }
        this.logger.verbose(this.getConfigurationInstance().toString());
        Hashtable<Integer, GetSimpleRegion> getRegions = new Hashtable<Integer, GetSimpleRegion>();
        Hashtable<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary = new Hashtable<Integer, ICheckSettingsInternal>();
        for (int i = 0; i < checkSettings.length; ++i) {
            ISeleniumCheckTarget seleniumCheckTarget;
            ICheckSettings settings = checkSettings[i];
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)settings;
            ((Dictionary)checkSettingsInternalDictionary).put(i, checkSettingsInternal);
            Region targetRegion = checkSettingsInternal.getTargetRegion();
            if (targetRegion != null) {
                ((Dictionary)getRegions).put(i, (GetSimpleRegion)new SimpleRegionByRectangle(targetRegion));
                continue;
            }
            ISeleniumCheckTarget iSeleniumCheckTarget = seleniumCheckTarget = settings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)settings : null;
            if (seleniumCheckTarget == null) continue;
            seleniumCheckTarget.init(this.logger, this.driver);
            WebElement targetElement = this.getTargetElement(seleniumCheckTarget);
            if (targetElement == null && seleniumCheckTarget.getFrameChain().size() == 1) {
                targetElement = this.getFrameElement(seleniumCheckTarget.getFrameChain().get(0));
            }
            if (targetElement == null) continue;
            ((Dictionary)getRegions).put(i, (GetSimpleRegion)new SimpleRegionByElement(targetElement));
        }
        this.scrollRootElement = EyesSeleniumUtils.getScrollRootElement(this.logger, this.driver, (IScrollRootElementContainer)checkSettings[0]);
        this.currentFramePositionProvider = null;
        this.setPositionProvider(this.createPositionProvider());
        this.matchRegions(getRegions, checkSettingsInternalDictionary, checkSettings);
        this.getConfigurationInstance().setForceFullPageScreenshot(originalForceFPS);
    }

    private void matchRegions(Dictionary<Integer, GetSimpleRegion> getRegions, Dictionary<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary, ICheckSettings[] checkSettings) {
        boolean hasFrames;
        if (getRegions.size() == 0) {
            return;
        }
        this.originalFC = this.driver.getFrameChain().clone();
        Region bBox = this.findBoundingBox(getRegions, checkSettings);
        MatchWindowTask mwt = new MatchWindowTask(this.logger, this.serverConnector, this.runningSession, this.getConfigurationInstance().getMatchTimeout(), (EyesBase)this);
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory);
        Object activeElement = null;
        if (this.getConfigurationInstance().getHideCaret()) {
            try {
                activeElement = this.driver.executeScript("var activeElement = document.activeElement; activeElement && activeElement.blur(); return activeElement;", new Object[0]);
            }
            catch (WebDriverException e) {
                this.logger.verbose("WARNING: Cannot hide caret! " + e.getMessage());
            }
        }
        Region region = Region.EMPTY;
        boolean bl = hasFrames = this.driver.getFrameChain().size() > 0;
        if (hasFrames) {
            region = new Region(bBox.getLocation(), ((EyesRemoteWebElement)this.scrollRootElement).getClientSize());
        } else {
            WebElement defaultRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            if (!this.scrollRootElement.equals(defaultRootElement)) {
                EyesRemoteWebElement eyesScrollRootElement = this.scrollRootElement instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)this.scrollRootElement : new EyesRemoteWebElement(this.logger, this.driver, this.scrollRootElement);
                Point location = eyesScrollRootElement.getLocation();
                SizeAndBorders sizeAndBorders = eyesScrollRootElement.getSizeAndBorders();
                region = new Region(location.getX() + sizeAndBorders.getBorders().getLeft(), location.getY() + sizeAndBorders.getBorders().getTop(), sizeAndBorders.getSize().getWidth(), sizeAndBorders.getSize().getHeight());
            }
        }
        region.intersect(this.effectiveViewport);
        this.markElementForLayoutRCA(null);
        BufferedImage screenshotImage = algo.getStitchedRegion(region, bBox, (PositionProvider)this.positionProviderHandler.get());
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage, EyesWebDriverScreenshot.ScreenshotType.VIEWPORT, Location.ZERO);
        for (int i = 0; i < checkSettings.length; ++i) {
            if (!((Hashtable)getRegions).containsKey(i)) continue;
            GetSimpleRegion simpleRegion = getRegions.get(i);
            ICheckSettingsInternal checkSettingsInternal = checkSettingsInternalDictionary.get(i);
            List<EyesScreenshot> subScreenshots = this.getSubScreenshots(hasFrames ? Region.EMPTY : bBox, screenshot, simpleRegion);
            this.matchRegion(checkSettingsInternal, mwt, subScreenshots);
        }
        if (this.getConfigurationInstance().getHideCaret() && activeElement != null) {
            try {
                this.driver.executeScript("arguments[0].focus();", activeElement);
            }
            catch (WebDriverException e) {
                this.logger.verbose("WARNING: Could not return focus to active element! " + e.getMessage());
            }
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(this.originalFC);
    }

    private List<EyesScreenshot> getSubScreenshots(Region bBox, EyesWebDriverScreenshot screenshot, GetSimpleRegion getSimpleRegion) {
        ArrayList<EyesScreenshot> subScreenshots = new ArrayList<EyesScreenshot>();
        for (Region r : getSimpleRegion.getRegions((EyesScreenshot)screenshot)) {
            this.logger.verbose("original sub-region: " + r);
            r = r.offset(-bBox.getLeft(), -bBox.getTop());
            EyesWebDriverScreenshot subScreenshot = screenshot.getSubScreenshotForRegion(r, false);
            subScreenshots.add(subScreenshot);
        }
        return subScreenshots;
    }

    private void matchRegion(ICheckSettingsInternal checkSettingsInternal, MatchWindowTask mwt, List<EyesScreenshot> subScreenshots) {
        String name = checkSettingsInternal.getName();
        String source = this.driver.getCurrentUrl();
        for (EyesScreenshot subScreenshot : subScreenshots) {
            this.debugScreenshotsProvider.save(subScreenshot.getImage(), String.format("subscreenshot_%s", name));
            ImageMatchSettings ims = MatchWindowTask.createImageMatchSettings((ICheckSettingsInternal)checkSettingsInternal, (EyesScreenshot)subScreenshot, (EyesBase)this);
            Location location = subScreenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.SCREENSHOT_AS_IS);
            AppOutput appOutput = new AppOutput(name, ImageUtils.encodeAsPng((BufferedImage)subScreenshot.getImage()), null, null);
            AppOutputWithScreenshot appOutputWithScreenshot = new AppOutputWithScreenshot(appOutput, subScreenshot, location);
            MatchResult matchResult = mwt.performMatch(new ArrayList(), appOutputWithScreenshot, name, false, checkSettingsInternal, ims, (EyesBase)this, source);
            this.logger.verbose("matchResult.asExcepted: " + matchResult.getAsExpected());
        }
    }

    private Region findBoundingBox(Dictionary<Integer, GetSimpleRegion> getRegions, ICheckSettings[] checkSettings) {
        RectangleSize rectSize = this.getViewportSize();
        this.logger.verbose("rectSize: " + rectSize);
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, new BufferedImage(rectSize.getWidth(), rectSize.getHeight(), 1));
        return this.findBoundingBox(getRegions, checkSettings, screenshot);
    }

    private Region findBoundingBox(Dictionary<Integer, GetSimpleRegion> getRegions, ICheckSettings[] checkSettings, EyesScreenshot screenshot) {
        Region bBox = null;
        for (int i = 0; i < checkSettings.length; ++i) {
            GetSimpleRegion simpleRegion = getRegions.get(i);
            if (simpleRegion == null) continue;
            List regions = simpleRegion.getRegions(screenshot);
            for (Region region : regions) {
                if (bBox == null) {
                    bBox = new Region((IRegion)region);
                    continue;
                }
                bBox = bBox.expandToContain(region);
            }
        }
        Location offset = screenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.CONTEXT_AS_IS);
        return bBox.offset(offset.getX(), offset.getY());
    }

    private WebElement getFrameElement(FrameLocator frameLocator) {
        WebElement frameReference = frameLocator.getFrameReference();
        if (frameReference == null) {
            By selector = frameLocator.getFrameSelector();
            List<WebElement> possibleFrames = null;
            if (selector != null) {
                possibleFrames = this.driver.findElements(selector);
            } else {
                Integer frameIndex;
                String nameOrId = frameLocator.getFrameNameOrId();
                if (nameOrId != null && (possibleFrames = this.driver.findElementsById(nameOrId)).size() == 0 && (possibleFrames = this.driver.findElementsByName(nameOrId)).size() == 0 && (frameIndex = frameLocator.getFrameIndex()) != null) {
                    possibleFrames = this.driver.findElements(By.cssSelector((String)String.format("iframe:nth-of-type(%d)", frameIndex)));
                }
            }
            if (possibleFrames != null && possibleFrames.size() > 0) {
                frameReference = possibleFrames.get(0);
            }
        }
        return frameReference;
    }

    private WebElement getTargetElement(ISeleniumCheckTarget seleniumCheckTarget) {
        assert (seleniumCheckTarget != null);
        By targetSelector = seleniumCheckTarget.getTargetSelector();
        Object targetElement = seleniumCheckTarget.getTargetElement();
        if (targetElement == null && targetSelector != null) {
            targetElement = this.driver.findElement(targetSelector);
        } else if (targetElement != null && !(targetElement instanceof EyesRemoteWebElement)) {
            targetElement = new EyesRemoteWebElement(this.logger, this.driver, (WebElement)targetElement);
        }
        return targetElement;
    }

    @Override
    public void check(String name, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check('%s', %s): Ignored", name, checkSettings));
            return;
        }
        ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        if (name != null) {
            checkSettings = checkSettings.withName(name);
        }
        this.check(checkSettings);
    }

    public void setIsDisabled(boolean disabled) {
        super.setIsDisabled(disabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryCaptureDom() {
        String fullWindowDom = "";
        FrameChain fc = this.driver.getFrameChain().clone();
        try {
            Frame frame = fc.peek();
            WebElement scrollRootElement = null;
            if (frame != null) {
                scrollRootElement = frame.getScrollRootElement();
            }
            if (scrollRootElement == null) {
                scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            }
            SeleniumScrollPositionProvider positionProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
            DomCapture domCapture = new DomCapture(this);
            fullWindowDom = domCapture.getFullWindowDom((PositionProvider)positionProvider);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        finally {
            ((EyesTargetLocator)this.driver.switchTo()).frames(fc);
        }
        return fullWindowDom;
    }

    protected void setEffectiveViewportSize(RectangleSize size) {
        this.effectiveViewport = new Region(Location.ZERO, size);
        this.logger.verbose("setting effective viewport size to " + size);
    }

    @Override
    public void check(ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check(%s): Ignored", checkSettings));
            return;
        }
        try {
            ISeleniumCheckTarget seleniumCheckTarget;
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
            ArgumentGuard.notOfType((Object)checkSettings, ISeleniumCheckTarget.class, (String)"checkSettings");
            boolean isMobileDevice = EyesDriverUtils.isMobileDevice((WebDriver)this.driver);
            if (!isMobileDevice) {
                this.logger.verbose("URL: " + this.driver.getCurrentUrl());
            }
            this.regionToCheck = Region.EMPTY;
            this.fullRegionToCheck = Region.EMPTY;
            this.setEffectiveViewportSize(this.getConfigurationInstance().getViewportSize());
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
            ISeleniumCheckTarget iSeleniumCheckTarget = seleniumCheckTarget = checkSettings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)checkSettings : null;
            if (seleniumCheckTarget != null) {
                seleniumCheckTarget.init(this.logger, this.driver);
            }
            String name = checkSettingsInternal.getName();
            this.logger.verbose(String.format("check(\"%s\", checkSettings) - begin", name));
            this.stitchContent = checkSettingsInternal.getStitchContent() == null ? false : checkSettingsInternal.getStitchContent();
            final Region targetRegion = checkSettingsInternal.getTargetRegion();
            this.logger.verbose("setting scrollRootElement...");
            this.scrollRootElement = EyesSeleniumUtils.getScrollRootElement(this.logger, this.driver, seleniumCheckTarget);
            WebElement defaultRootElement = null;
            if (!isMobileDevice) {
                defaultRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            }
            this.logger.verbose("scrollRootElement_ set to " + this.scrollRootElement);
            this.elementPositionProvider = null;
            this.currentFramePositionProvider = null;
            this.positionProviderHandler.set((Object)PositionProviderFactory.getPositionProvider(this.logger, this.getConfigurationInstance().getStitchMode(), this.jsExecutor, this.scrollRootElement, this.userAgent));
            this.originalFC = this.driver.getFrameChain().clone();
            int switchedToFrameCount = this.switchToFrame(seleniumCheckTarget);
            this.logger.verbose("switchedToFrameCount: " + switchedToFrameCount);
            EyesTargetLocator switchTo = null;
            String source = null;
            if (!isMobileDevice) {
                switchTo = (EyesTargetLocator)this.driver.switchTo();
                source = this.driver.getCurrentUrl();
            }
            FrameChain originalFC = this.tryHideScrollbars();
            if (targetRegion != null && switchedToFrameCount == 0) {
                this.logger.verbose("have target region");
                this.checkWindowBase(new RegionProvider(){

                    public Region getRegion(ICheckSettingsInternal settings) {
                        return new Region(targetRegion.getLocation(), targetRegion.getSize(), CoordinatesType.CONTEXT_RELATIVE);
                    }
                }, name, false, checkSettings, source);
            } else if (seleniumCheckTarget != null) {
                WebElement targetElement = this.getTargetElement(seleniumCheckTarget);
                if (targetElement != null) {
                    this.logger.verbose("have target element");
                    this.targetElement = targetElement;
                    this.checkElement(this.targetElement, name, checkSettings, source);
                } else if (!(isMobileDevice || seleniumCheckTarget.getFrameChain().size() <= 0 && this.scrollRootElement.equals(defaultRootElement))) {
                    this.logger.verbose("have frame chain");
                    if (this.stitchContent) {
                        this.targetElement = this.getCurrentFrameScrollRootElement();
                    } else {
                        FrameChain frameChain = this.driver.getFrameChain().clone();
                        Frame targetFrame = frameChain.pop();
                        if (targetFrame != null) {
                            this.targetElement = targetFrame.getReference();
                            switchTo.parentFrame();
                        } else {
                            this.targetElement = this.scrollRootElement;
                        }
                    }
                    this.checkElement(this.targetElement, name, checkSettings, source);
                } else {
                    this.logger.verbose("default case");
                    if (!isMobileDevice) {
                        switchTo.defaultContent();
                    }
                    Location curPos = null;
                    this.currentFramePositionProvider = PositionProviderFactory.getPositionProvider(this.logger, this.getConfigurationInstance().getStitchMode(), this.jsExecutor, this.scrollRootElement, this.userAgent);
                    if (!isMobileDevice && this.stitchContent) {
                        String curPosStr = (String)this.driver.executeScript("var e = document.documentElement; var curPos = e.scrollLeft+';'+e.scrollTop; if (e.scrollTo) {e.scrollTo(0,0);} else {e.scrollTop=0;e.scrollLeft=0;} return curPos;", new Object[0]);
                        curPos = EyesDriverUtils.parseLocationString((Object)curPosStr);
                    }
                    this.checkWindowBase(RegionProvider.NULL_INSTANCE, name, false, checkSettings, source);
                    if (!isMobileDevice) {
                        if (this.stitchContent) {
                            this.driver.executeScript("var e = document.documentElement; if (e.scrollTo) {e.scrollTo(" + curPos.getX() + "," + curPos.getY() + ");} else {e.scrollLeft=" + curPos.getX() + ";e.scrollTop=" + curPos.getX() + ";}", new Object[0]);
                        }
                        switchTo.frames(originalFC);
                    }
                }
                this.targetElement = null;
            }
            while (switchedToFrameCount > 0) {
                this.driver.switchTo().parentFrame();
                --switchedToFrameCount;
            }
            if (this.positionMemento != null) {
                ((PositionProvider)this.positionProviderHandler.get()).restoreState(this.positionMemento);
                this.positionMemento = null;
            }
            if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
                switchTo.resetScroll();
                if (originalFC != null) {
                    this.tryRestoreScrollbars(originalFC);
                }
                switchTo.frames(this.originalFC);
            }
            this.stitchContent = false;
        }
        catch (Exception ex) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)ex);
            throw ex;
        }
    }

    public void closeBatch(String batchId) {
        this.serverConnector.closeBatch(batchId);
    }

    protected MatchResult checkFrameFluent(String name, ICheckSettings checkSettings, String source) {
        FrameChain frameChain = this.driver.getFrameChain().clone();
        Frame targetFrame = frameChain.pop();
        this.targetElement = targetFrame.getReference();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        switchTo.framesDoScroll(frameChain);
        MatchResult result = this.checkRegion(name, checkSettings, source);
        this.targetElement = null;
        return result;
    }

    private int switchToFrame(ISeleniumCheckTarget checkTarget) {
        if (checkTarget == null) {
            return 0;
        }
        List<FrameLocator> frameChain = checkTarget.getFrameChain();
        int switchedToFrameCount = 0;
        for (FrameLocator frameLocator : frameChain) {
            if (!this.switchToFrame(frameLocator)) continue;
            ++switchedToFrameCount;
        }
        return switchedToFrameCount;
    }

    private boolean switchToFrame(ISeleniumFrameCheckTarget frameTarget) {
        WebElement frameElement;
        WebDriver.TargetLocator switchTo = this.driver.switchTo();
        if (frameTarget.getFrameIndex() != null) {
            switchTo.frame(frameTarget.getFrameIndex().intValue());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameNameOrId() != null) {
            switchTo.frame(frameTarget.getFrameNameOrId());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameReference() != null) {
            switchTo.frame(frameTarget.getFrameReference());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameSelector() != null && (frameElement = this.driver.findElement(frameTarget.getFrameSelector())) != null) {
            switchTo.frame(frameElement);
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        return false;
    }

    private void updateFrameScrollRoot(IScrollRootElementContainer frameTarget) {
        WebElement rootElement = EyesSeleniumUtils.getScrollRootElement(this.logger, this.driver, frameTarget);
        Frame frame = this.driver.getFrameChain().peek();
        frame.setScrollRootElement(rootElement);
    }

    private FrameChain ensureFrameAndElementVisible(List<PositionProviderAndMemento> ppams, EyesRemoteWebElement element, Region elementBounds) {
        this.logger.verbose("scrollRootElement_: " + this.scrollRootElement);
        FrameChain currentFC = this.driver.getFrameChain().clone();
        WebDriver.TargetLocator switchTo = this.driver.switchTo();
        switchTo.defaultContent();
        Frame parentFrame = null;
        for (Frame frame : currentFC) {
            WebElement scrollRootElement;
            this.driver.executeScript("window.scrollTo(0,0);", new Object[0]);
            FrameChain fc = this.driver.getFrameChain().clone();
            if (fc.size() == this.originalFC.size()) {
                this.logger.verbose("PositionProvider: " + this.positionProviderHandler.get());
                this.positionMemento = ((PositionProvider)this.positionProviderHandler.get()).getState();
                this.logger.verbose("scrollRootElement_: " + this.scrollRootElement);
                scrollRootElement = this.scrollRootElement;
            } else {
                scrollRootElement = parentFrame == null ? EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver) : parentFrame.getScrollRootElement();
            }
            this.logger.verbose("scrollRootElement: " + scrollRootElement);
            PositionProvider positionProvider = this.getElementPositionProvider(scrollRootElement);
            PositionMemento positionMemento = positionProvider.getState();
            Location pos = positionProvider.setPosition(frame.getLocation());
            if (!(frame.getInnerSize().getHeight() <= this.effectiveViewport.getHeight() && frame.getInnerSize().getWidth() <= this.effectiveViewport.getWidth() || element == null || this.effectiveViewport.isIntersected(elementBounds) || this.effectiveViewport.contains(elementBounds))) {
                pos = positionProvider.setPosition(elementBounds.getLocation());
            }
            Location offsetPos = frame.getLocation();
            offsetPos.offset(-pos.getX(), -pos.getY());
            PositionProviderAndMemento ppam = new PositionProviderAndMemento(positionProvider, positionMemento, fc, offsetPos);
            ppams.add(ppam);
            Region reg = new Region(offsetPos, frame.getInnerSize());
            reg = reg.offset(this.effectiveViewport.getLeft(), this.effectiveViewport.getTop());
            this.effectiveViewport.intersect(reg);
            switchTo.frame(frame.getReference());
            parentFrame = frame;
        }
        this.driver.executeScript("window.scrollTo(0,0);", new Object[0]);
        return currentFC;
    }

    private List<PositionProviderAndMemento> ensureElementVisible(WebElement element) {
        ArrayList<PositionProviderAndMemento> ppams = new ArrayList<PositionProviderAndMemento>();
        if (this.targetElement == null || !this.getScrollToRegion()) {
            return ppams;
        }
        if (EyesDriverUtils.isMobileDevice((WebDriver)this.driver.getRemoteWebDriver())) {
            this.logger.log("NATIVE context identified, skipping 'ensure element visible'");
            return ppams;
        }
        FrameChain originalFC = this.driver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        EyesRemoteWebElement eyesRemoteWebElement = new EyesRemoteWebElement(this.logger, this.driver, element);
        Region elementBounds = eyesRemoteWebElement.getBounds();
        Location currentFrameOffset = originalFC.getCurrentFrameOffset();
        Region offsetElementBounds = elementBounds.offset(currentFrameOffset.getX(), currentFrameOffset.getY());
        Region viewportBounds = this.getViewportScrollBounds();
        this.logger.verbose("viewportBounds: " + viewportBounds + " ; elementBounds: " + elementBounds);
        if (!viewportBounds.contains(elementBounds)) {
            WebElement scrollRootElement;
            FrameChain fc;
            this.ensureFrameAndElementVisible(ppams, eyesRemoteWebElement, offsetElementBounds);
            Point location = element.getLocation();
            location.x -= viewportBounds.getLeft();
            location.y -= viewportBounds.getTop();
            Location elementLocation = new Location(location.getX(), location.getY());
            if (originalFC.size() > 0 && !element.equals(originalFC.peek().getReference())) {
                fc = originalFC;
                switchTo.frames(originalFC);
                scrollRootElement = this.getCurrentFrameScrollRootElement();
            } else {
                fc = this.driver.getFrameChain().clone();
                scrollRootElement = this.scrollRootElement;
            }
            PositionProvider positionProvider = this.getElementPositionProvider(scrollRootElement);
            PositionMemento positionMemento = positionProvider.getState();
            Location offsetElementLocation = elementLocation;
            for (PositionProviderAndMemento ppam : ppams) {
                offsetElementLocation.offset(ppam.getCurrentScrollPosition());
            }
            Location location2 = positionProvider.setPosition(offsetElementLocation);
        }
        return ppams;
    }

    private Region getViewportScrollBounds() {
        Location location;
        if (!this.getScrollToRegion()) {
            this.logger.log("WARNING: no region visibility strategy! returning an empty region!");
            return Region.EMPTY;
        }
        FrameChain originalFrameChain = this.driver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        switchTo.frames(this.originalFC);
        SeleniumScrollPositionProvider spp = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, this.scrollRootElement);
        try {
            location = spp.getCurrentPosition();
        }
        catch (EyesDriverOperationException e) {
            this.logger.log("WARNING: " + e.getMessage());
            this.logger.log("Assuming position is 0,0");
            location = new Location(0, 0);
        }
        Region viewportBounds = new Region(location, this.getViewportSize());
        switchTo.frames(originalFrameChain);
        return viewportBounds;
    }

    private MatchResult checkRegion(String name, ICheckSettings checkSettings, String source) {
        MatchResult result = this.checkWindowBase(new RegionProvider(){

            public Region getRegion(ICheckSettingsInternal settings) {
                Region r;
                EyesRemoteWebElement eyesTargetElement = (EyesRemoteWebElement)SeleniumEyes.this.targetElement;
                Region rect = settings.getTargetRegion();
                if (rect == null) {
                    Rectangle bounds = EyesDriverUtils.isMobileDevice((WebDriver)SeleniumEyes.this.driver) ? eyesTargetElement.getRect() : eyesTargetElement.getBoundingClientRect();
                    r = new Region(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), CoordinatesType.CONTEXT_RELATIVE);
                } else {
                    SizeAndBorders sizeAndBorders = eyesTargetElement.getSizeAndBorders();
                    RectangleSize s = sizeAndBorders.getSize();
                    Borders b = sizeAndBorders.getBorders();
                    Point p = SeleniumEyes.this.targetElement.getLocation();
                    p = p.moveBy(b.getLeft(), b.getTop());
                    Region r2 = rect;
                    int x = p.getX() + r2.getLeft();
                    int y = p.getY() + r2.getTop();
                    int w = Math.min(p.getX() + s.getWidth(), r2.getRight()) - x;
                    int h = Math.min(p.getY() + s.getHeight(), r2.getBottom()) - y;
                    r = new Region(x, y, w, h, CoordinatesType.CONTEXT_RELATIVE);
                }
                return r;
            }
        }, name, false, checkSettings, source);
        this.logger.verbose("Done! trying to scroll back to original position.");
        return result;
    }

    protected ScaleProviderFactory updateScalingParams() {
        if (this.scaleProviderHandler.get() instanceof NullScaleProvider) {
            ScaleProviderFactory factory;
            this.logger.verbose("Trying to extract device pixel ratio...");
            if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
                try {
                    this.devicePixelRatio = EyesDriverUtils.getDevicePixelRatio((IEyesJsExecutor)this.jsExecutor);
                }
                catch (Exception e) {
                    this.logger.verbose("Failed to extract device pixel ratio! Using default.");
                    this.devicePixelRatio = 1.0;
                }
                this.logger.verbose("Setting web scale provider...");
                factory = this.getScaleProviderFactory();
            } else {
                this.logger.verbose("Native App");
                this.devicePixelRatio = 1.0;
                this.logger.verbose("Setting native app scale provider...");
                factory = new FixedScaleProviderFactory(this.logger, 1.0 / this.devicePixelRatio, this.scaleProviderHandler);
            }
            this.logger.verbose(String.format("Device pixel ratio: %f", this.devicePixelRatio));
            this.logger.verbose("Done!");
            return factory;
        }
        SimplePropertyHandler nullProvider = new SimplePropertyHandler();
        return new ScaleProviderIdentityFactory(this.logger, (ScaleProvider)this.scaleProviderHandler.get(), (PropertyHandler)nullProvider);
    }

    private ScaleProviderFactory getScaleProviderFactory() {
        WebElement element = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        RectangleSize entireSize = EyesDriverUtils.getEntireElementSize((Logger)this.logger, (IEyesJsExecutor)this.jsExecutor, (WebElement)element);
        return new ContextBasedScaleProviderFactory(this.logger, entireSize, this.getConfigurationInstance().getViewportSize(), this.devicePixelRatio, false, (PropertyHandler<ScaleProvider>)this.scaleProviderHandler);
    }

    public WebElement getCurrentFrameScrollRootElement() {
        FrameChain fc = this.driver.getFrameChain().clone();
        Frame currentFrame = fc.peek();
        WebElement scrollRootElement = null;
        if (currentFrame != null) {
            scrollRootElement = currentFrame.getScrollRootElement();
        } else if (FrameChain.isSameFrameChain(fc, this.originalFC)) {
            scrollRootElement = this.scrollRootElement;
        }
        if (scrollRootElement == null) {
            scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        }
        return scrollRootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCurrentFrame(int matchTimeout, String tag, String source) {
        try {
            this.logger.verbose(String.format("CheckCurrentFrame(%d, '%s')", matchTimeout, tag));
            this.checkFrameOrElement = true;
            this.logger.verbose("Getting screenshot as base64..");
            String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            this.logger.verbose("Done! Creating image object...");
            BufferedImage screenshotImage = ImageUtils.imageFromBase64((String)screenshot64);
            ScaleProvider scaleProvider = this.updateScalingParams().getScaleProvider(screenshotImage.getWidth());
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (double)scaleProvider.getScaleRatio());
            this.logger.verbose("Done! Building required object...");
            EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            this.logger.verbose("Done!");
            this.logger.verbose("replacing regionToCheck");
            this.setRegionToCheck(screenshot.getFrameWindow());
            super.checkWindowBase(RegionProvider.NULL_INSTANCE, tag, false, matchTimeout, source);
        }
        finally {
            this.checkFrameOrElement = false;
            this.regionToCheck = null;
        }
    }

    public void checkFrame(String frameNameOrId) {
        this.check((String)null, (ICheckSettings)Target.frame(frameNameOrId));
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).fully());
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).timeout(matchTimeout).fully());
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, -1, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%d, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        ArgumentGuard.greaterThanOrEqualToZero((long)frameIndex, (String)"frameIndex");
        this.logger.log(String.format("CheckFrame(%d, %d, '%s')", frameIndex, matchTimeout, tag));
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).timeout(matchTimeout));
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.timeout(matchTimeout).fully());
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    private MatchResult checkElement(WebElement element, String name, ICheckSettings checkSettings, String source) {
        Location offset;
        Region bounds;
        Frame frame;
        EyesRemoteWebElement eyesElement;
        EyesRemoteWebElement eyesRemoteWebElement = eyesElement = element instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)element : new EyesRemoteWebElement(this.logger, this.driver, element);
        if (EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            return this.checkNativeElement(eyesElement, name, checkSettings, source);
        }
        String displayStyle = eyesElement.getComputedStyle("display");
        RectangleSize clientSize = eyesElement.getClientSize();
        String originalOverflow = null;
        if (this.stitchContent && !displayStyle.equalsIgnoreCase("inline") && (clientSize.getHeight() <= this.effectiveViewport.getHeight() && clientSize.getWidth() < this.effectiveViewport.getWidth() || clientSize.getHeight() < this.effectiveViewport.getHeight() && clientSize.getWidth() <= this.effectiveViewport.getWidth())) {
            this.logger.verbose("setting this.elementPositionProvider.");
            this.elementPositionProvider = new ElementPositionProvider(this.logger, this.driver, (WebElement)eyesElement);
            originalOverflow = eyesElement.setOverflow("hidden");
        } else {
            this.elementPositionProvider = null;
        }
        RectangleSize scrollSize = eyesElement.getScrollSize();
        this.logger.verbose(String.format("displayStyle: %s ; scrollSize: %s ; clientSize %s ; effectiveViewport size: %s", displayStyle, scrollSize, clientSize, this.effectiveViewport.getSize()));
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        FrameChain fc = this.driver.getFrameChain().clone();
        ArrayList<BoundsAndBorders> boundsList = new ArrayList<BoundsAndBorders>();
        ArrayList<PositionProviderAndMemento> ppams = new ArrayList<PositionProviderAndMemento>();
        Rectangle elementBoundsRect = eyesElement.getBoundingClientRect();
        Region elementBounds = new Region(elementBoundsRect.x, elementBoundsRect.y, elementBoundsRect.width, elementBoundsRect.height);
        SizeAndBorders sizeAndBorders = eyesElement.getSizeAndBorders();
        if (this.stitchContent && this.elementPositionProvider != null) {
            Borders borders = sizeAndBorders.getBorders();
            elementBounds = elementBounds.offset(borders.getLeft(), borders.getTop());
            elementBounds.setWidth(elementBounds.getWidth() - borders.getHorizontal());
            elementBounds.setHeight(elementBounds.getHeight() - borders.getVertical());
        }
        Region originalElementBounds = new Region((IRegion)elementBounds);
        Region fullElementBounds = new Region((IRegion)elementBounds);
        if (this.stitchContent) {
            fullElementBounds.setWidth(Math.max(fullElementBounds.getWidth(), scrollSize.getWidth()));
            fullElementBounds.setHeight(Math.max(fullElementBounds.getHeight(), scrollSize.getHeight()));
        }
        this.logger.verbose("elementBounds: " + elementBounds);
        this.logger.verbose("fullElementBounds: " + fullElementBounds);
        PositionProvider positionProvider = null;
        PositionMemento memento = null;
        Borders borders = new Borders();
        for (int i = fc.size() - 1; i >= 0; --i) {
            frame = fc.getAt(i);
            bounds = frame.getBounds();
            borders = frame.getBorderWidths();
            if (!bounds.contains(fullElementBounds)) {
                this.logger.verbose("bounds outside effective viewport.");
                WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
                FrameChain currentFC = this.driver.getFrameChain().clone();
                positionProvider = this.getElementPositionProvider(scrollRootElement);
                memento = positionProvider.getState();
                Location location = new Location(elementBounds.getLeft(), elementBounds.getTop());
                offset = positionProvider.setPosition(location);
                elementBounds = elementBounds.offset(-offset.getX(), -offset.getY());
                fullElementBounds = fullElementBounds.offset(-offset.getX(), -offset.getY());
                this.logger.verbose("offset: " + offset);
                if (currentFC != fc) {
                    PositionProviderAndMemento ppam = new PositionProviderAndMemento(positionProvider, memento, currentFC, offset);
                    ppams.add(ppam);
                }
            }
            this.logger.verbose("bounds: " + bounds);
            this.logger.verbose("Element region (before intersection with effective viewport): " + this.regionToCheck);
            elementBounds = elementBounds.offset(bounds.getLeft(), bounds.getTop());
            elementBounds = elementBounds.offset(borders.getLeft(), borders.getTop());
            fullElementBounds = fullElementBounds.offset(bounds.getLeft(), bounds.getTop());
            fullElementBounds = fullElementBounds.offset(borders.getLeft(), borders.getTop());
            boundsList.add(new BoundsAndBorders(bounds, borders));
            switchTo.parentFrame();
        }
        if (!this.effectiveViewport.contains(elementBounds)) {
            this.logger.verbose("bounds outside effective viewport.");
            WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
            if (scrollRootElement instanceof EyesRemoteWebElement) {
                EyesRemoteWebElement eyesScrollRootElement = (EyesRemoteWebElement)scrollRootElement;
                Rectangle sreBounds = eyesScrollRootElement.getBoundingClientRect();
                Region sreBoundsRegion = new Region(sreBounds.x, sreBounds.y, sreBounds.width, sreBounds.height);
                this.effectiveViewport.intersect(sreBoundsRegion);
            }
            positionProvider = this.getElementPositionProvider(scrollRootElement);
            memento = positionProvider.getState();
            elementBounds = elementBounds.offset(memento.getX(), memento.getY());
            fullElementBounds = fullElementBounds.offset(memento.getX(), memento.getY());
            Location elementLocation = elementBounds.getLocation();
            elementLocation = elementLocation.offset(-this.effectiveViewport.getLeft(), -this.effectiveViewport.getTop());
            offset = positionProvider.setPosition(elementLocation);
            this.logger.verbose("offset: " + offset);
            elementBounds = elementBounds.offset(-offset.getX(), -offset.getY());
            fullElementBounds = fullElementBounds.offset(-offset.getX(), -offset.getY());
            if (fc.size() > 0) {
                bounds = fc.getAt(0).getBounds();
                boundsList.add(new BoundsAndBorders(bounds, new Borders()));
            }
        }
        if (!this.stitchContent) {
            elementBounds.intersect(this.effectiveViewport);
            fullElementBounds.intersect(this.effectiveViewport);
        }
        Region viewport = new Region((IRegion)elementBounds);
        if (fc.size() > 0) {
            frame = fc.peek();
            viewport.setSize(frame.getInnerSize());
            switchTo.frames(fc);
            viewport.intersect(elementBounds);
        } else {
            WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
            if (scrollRootElement instanceof EyesRemoteWebElement) {
                EyesRemoteWebElement eyesScrollRootElement = (EyesRemoteWebElement)scrollRootElement;
                Rectangle sreBounds = eyesScrollRootElement.getBoundingClientRect();
                Region sreBoundsRegion = new Region(sreBounds.x, sreBounds.y, sreBounds.width, sreBounds.height);
                viewport.intersect(sreBoundsRegion);
            }
        }
        this.regionToCheck = new Region((IRegion)viewport);
        this.fullRegionToCheck = new Region((IRegion)fullElementBounds);
        this.effectiveViewport = new Region((IRegion)viewport);
        MatchResult result = this.checkWindowBase(new RegionProvider(){

            public Region getRegion(ICheckSettingsInternal settings) {
                Region result = settings.getTargetRegion();
                if (result == null) {
                    result = Region.EMPTY;
                }
                return result;
            }
        }, name, false, checkSettings, source);
        if (positionProvider != null) {
            switchTo.defaultContent();
            positionProvider.restoreState(memento);
        }
        for (PositionProviderAndMemento ppam : ppams) {
            try {
                switchTo.frames(ppam.getFrames());
                ppam.restoreState();
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
        switchTo.frames(fc);
        if (originalOverflow != null) {
            eyesElement.setOverflow(originalOverflow);
        }
        return result;
    }

    private MatchResult checkNativeElement(EyesRemoteWebElement eyesElement, String name, ICheckSettings checkSettings, String source) {
        final Rectangle rect = eyesElement.getRect();
        MatchResult result = this.checkWindowBase(new RegionProvider(){

            public Region getRegion(ICheckSettingsInternal settings) {
                Region result = settings.getTargetRegion();
                if (result == null) {
                    result = new Region(rect.x, rect.y, rect.width, rect.height);
                }
                return result;
            }
        }, name, false, checkSettings, source);
        return result;
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.check((String)null, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully());
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        elementRegion = this.lastScreenshot.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        this.addMouseTriggerBase(action, elementRegion, elementRegion.getMiddleOffset());
    }

    public void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring '%s' (different frame)", text));
            return;
        }
        this.addTextTriggerBase(control, text);
    }

    public void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        this.addTextTrigger(elementRegion, text);
    }

    public RectangleSize getViewportSize() {
        RectangleSize vpSize;
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            if (this.imageProvider instanceof MobileScreenshotImageProvider) {
                BufferedImage image = this.imageProvider.getImage();
                vpSize = new RectangleSize((int)Math.round((double)image.getWidth() / this.devicePixelRatio), (int)Math.round((double)image.getHeight() / this.devicePixelRatio));
            } else {
                vpSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)this.driver);
            }
        } else {
            vpSize = SeleniumEyes.getViewportSize((WebDriver)this.driver);
        }
        return vpSize;
    }

    static RectangleSize getViewportSize(WebDriver driver) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        return EyesDriverUtils.getViewportSizeOrDisplaySize((Logger)new Logger(), (WebDriver)driver);
    }

    protected Configuration setViewportSize(RectangleSize size) {
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            FrameChain originalFrame = this.driver.getFrameChain();
            this.driver.switchTo().defaultContent();
            try {
                EyesDriverUtils.setViewportSize((Logger)this.logger, (WebDriver)this.driver, (RectangleSize)size);
                this.effectiveViewport = new Region(Location.ZERO, size);
            }
            catch (EyesException e1) {
                ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e1);
                throw new TestFailedException("Failed to set the viewport size", (Throwable)e1);
            }
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        }
        this.getConfigurationInstance().setViewportSize(new RectangleSize(size.getWidth(), size.getHeight()));
        return this.getConfigurationInstance();
    }

    protected void beforeOpen() {
    }

    private FrameChain tryHideScrollbars() {
        if (EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            return new FrameChain(this.logger);
        }
        if (this.getConfigurationInstance().getHideScrollbars() || this.getConfigurationInstance().getStitchMode() == StitchMode.CSS && this.stitchContent) {
            FrameChain originalFC = this.driver.getFrameChain().clone();
            FrameChain fc = this.driver.getFrameChain().clone();
            Frame frame = fc.peek();
            if (fc.size() > 0) {
                while (fc.size() > 0) {
                    this.logger.verbose("fc.Count = " + fc.size());
                    if (this.stitchContent || fc.size() != originalFC.size()) {
                        if (frame != null) {
                            frame.hideScrollbars((WebDriver)this.driver);
                        } else {
                            this.logger.verbose("hiding scrollbars of element (1): " + this.scrollRootElement);
                            EyesDriverUtils.setOverflow((JavascriptExecutor)this.driver, (String)"hidden", (WebElement)this.scrollRootElement);
                        }
                    }
                    this.driver.switchTo().parentFrame();
                    fc.pop();
                    frame = fc.peek();
                }
            } else {
                this.logger.verbose("hiding scrollbars of element (2): " + this.scrollRootElement);
                this.originalOverflow = EyesDriverUtils.setOverflow((JavascriptExecutor)this.driver, (String)"hidden", (WebElement)this.scrollRootElement);
            }
            this.logger.verbose("switching back to original frame");
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
            this.logger.verbose("done hiding scrollbars.");
            return originalFC;
        }
        return new FrameChain(this.logger);
    }

    private void tryRestoreScrollbars(FrameChain frameChain) {
        if (EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            return;
        }
        if (this.getConfigurationInstance().getHideScrollbars() || this.getConfigurationInstance().getStitchMode() == StitchMode.CSS && this.stitchContent) {
            ((EyesTargetLocator)this.driver.switchTo()).frames(frameChain);
            FrameChain originalFC = frameChain.clone();
            FrameChain fc = frameChain.clone();
            if (fc.size() > 0) {
                while (fc.size() > 0) {
                    Frame frame = fc.pop();
                    frame.returnToOriginalOverflow((WebDriver)this.driver);
                    EyesTargetLocator.parentFrame(this.logger, this.driver.getRemoteWebDriver().switchTo(), fc);
                }
            } else {
                this.logger.verbose("returning overflow of element to its original value: " + this.scrollRootElement);
                EyesDriverUtils.setOverflow((JavascriptExecutor)this.driver, (String)this.originalOverflow, (WebElement)this.scrollRootElement);
            }
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
            this.logger.verbose("done restoring scrollbars.");
        } else {
            this.logger.verbose("no need to restore scrollbars.");
        }
        this.driver.getFrameChain().clear();
    }

    protected EyesScreenshot getScreenshot(ICheckSettingsInternal checkSettingsInternal) {
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        FrameChain originalFrameChain = this.driver.getFrameChain().clone();
        PositionProvider positionProvider = (PositionProvider)this.positionProviderHandler.get();
        EyesTargetLocator switchTo = null;
        PositionMemento originalPosition = null;
        boolean isMobileDevice = EyesDriverUtils.isMobileDevice((WebDriver)this.driver);
        if (!isMobileDevice) {
            switchTo = (EyesTargetLocator)this.driver.switchTo();
            switchTo.frames(this.originalFC);
            if (positionProvider != null) {
                originalPosition = positionProvider.getState();
            }
            switchTo.frames(originalFrameChain);
        }
        EyesWebDriverScreenshot result = null;
        Object activeElement = null;
        if (this.getConfigurationInstance().getHideCaret() && !isMobileDevice) {
            activeElement = this.driver.executeScript("var activeElement = document.activeElement; activeElement && activeElement.blur(); return activeElement;", new Object[0]);
        }
        result = (this.targetElement != null || this.shouldTakeFullPageScreenshot(checkSettingsInternal)) && !isMobileDevice ? this.getFrameOrElementScreenshot(scaleProviderFactory, originalFrameChain, switchTo) : this.getElementScreenshot(scaleProviderFactory, switchTo);
        if (this.getConfigurationInstance().getHideCaret() && activeElement != null) {
            switchTo.frames(originalFrameChain);
            this.driver.executeScript("arguments[0].focus();", activeElement);
        }
        if (!isMobileDevice) {
            result.setDomUrl(this.tryCaptureAndPostDom(checkSettingsInternal));
            switchTo.frames(this.originalFC);
            if (positionProvider != null) {
                positionProvider.restoreState(originalPosition);
            }
            switchTo.frames(originalFrameChain);
        }
        return result;
    }

    boolean shouldTakeFullPageScreenshot(ICheckSettingsInternal checkSettingsInternal) {
        Boolean isFully = checkSettingsInternal.getStitchContent();
        if (isFully != null) {
            return isFully;
        }
        Boolean isForceFullPage = this.getConfigurationInstance().getForceFullPageScreenshot();
        if (isForceFullPage == null) {
            return false;
        }
        return isForceFullPage;
    }

    private EyesWebDriverScreenshot getFrameOrElementScreenshot(ScaleProviderFactory scaleProviderFactory, FrameChain originalFrameChain, EyesTargetLocator switchTo) {
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory);
        this.logger.verbose("Check frame/element requested");
        switchTo.frames(originalFrameChain);
        ElementPositionProvider positionProvider = this.elementPositionProvider;
        WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
        if (positionProvider == null) {
            positionProvider = this.getElementPositionProvider(scrollRootElement);
        }
        if (positionProvider instanceof ISeleniumPositionProvider) {
            this.jsExecutor.executeScript("var e = arguments[0]; if (e != null) e.setAttribute('data-applitools-scroll','true');", ((ISeleniumPositionProvider)positionProvider).getScrolledElement());
        }
        BufferedImage entireFrameOrElement = algo.getStitchedRegion(this.regionToCheck, this.fullRegionToCheck, positionProvider);
        entireFrameOrElement = this.cropIfNeeded(entireFrameOrElement);
        this.logger.verbose("Building screenshot object...");
        RectangleSize size = new RectangleSize(entireFrameOrElement.getWidth(), entireFrameOrElement.getHeight());
        Location frameLocationInScreenshot = new Location(-this.regionToCheck.getLeft(), -this.regionToCheck.getTop());
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, entireFrameOrElement, size, frameLocationInScreenshot);
        return result;
    }

    private BufferedImage cropIfNeeded(BufferedImage image) {
        int maxImageHeight = this.renderInfo.getMaxImageHeight();
        int maxImageArea = this.renderInfo.getMaxImageArea();
        if (image.getHeight() <= maxImageHeight && image.getWidth() * image.getHeight() <= maxImageArea) {
            return image;
        }
        int trimmedHeight = Math.min(maxImageArea / image.getWidth(), maxImageHeight);
        Region newRegion = new Region(0, 0, image.getWidth(), trimmedHeight);
        if (newRegion.isSizeEmpty()) {
            return image;
        }
        image = ImageUtils.cropImage((Logger)this.logger, (BufferedImage)image, (Region)newRegion);
        this.debugScreenshotsProvider.save(image, "final");
        return image;
    }

    private EyesWebDriverScreenshot getElementScreenshot(ScaleProviderFactory scaleProviderFactory, EyesTargetLocator switchTo) {
        List<PositionProviderAndMemento> ppams = null;
        if (switchTo != null) {
            ppams = this.ensureElementVisible(this.targetElement);
        }
        try {
            Thread.sleep(this.getWaitBeforeScreenshots());
        }
        catch (InterruptedException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        EyesWebDriverScreenshot result = this.getScaledAndCroppedScreenshot(scaleProviderFactory);
        if (switchTo != null) {
            for (int i = ppams.size() - 1; i >= 0; --i) {
                PositionProviderAndMemento ppam = ppams.get(i);
                switchTo.frames(ppam.getFrames());
                ppam.restoreState();
            }
        }
        return result;
    }

    private EyesWebDriverScreenshot getScaledAndCroppedScreenshot(ScaleProviderFactory scaleProviderFactory) {
        BufferedImage screenshotImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
        CutProvider cutProvider = (CutProvider)this.cutProviderHandler.get();
        if (scaleProvider.getScaleRatio() != 1.0) {
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (double)scaleProvider.getScaleRatio());
            this.debugScreenshotsProvider.save(screenshotImage, "scaled");
            cutProvider.scale(scaleProvider.getScaleRatio());
        }
        if (!(cutProvider instanceof NullCutProvider)) {
            screenshotImage = cutProvider.cut(screenshotImage);
            this.debugScreenshotsProvider.save(screenshotImage, "cut");
        }
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
        return result;
    }

    private long getWaitBeforeScreenshots() {
        return this.getConfigurationInstance().getWaitBeforeScreenshots();
    }

    private void markElementForLayoutRCA(PositionProvider elemPositionProvider) {
        ISeleniumPositionProvider positionProvider = elemPositionProvider != null ? (ISeleniumPositionProvider)elemPositionProvider : (ISeleniumPositionProvider)this.getPositionProvider();
        WebElement scrolledElement = positionProvider.getScrolledElement();
        if (scrolledElement != null) {
            try {
                this.jsExecutor.executeScript("var e = arguments[0]; if (e != null) e.setAttribute('data-applitools-scroll','true');", scrolledElement);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
    }

    private FullPageCaptureAlgorithm createFullPageCaptureAlgorithm(ScaleProviderFactory scaleProviderFactory) {
        WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
        SeleniumScrollPositionProvider originProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
        ISizeAdjuster sizeAdjuster = ImageProviderFactory.getImageSizeAdjuster(this.userAgent, this.jsExecutor);
        this.getRenderingInfo();
        return new FullPageCaptureAlgorithm(this.logger, this.regionPositionCompensation, this.getConfigurationInstance().getWaitBeforeScreenshots(), this.debugScreenshotsProvider, this.screenshotFactory, (PositionProvider)originProvider, scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), this.getConfigurationInstance().getStitchOverlap(), this.imageProvider, sizeAdjuster);
    }

    protected String getTitle() {
        if (!this.doNotGetTitle && !EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                this.logger.verbose("failed (" + ex.getMessage() + ")");
                this.doNotGetTitle = true;
            }
        }
        return "";
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = super.getAppEnvironment();
        RemoteWebDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() == null) {
            this.logger.log("No OS set, checking for mobile OS...");
            if (EyesDriverUtils.isMobileDevice((WebDriver)underlyingDriver)) {
                String platformName = null;
                this.logger.log("Mobile device detected! Checking device type..");
                if (EyesDriverUtils.isAndroid((WebDriver)underlyingDriver)) {
                    this.logger.log("Android detected.");
                    platformName = "Android";
                } else if (EyesDriverUtils.isIOS((WebDriver)underlyingDriver)) {
                    this.logger.log("iOS detected.");
                    platformName = "iOS";
                } else {
                    this.logger.log("Unknown device type.");
                }
                if (platformName != null) {
                    String majorVersion;
                    String os = platformName;
                    String platformVersion = EyesDriverUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
                    if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                        os = os + " " + majorVersion;
                    }
                    this.logger.verbose("Setting OS: " + os);
                    appEnv.setOs(os);
                }
            } else {
                this.logger.log("No mobile OS detected.");
            }
        }
        this.logger.log("Done!");
        return appEnv;
    }

    public void setIsDisabled(Boolean disabled) {
        super.setIsDisabled(disabled);
    }

    private PositionProvider getElementPositionProvider(WebElement scrollRootElement) {
        EyesRemoteWebElement eyesScrollRootElement = (EyesRemoteWebElement)scrollRootElement;
        Object positionProvider = eyesScrollRootElement.getPositionProvider();
        if (positionProvider == null) {
            this.logger.verbose("creating a new position provider.");
            positionProvider = scrollRootElement.getTagName().equalsIgnoreCase("html") ? PositionProviderFactory.getPositionProvider(this.logger, this.getConfigurationInstance().getStitchMode(), this.jsExecutor, scrollRootElement, this.userAgent) : new ElementPositionProvider(this.logger, this.driver, (WebElement)eyesScrollRootElement);
            eyesScrollRootElement.setPositionProvider((PositionProvider)positionProvider);
        }
        this.logger.verbose("position provider: " + positionProvider);
        this.currentFramePositionProvider = positionProvider;
        return positionProvider;
    }

    protected String getAUTSessionId() {
        try {
            if (this.cachedAUTSessionId == null) {
                this.cachedAUTSessionId = this.driver.getRemoteWebDriver().getSessionId().toString();
            }
            return this.cachedAUTSessionId;
        }
        catch (Exception e) {
            this.logger.log("WARNING: Failed to get AUT session ID! (maybe driver is not available?). Error: " + e.getMessage());
            return "";
        }
    }

    @Override
    public TestResults close(boolean throwEx) {
        TestResults results;
        block3: {
            results = null;
            try {
                results = super.close(throwEx);
            }
            catch (Throwable e) {
                this.logger.log(e.getMessage());
                if (!throwEx) break block3;
                throw e;
            }
        }
        if (this.runner != null) {
            this.runner.aggregateResult(results);
        }
        this.cachedAUTSessionId = null;
        this.serverConnector.closeConnector();
        return results;
    }

    public Object getAgentSetup() {
        return new EyesSeleniumAgentSetup();
    }

    public Boolean isSendDom() {
        return !EyesDriverUtils.isMobileDevice((WebDriver)this.driver) && super.isSendDom() != false;
    }

    protected Configuration getConfigurationInstance() {
        return this.configurationProvider.get();
    }

    void setDebugScreenshotProvider(DebugScreenshotsProvider debugScreenshotProvider) {
        this.debugScreenshotsProvider = debugScreenshotProvider;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    class EyesSeleniumAgentSetup {
        private RemoteWebDriver remoteWebDriver;

        public EyesSeleniumAgentSetup() {
            this.remoteWebDriver = SeleniumEyes.this.driver.getRemoteWebDriver();
        }

        public String getSeleniumSessionId() {
            return this.remoteWebDriver.getSessionId().toString();
        }

        public WebDriverInfo getWebDriver() {
            return new WebDriverInfo();
        }

        public double getDevicePixelRatio() {
            return SeleniumEyes.this.getDevicePixelRatio();
        }

        public String getCutProvider() {
            return ((CutProvider)SeleniumEyes.this.cutProviderHandler.get()).getClass().getName();
        }

        public String getScaleProvider() {
            return ((ScaleProvider)SeleniumEyes.this.scaleProviderHandler.get()).getClass().getName();
        }

        public StitchMode getStitchMode() {
            return SeleniumEyes.this.getConfigurationInstance().getStitchMode();
        }

        public boolean getHideScrollbars() {
            return SeleniumEyes.this.getConfigurationInstance().getHideScrollbars();
        }

        public boolean getForceFullPageScreenshot() {
            Boolean forceFullPageScreenshot = SeleniumEyes.this.getConfigurationInstance().getForceFullPageScreenshot();
            if (forceFullPageScreenshot == null) {
                return false;
            }
            return forceFullPageScreenshot;
        }

        class WebDriverInfo {
            WebDriverInfo() {
            }

            public String getName() {
                return EyesSeleniumAgentSetup.this.remoteWebDriver.getClass().getName();
            }

            public Capabilities getCapabilities() {
                return EyesSeleniumAgentSetup.this.remoteWebDriver.getCapabilities();
            }
        }
    }

    public static interface WebDriverAction {
        public void drive(WebDriver var1);
    }
}

