/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.positioning.SeleniumScrollPositionProvider;
import org.openqa.selenium.WebElement;

public class EdgeBrowserScrollPositionProvider
extends SeleniumScrollPositionProvider {
    public EdgeBrowserScrollPositionProvider(Logger logger, IEyesJsExecutor executor, WebElement scrollRootElement) {
        super(logger, executor, scrollRootElement);
    }

    @Override
    public Location setPosition(Location location) {
        this.logger.verbose(String.format("setting position of %s to %s", this.scrollRootElement, location));
        Object position = this.executor.executeScript(String.format("window.scrollTo(%d,%d);return (window.scrollX+';'+window.scrollY);", location.getX(), location.getY()), new Object[]{this.scrollRootElement});
        return EyesDriverUtils.parseLocationString((Object)position);
    }

    @Override
    public Location getCurrentPosition() {
        Object position = this.executor.executeScript("return (window.scrollX+';'+window.scrollY);", new Object[]{this.scrollRootElement});
        return EyesDriverUtils.parseLocationString((Object)position);
    }
}

