/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.positioning.ElementPositionMemento;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;

public class ElementPositionProvider
implements PositionProvider,
ISeleniumPositionProvider {
    private final Logger logger;
    private final EyesRemoteWebElement element;

    public ElementPositionProvider(Logger logger, EyesSeleniumDriver driver, WebElement element) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.logger = logger;
        this.element = element instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)element : new EyesRemoteWebElement(logger, driver, element);
        logger.verbose("creating ElementPositionProvider");
    }

    public Location getCurrentPosition() {
        this.logger.verbose("getCurrentScrollPosition()");
        Location result = new Location(this.element.getScrollLeft(), this.element.getScrollTop());
        this.logger.verbose(String.format("Current position: %s", result));
        return result;
    }

    public Location setPosition(Location location) {
        this.logger.verbose(String.format("Scrolling element to %s", location));
        Location result = this.element.scrollTo(location);
        this.logger.verbose("Done scrolling element! result: " + result);
        return result;
    }

    public RectangleSize getEntireSize() {
        this.logger.verbose("enter");
        RectangleSize result = new RectangleSize(this.element.getScrollWidth(), this.element.getScrollHeight());
        this.logger.verbose("Entire size: " + result);
        return result;
    }

    public PositionMemento getState() {
        return new ElementPositionMemento(this.getCurrentPosition());
    }

    public void restoreState(PositionMemento state) {
        ElementPositionMemento s = (ElementPositionMemento)state;
        this.setPosition(new Location(s.getX(), s.getY()));
    }

    public EyesRemoteWebElement getElement() {
        return this.element;
    }

    @Override
    public WebElement getScrolledElement() {
        return this.element;
    }
}

