/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.triggers;

import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesKeyboard
implements Keyboard {
    private final Logger logger;
    private final EyesSeleniumDriver eyesDriver;
    private final Keyboard keyboard;

    public EyesKeyboard(Logger logger, EyesSeleniumDriver eyesDriver, Keyboard keyboard) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)eyesDriver, (String)"eyesDriver");
        ArgumentGuard.notNull((Object)keyboard, (String)"keyboard");
        this.logger = logger;
        this.eyesDriver = eyesDriver;
        this.keyboard = keyboard;
    }

    public void sendKeys(CharSequence ... charSequences) {
        Region control = Region.EMPTY;
        Object activeElement = this.eyesDriver.switchTo().activeElement();
        if (activeElement instanceof RemoteWebElement) {
            activeElement = new EyesRemoteWebElement(this.logger, this.eyesDriver, (WebElement)activeElement);
            control = ((EyesRemoteWebElement)((Object)activeElement)).getBounds();
        }
        for (CharSequence keys : charSequences) {
            String text = String.valueOf(keys);
            this.eyesDriver.getEyes().addTextTrigger(control, text);
        }
        this.keyboard.sendKeys(charSequences);
    }

    public void pressKey(CharSequence keyToPress) {
        this.keyboard.pressKey(keyToPress);
    }

    public void releaseKey(CharSequence keyToRelease) {
        this.keyboard.releaseKey(keyToRelease);
    }
}

