/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class EyesSeleniumUtils {
    public static WebElement getDefaultRootElement(Logger logger, EyesSeleniumDriver driver) {
        WebElement body;
        WebElement html = driver.findElement(By.tagName((String)"html"));
        EyesRemoteWebElement htmlElement = new EyesRemoteWebElement(logger, driver, html);
        try {
            body = driver.findElement(By.tagName((String)"body"));
        }
        catch (Throwable t) {
            logger.log("Failed finding the body element");
            return htmlElement;
        }
        EyesRemoteWebElement bodyElement = new EyesRemoteWebElement(logger, driver, body);
        if (htmlElement.getBoundingClientRect().height < bodyElement.getBoundingClientRect().height) {
            return bodyElement;
        }
        return htmlElement;
    }

    public static WebElement getScrollRootElement(Logger logger, EyesSeleniumDriver driver, IScrollRootElementContainer scrollRootElementContainer) {
        if (EyesDriverUtils.isMobileDevice((WebDriver)driver)) {
            return null;
        }
        if (scrollRootElementContainer == null) {
            return EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        WebElement scrollRootElement = scrollRootElementContainer.getScrollRootElement();
        if (scrollRootElement != null) {
            return scrollRootElement;
        }
        By scrollRootSelector = scrollRootElementContainer.getScrollRootSelector();
        if (scrollRootSelector != null) {
            return driver.findElement(scrollRootSelector);
        }
        logger.log("Warning: Got an empty scroll root element container");
        return EyesSeleniumUtils.getDefaultRootElement(logger, driver);
    }

    public static WebElement findFrameByFrameCheckTarget(FrameLocator frameTarget, EyesSeleniumDriver driver) {
        if (frameTarget.getFrameIndex() != null) {
            return driver.findElement(By.xpath((String)("IFRAME[" + frameTarget.getFrameIndex() + "]")));
        }
        String nameOrId = frameTarget.getFrameNameOrId();
        if (nameOrId != null) {
            List<WebElement> byId = driver.findElements(By.id((String)nameOrId));
            if (byId.size() > 0) {
                return byId.get(0);
            }
            return driver.findElement(By.name((String)nameOrId));
        }
        WebElement reference = frameTarget.getFrameReference();
        if (reference != null) {
            return reference;
        }
        By selector = frameTarget.getFrameSelector();
        if (selector != null) {
            return driver.findElement(selector);
        }
        return null;
    }

    public static WebElement getCurrentFrameScrollRootElement(Logger logger, EyesSeleniumDriver driver, WebElement userDefinedSRE) {
        WebElement scrollRootElement = EyesSeleniumUtils.tryGetCurrentFrameScrollRootElement(driver);
        if (scrollRootElement == null) {
            scrollRootElement = userDefinedSRE != null ? userDefinedSRE : EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        return scrollRootElement;
    }

    public static WebElement tryGetCurrentFrameScrollRootElement(EyesSeleniumDriver driver) {
        FrameChain fc = driver.getFrameChain().clone();
        Frame currentFrame = fc.peek();
        WebElement scrollRootElement = null;
        if (currentFrame != null) {
            scrollRootElement = currentFrame.getScrollRootElement();
        }
        return scrollRootElement;
    }
}

