/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.FrameState;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.ISeleniumFrameCheckTarget;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class PageState {
    private EyesSeleniumDriver driver;
    private Logger logger;
    private List<FrameState> frameStates;
    private FrameChain originalFrameChain;
    private StitchMode stitchMode;
    private UserAgent userAgent;

    public PageState(Logger logger, EyesSeleniumDriver driver, StitchMode stitchMode, UserAgent userAgent) {
        this.logger = logger;
        this.driver = driver;
        this.stitchMode = stitchMode;
        this.userAgent = userAgent;
    }

    public void preparePage(ISeleniumCheckTarget seleniumCheckTarget, Configuration config, WebElement userDefinedSRE) {
        this.frameStates = new ArrayList<FrameState>();
        this.originalFrameChain = this.driver.getFrameChain().clone();
        if (seleniumCheckTarget.getTargetElement() != null || seleniumCheckTarget.getTargetSelector() != null || seleniumCheckTarget.getFrameChain().size() > 0) {
            this.prepareParentFrames();
        }
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            PageState.saveCurrentFrameState(this.frameStates, this.driver, userDefinedSRE);
            PageState.tryHideScrollbarsInFrame(config, this.driver, userDefinedSRE);
            int switchedToFrameCount = this.switchToTargetFrame(seleniumCheckTarget, config, this.frameStates, userDefinedSRE);
            this.logger.verbose("switchedToFrameCount: " + switchedToFrameCount);
        }
    }

    private void prepareParentFrames() {
        if (this.originalFrameChain.size() == 0) {
            return;
        }
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        FrameChain fc = this.originalFrameChain.clone();
        while (fc.size() > 0) {
            switchTo.parentFrame();
            Frame currentFrame = fc.pop();
            WebElement rootElement = EyesSeleniumUtils.getCurrentFrameScrollRootElement(this.logger, this.driver, null);
            PageState.saveCurrentFrameState(this.frameStates, this.driver, rootElement);
            this.maximizeTargetFrameInCurrentFrame(currentFrame.getReference(), rootElement);
        }
        Collections.reverse(this.frameStates);
        switchTo.frames(this.originalFrameChain);
    }

    public void restorePageState() {
        if (EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            return;
        }
        Collections.reverse(this.frameStates);
        for (FrameState state : this.frameStates) {
            state.restore();
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(this.originalFrameChain);
    }

    private int switchToTargetFrame(ISeleniumCheckTarget checkTarget, Configuration config, List<FrameState> frameStates, WebElement userDefinedSRE) {
        List<FrameLocator> frameChain = checkTarget.getFrameChain();
        for (FrameLocator frameLocator : frameChain) {
            WebElement frameElement = EyesSeleniumUtils.findFrameByFrameCheckTarget(frameLocator, this.driver);
            this.maximizeTargetFrameInCurrentFrame(frameElement, userDefinedSRE);
            this.switchToFrame(frameElement, frameLocator, config, frameStates);
        }
        return frameChain.size();
    }

    private void maximizeTargetFrameInCurrentFrame(WebElement frameElement, WebElement userDefinedSRE) {
        WebElement currentFrameSRE = EyesSeleniumUtils.getCurrentFrameScrollRootElement(this.logger, this.driver, userDefinedSRE);
        PositionProvider positionProvider = SeleniumEyes.getPositionProviderForScrollRootElement(this.logger, this.driver, this.stitchMode, this.userAgent, currentFrameSRE);
        Region frameRect = EyesRemoteWebElement.getClientBoundsWithoutBorders(frameElement, this.driver, this.logger);
        if (this.stitchMode == StitchMode.SCROLL) {
            Location pageScrollPosition = positionProvider.getCurrentPosition();
            frameRect = frameRect.offset(pageScrollPosition.getX(), pageScrollPosition.getY());
        }
        positionProvider.setPosition(frameRect.getLocation());
    }

    private void switchToFrame(WebElement frameElement, ISeleniumFrameCheckTarget frameTarget, Configuration config, List<FrameState> frameStates) {
        WebDriver.TargetLocator switchTo = this.driver.switchTo();
        switchTo.frame(frameElement);
        WebElement rootElement = SeleniumEyes.getScrollRootElementFromSREContainer(this.logger, frameTarget, this.driver);
        Frame frame = this.driver.getFrameChain().peek();
        frame.setScrollRootElement(rootElement);
        PageState.saveCurrentFrameState(frameStates, this.driver, rootElement);
        PageState.tryHideScrollbarsInFrame(config, this.driver, rootElement);
        frame.setScrollRootElementInnerBounds(EyesRemoteWebElement.getClientBoundsWithoutBorders(rootElement, this.driver, this.logger));
    }

    private static void tryHideScrollbarsInFrame(Configuration config, EyesSeleniumDriver driver, WebElement rootElement) {
        if (config.getHideScrollbars()) {
            EyesDriverUtils.setOverflow((JavascriptExecutor)driver, (String)"hidden", (WebElement)rootElement);
        }
    }

    private static void saveCurrentFrameState(List<FrameState> frameStates, EyesSeleniumDriver driver, WebElement rootElement) {
        FrameState frameState = FrameState.getCurrentFrameState(driver, rootElement);
        frameStates.add(frameState);
    }
}

