/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Logger;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionProvider;
import com.applitools.eyes.selenium.positioning.EdgeBrowserScrollPositionProvider;
import com.applitools.eyes.selenium.positioning.SeleniumScrollPositionProvider;
import com.applitools.utils.ArgumentGuard;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebElement;

public class PositionProviderFactory {
    private static Map<WebElement, PositionProvider> positionProviders = new HashMap<WebElement, PositionProvider>();

    public static PositionProvider getPositionProvider(Logger logger, StitchMode stitchMode, IEyesJsExecutor executor, WebElement scrollRootElement) {
        PositionProvider positionProvider = positionProviders.get(scrollRootElement);
        if (positionProvider != null) {
            return positionProvider;
        }
        positionProvider = PositionProviderFactory.getPositionProvider(logger, stitchMode, executor, scrollRootElement, null);
        positionProviders.put(scrollRootElement, positionProvider);
        return positionProvider;
    }

    public static PositionProvider getPositionProvider(Logger logger, StitchMode stitchMode, IEyesJsExecutor executor, WebElement scrollRootElement, UserAgent userAgent) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        switch (stitchMode) {
            case CSS: {
                return new CssTranslatePositionProvider(logger, executor, scrollRootElement);
            }
            case SCROLL: {
                if (userAgent != null && userAgent.getBrowser().equalsIgnoreCase("Edge")) {
                    return new EdgeBrowserScrollPositionProvider(logger, executor, scrollRootElement);
                }
                return new SeleniumScrollPositionProvider(logger, executor, scrollRootElement);
            }
        }
        return null;
    }

    public static PositionProvider tryGetPositionProviderForElement(WebElement element) {
        return positionProviders.get(element);
    }
}

