/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.Logger;
import com.applitools.eyes.visualgrid.model.CssTokenizer;
import com.applitools.utils.GeneralUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;

class CssTreeNode {
    private final String css;
    private final Map<String, CssTreeNode> childNodes = new HashMap<String, CssTreeNode>();
    private final List<CssRule> cssRules = new ArrayList<CssRule>();

    CssTreeNode(String css) {
        this.css = css;
    }

    List<String> getImportedUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        for (CssRule rule : this.cssRules) {
            if (!rule.type.equals((Object)CssRuleType.IMPORT)) continue;
            urls.add(rule.value);
        }
        return urls;
    }

    void addChildNode(String uri, CssTreeNode node) {
        this.childNodes.put(uri, node);
    }

    void parse(Logger logger) {
        CSSRuleList ruleList;
        if (this.css == null || this.css.isEmpty()) {
            return;
        }
        try {
            ruleList = CssTokenizer.getCssRules((String)this.css);
        }
        catch (IOException e) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Throwable)e);
            return;
        }
        for (int i = 0; i < ruleList.getLength(); ++i) {
            CSSRule rule = ruleList.item(i);
            if (rule instanceof CSSImportRule) {
                String url = ((CSSImportRule)rule).getHref();
                this.cssRules.add(new CssRule(CssRuleType.IMPORT, url));
            }
            if (!(rule instanceof CSSStyleRule)) continue;
            this.cssRules.add(new CssRule(CssRuleType.STYLE, rule.toString()));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        block4: for (CssRule rule : this.cssRules) {
            switch (rule.type) {
                case IMPORT: {
                    sb.append(this.childNodes.get(rule.value).toString());
                    continue block4;
                }
                case STYLE: {
                    sb.append(rule.value);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException(String.format("No such type %s", new Object[]{rule.type}));
        }
        return sb.toString();
    }

    static class CssRule {
        private final CssRuleType type;
        private final String value;

        CssRule(CssRuleType type, String value) {
            this.type = type;
            this.value = value;
        }
    }

    static enum CssRuleType {
        IMPORT,
        STYLE;

    }
}

