/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.SubregionForStitching;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.capture.ISizeAdjuster;
import com.applitools.eyes.selenium.capture.NullSizeAdjuster;
import com.applitools.eyes.selenium.positioning.NullRegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class FullPageCaptureAlgorithm {
    private static final int MIN_SCREENSHOT_PART_SIZE = 10;
    private final Logger logger;
    private final RegionPositionCompensation regionPositionCompensation;
    private final int waitBeforeScreenshots;
    private final DebugScreenshotsProvider debugScreenshotsProvider;
    private final EyesScreenshotFactory screenshotFactory;
    private final ScaleProviderFactory scaleProviderFactory;
    private final CutProvider cutProvider;
    private final int stitchingOverlap;
    private final ImageProvider imageProvider;
    private final ISizeAdjuster sizeAdjuster;
    private final int maxHeight;
    private final int maxArea;

    public FullPageCaptureAlgorithm(Logger logger, RegionPositionCompensation regionPositionCompensation, int waitBeforeScreenshots, DebugScreenshotsProvider debugScreenshotsProvider, EyesScreenshotFactory screenshotFactory, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, int stitchingOverlap, ImageProvider imageProvider, int maxHeight, int maxArea, ISizeAdjuster sizeAdjuster) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.waitBeforeScreenshots = waitBeforeScreenshots;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
        this.screenshotFactory = screenshotFactory;
        this.scaleProviderFactory = scaleProviderFactory;
        this.cutProvider = cutProvider;
        this.stitchingOverlap = stitchingOverlap;
        this.imageProvider = imageProvider;
        this.sizeAdjuster = sizeAdjuster != null ? sizeAdjuster : NullSizeAdjuster.getInstance();
        this.maxHeight = maxHeight;
        this.maxArea = maxArea;
        this.regionPositionCompensation = regionPositionCompensation != null ? regionPositionCompensation : new NullRegionPositionCompensation();
    }

    private void saveDebugScreenshotPart(BufferedImage image, Region region, String name) {
        String suffix = String.format("part-%s-%d_%d_%dx%d", name, region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
        this.debugScreenshotsProvider.save(image, suffix);
    }

    public BufferedImage getStitchedRegion(Region region, Region fullarea, PositionProvider positionProvider, PositionProvider originProvider, RectangleSize stitchOffset) {
        Rectangle rectInScreenshot;
        Region sourceRegion;
        ArgumentGuard.notNull((Object)region, (String)"region");
        ArgumentGuard.notNull((Object)positionProvider, (String)"positionProvider");
        this.logger.verbose(String.format("region: %s ; fullArea: %s ; positionProvider: %s", region, fullarea, positionProvider.getClass().getName()));
        PositionMemento originalPosition = originProvider.getState();
        PositionMemento originalStitchedState = positionProvider.getState();
        this.logger.verbose("region size: " + region);
        originProvider.setPosition(Location.ZERO);
        try {
            Thread.sleep(this.waitBeforeScreenshots);
        }
        catch (InterruptedException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        BufferedImage initialScreenshot = this.imageProvider.getImage();
        RectangleSize initialSize = new RectangleSize(initialScreenshot.getWidth(), initialScreenshot.getHeight());
        this.saveDebugScreenshotPart(initialScreenshot, region, "initial");
        ScaleProvider scaleProvider = this.scaleProviderFactory.getScaleProvider(initialScreenshot.getWidth());
        double pixelRatio = 1.0 / scaleProvider.getScaleRatio();
        RectangleSize initialSizeScaled = new RectangleSize((int)Math.round((double)initialScreenshot.getWidth() / pixelRatio), (int)Math.round((double)initialScreenshot.getHeight() / pixelRatio));
        CutProvider scaledCutProvider = this.cutProvider.scale(pixelRatio);
        if (pixelRatio != 1.0 && !(scaledCutProvider instanceof NullCutProvider)) {
            initialScreenshot = this.cutProvider.cut(initialScreenshot);
            this.debugScreenshotsProvider.save(initialScreenshot, "original-cut");
        }
        Region regionInScreenshot = this.getRegionInScreenshot(region, initialScreenshot, pixelRatio);
        BufferedImage croppedInitialScreenshot = this.cropScreenshot(initialScreenshot, regionInScreenshot);
        this.debugScreenshotsProvider.save(croppedInitialScreenshot, "cropped");
        BufferedImage scaledInitialScreenshot = ImageUtils.scaleImage((BufferedImage)croppedInitialScreenshot, (double)scaleProvider.getScaleRatio());
        if (scaledInitialScreenshot != croppedInitialScreenshot) {
            this.saveDebugScreenshotPart(scaledInitialScreenshot, regionInScreenshot, "scaled");
        }
        if (fullarea.isEmpty()) {
            RectangleSize entireSize;
            try {
                entireSize = positionProvider.getEntireSize();
                this.logger.verbose("Entire size of region context: " + entireSize);
            }
            catch (EyesException e) {
                this.logger.log("WARNING: Failed to extract entire size of region context" + e.getMessage());
                this.logger.log("Using image size instead: " + scaledInitialScreenshot.getWidth() + "x" + scaledInitialScreenshot.getHeight());
                entireSize = new RectangleSize(scaledInitialScreenshot.getWidth(), scaledInitialScreenshot.getHeight());
            }
            if (scaledInitialScreenshot.getWidth() >= entireSize.getWidth() && scaledInitialScreenshot.getHeight() >= entireSize.getHeight()) {
                this.logger.log("WARNING: Seems the image is already a full page screenshot.");
                originProvider.restoreState(originalPosition);
                return scaledInitialScreenshot;
            }
            fullarea = new Region(Location.ZERO, entireSize, CoordinatesType.SCREENSHOT_AS_IS);
        }
        float currentFullWidth = fullarea.getWidth();
        fullarea = this.sizeAdjuster.adjustRegion(fullarea, initialSizeScaled);
        float sizeRatio = currentFullWidth / (float)fullarea.getWidth();
        this.logger.verbose("adjusted fullarea: " + fullarea);
        Location scaledCropLocation = fullarea.getLocation();
        Location physicalCropLocation = new Location((int)Math.ceil((double)scaledCropLocation.getX() * pixelRatio), (int)Math.ceil((double)scaledCropLocation.getY() * pixelRatio));
        if (regionInScreenshot.isSizeEmpty()) {
            RectangleSize physicalCropSize = new RectangleSize(initialSize.getWidth() - physicalCropLocation.getX(), initialSize.getHeight() - physicalCropLocation.getY());
            sourceRegion = new Region(physicalCropLocation, physicalCropSize);
        } else {
            sourceRegion = regionInScreenshot;
        }
        Region scaledCroppedSourceRect = this.cutProvider.toRegion(sourceRegion.getSize());
        scaledCroppedSourceRect = scaledCroppedSourceRect.offset(sourceRegion.getLeft(), sourceRegion.getTop());
        Rectangle scaledCroppedSourceRegion = new Rectangle((int)Math.ceil((double)scaledCroppedSourceRect.getLeft() / pixelRatio), (int)Math.ceil((double)scaledCroppedSourceRect.getTop() / pixelRatio), (int)Math.ceil((double)scaledCroppedSourceRect.getWidth() / pixelRatio), (int)Math.ceil((double)scaledCroppedSourceRect.getHeight() / pixelRatio));
        Dimension scaledCropSize = scaledCroppedSourceRegion.getSize();
        RectangleSize screenshotPartSize = new RectangleSize(Math.max((int)scaledCropSize.getWidth(), 10), Math.max((int)scaledCropSize.getHeight(), 10));
        this.logger.verbose("Screenshot part size: " + screenshotPartSize);
        if (regionInScreenshot.isSizeEmpty()) {
            int x = Math.max(0, fullarea.getLeft());
            int y = Math.max(0, fullarea.getTop());
            int w = Math.min(fullarea.getWidth(), (int)scaledCropSize.getWidth());
            int h = Math.min(fullarea.getHeight(), (int)scaledCropSize.getHeight());
            rectInScreenshot = new Rectangle((int)Math.round((double)x * pixelRatio), (int)Math.round((double)y * pixelRatio), (int)Math.round((double)w * pixelRatio), (int)Math.round((double)h * pixelRatio));
        } else {
            rectInScreenshot = new Rectangle(regionInScreenshot.getLeft(), regionInScreenshot.getTop(), regionInScreenshot.getWidth(), regionInScreenshot.getHeight());
        }
        fullarea = this.coerceImageSize(fullarea);
        SubregionForStitching[] screenshotParts = fullarea.getSubRegions(screenshotPartSize, this.stitchingOverlap, pixelRatio, rectInScreenshot, this.logger);
        BufferedImage stitchedImage = new BufferedImage(fullarea.getWidth(), fullarea.getHeight(), 6);
        this.stitchScreenshot(stitchOffset, positionProvider, screenshotParts, stitchedImage, scaleProvider.getScaleRatio(), scaledCutProvider, sizeRatio);
        positionProvider.restoreState(originalStitchedState);
        originProvider.restoreState(originalPosition);
        return stitchedImage;
    }

    private Region coerceImageSize(Region fullarea) {
        if (fullarea.getHeight() < this.maxHeight && fullarea.getArea() < this.maxArea) {
            this.logger.verbose("full area fits server limits.");
            return fullarea;
        }
        if (this.maxArea == 0 || this.maxHeight == 0) {
            this.logger.verbose("server limits unspecified.");
            return fullarea;
        }
        int trimmedHeight = Math.min(this.maxArea / fullarea.getWidth(), this.maxHeight);
        Region newRegion = new Region(fullarea.getLeft(), fullarea.getTop(), fullarea.getWidth(), trimmedHeight, fullarea.getCoordinatesType());
        if (newRegion.isSizeEmpty()) {
            this.logger.verbose("empty region after coerce. returning original.");
            return fullarea;
        }
        this.logger.verbose("coerced region: " + newRegion);
        return newRegion;
    }

    private BufferedImage cropScreenshot(BufferedImage initialScreenshot, Region regionInScreenshot) {
        if (!regionInScreenshot.isSizeEmpty()) {
            BufferedImage croppedInitialScreenshot;
            initialScreenshot = croppedInitialScreenshot = ImageUtils.cropImage((Logger)this.logger, (BufferedImage)initialScreenshot, (Region)regionInScreenshot);
            this.saveDebugScreenshotPart(croppedInitialScreenshot, regionInScreenshot, "cropped");
        }
        return initialScreenshot;
    }

    private void stitchScreenshot(RectangleSize stitchOffset, PositionProvider stitchProvider, SubregionForStitching[] screenshotParts, BufferedImage stitchedImage, double scaleRatio, CutProvider scaledCutProvider, float sizeRatio) {
        int index = 0;
        this.logger.verbose(String.format("enter: originalStitchedState: %s ; scaleRatio: %s", stitchOffset, scaleRatio));
        for (SubregionForStitching partRegion : screenshotParts) {
            this.logger.verbose("Part: " + partRegion);
            Point partAbsoluteLocationInCurrentFrame = partRegion.getScrollTo();
            partAbsoluteLocationInCurrentFrame.translate(stitchOffset.getWidth(), stitchOffset.getHeight());
            Location scrollPosition = new Location(Math.round((float)partAbsoluteLocationInCurrentFrame.x * sizeRatio), Math.round((float)partAbsoluteLocationInCurrentFrame.y * sizeRatio));
            Location originPosition = stitchProvider.setPosition(scrollPosition);
            int dx = scrollPosition.getX() - originPosition.getX();
            int dy = scrollPosition.getY() - originPosition.getY();
            Point partPastePosition = partRegion.getPastePhysicalLocation();
            partPastePosition.translate(dx, dy);
            try {
                Thread.sleep(this.waitBeforeScreenshots);
            }
            catch (InterruptedException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
            BufferedImage partImage = this.imageProvider.getImage();
            BufferedImage cutPart = scaledCutProvider.cut(partImage);
            Rectangle r = partRegion.getPhysicalCropArea();
            BufferedImage croppedPart = !r.isEmpty() ? ImageUtils.cropImage((Logger)this.logger, (BufferedImage)cutPart, (Region)new Region(r.x, r.y, r.width, r.height)) : cutPart;
            Rectangle r2 = partRegion.getLogicalCropArea();
            BufferedImage scaledPartImage = ImageUtils.scaleImage((BufferedImage)croppedPart, (double)scaleRatio);
            BufferedImage scaledCroppedPartImage = ImageUtils.cropImage((Logger)this.logger, (BufferedImage)scaledPartImage, (Region)new Region(r2.x, r2.y, r2.width, r2.height));
            this.debugScreenshotsProvider.save(partImage, "partImage-" + originPosition.getX() + "_" + originPosition.getY());
            this.debugScreenshotsProvider.save(scaledCroppedPartImage, "scaledCroppedPartImage-" + partPastePosition.getX() + "_" + partPastePosition.getY());
            this.logger.verbose("pasting part at " + partPastePosition);
            stitchedImage.getRaster().setRect(partPastePosition.x, partPastePosition.y, scaledCroppedPartImage.getData());
            ++index;
        }
        this.debugScreenshotsProvider.save(stitchedImage, "stitched");
    }

    private Region getRegionInScreenshot(Region region, BufferedImage image, double pixelRatio) {
        if (region.isSizeEmpty()) {
            return region;
        }
        this.logger.verbose("Creating screenshot object...");
        EyesScreenshot screenshot = this.screenshotFactory.makeScreenshot(image);
        this.logger.verbose("Getting region in screenshot...");
        Region regionInScreenshot = screenshot.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        RectangleSize scaledImageSize = new RectangleSize((int)Math.round((double)image.getWidth() / pixelRatio), (int)Math.round((double)image.getHeight() / pixelRatio));
        regionInScreenshot = this.sizeAdjuster.adjustRegion(regionInScreenshot, scaledImageSize);
        this.logger.verbose("Region in screenshot: " + regionInScreenshot);
        regionInScreenshot = regionInScreenshot.scale(pixelRatio);
        this.logger.verbose("Scaled region: " + regionInScreenshot);
        regionInScreenshot = this.regionPositionCompensation.compensateRegionPosition(regionInScreenshot, pixelRatio);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.verbose("Region after intersect: " + regionInScreenshot);
        return regionInScreenshot;
    }
}

