/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.Logger;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.capture.AndroidScreenshotImageProvider;
import com.applitools.eyes.selenium.capture.FirefoxScreenshotImageProvider;
import com.applitools.eyes.selenium.capture.ISizeAdjuster;
import com.applitools.eyes.selenium.capture.InternetExplorerScreenshotImageProvider;
import com.applitools.eyes.selenium.capture.MobileDeviceSizeAdjuster;
import com.applitools.eyes.selenium.capture.NullSizeAdjuster;
import com.applitools.eyes.selenium.capture.SafariScreenshotImageProvider;
import com.applitools.eyes.selenium.capture.TakesScreenshotImageProvider;
import org.openqa.selenium.TakesScreenshot;

public class ImageProviderFactory {
    public static ImageProvider getImageProvider(UserAgent ua, SeleniumEyes eyes, Logger logger, TakesScreenshot tsInstance) {
        block8: {
            if (ua != null) {
                if (ua.getBrowser().equals("Firefox")) {
                    try {
                        if (Integer.parseInt(ua.getBrowserMajorVersion()) >= 48) {
                            return new FirefoxScreenshotImageProvider(eyes, logger, tsInstance);
                        }
                        break block8;
                    }
                    catch (NumberFormatException e) {
                        return new TakesScreenshotImageProvider(logger, tsInstance);
                    }
                }
                if (ua.getBrowser().equals("Safari")) {
                    return new SafariScreenshotImageProvider(eyes, logger, tsInstance, ua);
                }
                if (ua.getBrowser().equals("IE")) {
                    return new InternetExplorerScreenshotImageProvider(eyes, logger, tsInstance, ua);
                }
                if (ua.getOS().equals("Android")) {
                    return new AndroidScreenshotImageProvider(eyes, logger, tsInstance, ua);
                }
            }
        }
        return new TakesScreenshotImageProvider(logger, tsInstance);
    }

    public static ISizeAdjuster getImageSizeAdjuster(UserAgent ua, SeleniumJavaScriptExecutor jsExecutor) {
        if (ua != null && (ua.getOS().equals("Android") || ua.getOS().equals("IOS"))) {
            return new MobileDeviceSizeAdjuster(jsExecutor);
        }
        return NullSizeAdjuster.getInstance();
    }
}

