/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.locators;

import com.applitools.eyes.Logger;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.locators.BaseVisualLocatorsProvider;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.capture.ImageProviderFactory;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.openqa.selenium.TakesScreenshot;

public class SeleniumVisualLocatorsProvider
extends BaseVisualLocatorsProvider {
    private final EyesSeleniumDriver driver;
    private final SeleniumEyes eyes;

    public SeleniumVisualLocatorsProvider(SeleniumEyes eyes, EyesSeleniumDriver driver, Logger logger, DebugScreenshotsProvider debugScreenshotsProvider) {
        super(logger, eyes.getServerConnector(), eyes.getDevicePixelRatio(), eyes.getConfiguration().getAppName(), debugScreenshotsProvider);
        this.driver = driver;
        this.eyes = eyes;
    }

    protected BufferedImage getViewPortScreenshot() {
        String uaString = this.driver.getUserAgent();
        UserAgent userAgent = null;
        if (uaString != null) {
            userAgent = UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        }
        UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        ImageProvider provider = ImageProviderFactory.getImageProvider(userAgent, this.eyes, this.logger, (TakesScreenshot)this.driver);
        BufferedImage image = provider.getImage();
        if (this.eyes.getIsCutProviderExplicitlySet()) {
            image = this.eyes.getCutProvider().cut(image);
        }
        double scaleRatio = this.devicePixelRatio;
        if (this.eyes.getIsScaleProviderExplicitlySet()) {
            scaleRatio = this.eyes.getScaleProvider().getScaleRatio();
        }
        return ImageUtils.scaleImage((BufferedImage)image, (double)(1.0 / scaleRatio));
    }
}

