/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.rendering;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.BrowserNames;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.visualgrid.model.EmulationDevice;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.EyesSyncObject;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

class EyesConnector
extends EyesBase
implements IEyesConnector,
IBatchCloser {
    private final RenderBrowserInfo browserInfo;
    private String userAgent;
    private String device;
    private RectangleSize deviceSize;
    private Configuration configuration;
    private String appName;
    private String testName;

    public EyesConnector(Configuration configuration, List<PropertyData> properties, RenderBrowserInfo browserInfo) {
        this.configuration = configuration;
        this.browserInfo = browserInfo;
        if (properties != null) {
            for (PropertyData property : properties) {
                this.addProperty(property);
            }
        }
    }

    public void open(Configuration config, String appName, String testName) {
        this.configuration = config;
        this.appName = appName;
        this.testName = testName;
        this.logger.verbose("opening EyesConnector with viewport size: " + this.browserInfo.getViewportSize());
        this.openBase();
    }

    public Future<?> getResource(URI url, String userAgent, String refererUrl, TaskListener<RGridResource> listener) {
        return this.getServerConnector().downloadResource(url, userAgent, refererUrl, listener);
    }

    public Future<?> renderPutResource(RunningRender runningRender, RGridResource resource, String userAgent, TaskListener<Boolean> listener) {
        return this.getServerConnector().renderPutResource(runningRender, resource, userAgent, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RunningRender> render(RenderRequest ... renderRequests) {
        AtomicReference reference = new AtomicReference();
        AtomicReference<EyesSyncObject> lock = new AtomicReference<EyesSyncObject>(new EyesSyncObject(this.logger, "render"));
        this.getServerConnector().render((TaskListener)new SyncTaskListener(lock, reference), renderRequests);
        EyesSyncObject eyesSyncObject = lock.get();
        synchronized (eyesSyncObject) {
            try {
                lock.get().waitForNotify();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (List)reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RenderStatusResults> renderStatusById(String ... renderIds) {
        AtomicReference reference = new AtomicReference();
        AtomicReference<EyesSyncObject> lock = new AtomicReference<EyesSyncObject>(new EyesSyncObject(this.logger, "renderStatusById"));
        this.getServerConnector().renderStatusById((TaskListener)new SyncTaskListener(lock, reference), renderIds);
        EyesSyncObject eyesSyncObject = lock.get();
        synchronized (eyesSyncObject) {
            try {
                lock.get().waitForNotify();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (List)reference.get();
    }

    public MatchResult matchWindow(String resultImageURL, String domLocation, ICheckSettings checkSettings, List<? extends IRegion> regions, List<VisualGridSelector[]> regionSelectors, Location location, String renderId, String source, RectangleSize virtualViewport) {
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        if (checkSettingsInternal.getStitchContent() == null) {
            checkSettings.fully();
        }
        MatchWindowTask matchWindowTask = new MatchWindowTask(this.logger, this.getServerConnector(), this.runningSession, this.getConfigurationInstance().getMatchTimeout(), (EyesBase)this);
        ImageMatchSettings imageMatchSettings = MatchWindowTask.createImageMatchSettings((ICheckSettingsInternal)checkSettingsInternal, (EyesBase)this);
        String tag = checkSettingsInternal.getName();
        AppOutput appOutput = new AppOutput(tag, null, domLocation, resultImageURL, virtualViewport);
        AppOutputWithScreenshot appOutputWithScreenshot = new AppOutputWithScreenshot(appOutput, null, location);
        return matchWindowTask.performMatch(appOutputWithScreenshot, tag, checkSettingsInternal, imageMatchSettings, regions, regionSelectors, (EyesBase)this, renderId, source);
    }

    protected String getBaseAgentId() {
        return "eyes.selenium.visualgrid.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    protected RectangleSize getViewportSize() {
        return RectangleSize.EMPTY;
    }

    protected Configuration setViewportSize(RectangleSize size) {
        this.logger.log("WARNING setViewportSize() was called in Visual-Grid context");
        return this.getConfigurationInstance();
    }

    protected String getInferredEnvironment() {
        return "useragent:" + this.userAgent;
    }

    protected EyesScreenshot getScreenshot(Region targetRegion, ICheckSettingsInternal checkSettingsInternal) {
        return null;
    }

    protected String getTitle() {
        return null;
    }

    protected String getAUTSessionId() {
        return null;
    }

    protected Configuration getConfigurationInstance() {
        return this.configuration;
    }

    public void setRenderInfo(RenderingInfo renderInfo) {
        this.getServerConnector().setRenderingInfo(renderInfo);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    protected void openLogger() {
    }

    protected void closeLogger() {
    }

    public String tryCaptureDom() {
        return null;
    }

    public Configuration setApiKey(String apiKey) {
        return super.setApiKey(apiKey);
    }

    public Configuration setServerUrl(URI serverUrl) {
        return super.setServerUrl(serverUrl);
    }

    public void setBranchName(String branchName) {
        this.getConfigurationInstance().setBranchName(branchName);
    }

    public void setParentBranchName(String parentBranchName) {
        this.getConfigurationInstance().setParentBranchName(parentBranchName);
    }

    public void setDevice(String device) {
        this.device = device;
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = super.getAppEnvironment();
        if (appEnv.getDeviceInfo() == null) {
            appEnv.setDeviceInfo(this.device);
        }
        if (this.userAgent == null) {
            appEnv.setOs(VisualGridTask.toPascalCase((String)this.browserInfo.getPlatform()));
            String browserName = BrowserNames.getBrowserName((BrowserType)this.browserInfo.getBrowserType());
            appEnv.setHostingApp(browserName);
        }
        this.logger.log("Done!");
        return appEnv;
    }

    public RectangleSize getDeviceSize() {
        return this.deviceSize;
    }

    public void setDeviceSize(RectangleSize deviceSize) {
        this.deviceSize = deviceSize;
    }

    public RunningSession getSession() {
        return this.runningSession;
    }

    protected RectangleSize getViewportSizeForOpen() {
        if (this.device != null) {
            return this.deviceSize;
        }
        if (this.browserInfo.getViewportSize() != null) {
            return this.browserInfo.getViewportSize();
        }
        if (this.browserInfo.getEmulationInfo() instanceof EmulationDevice) {
            EmulationDevice emulationDevice = (EmulationDevice)this.browserInfo.getEmulationInfo();
            return new RectangleSize(emulationDevice.getWidth(), emulationDevice.getHeight());
        }
        return super.getViewportSizeForOpen();
    }

    protected String getBaselineEnvName() {
        String baselineEnvName = this.browserInfo.getBaselineEnvName();
        if (baselineEnvName != null) {
            return baselineEnvName;
        }
        return this.getConfigurationInstance().getBaselineEnvName();
    }

    protected String getAppName() {
        return this.appName;
    }

    protected String getTestName() {
        return this.testName;
    }

    public void closeBatch(String batchId) {
        this.getServerConnector().closeBatch(batchId);
    }
}

