/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class BordersAwareElementContentLocationProvider {
    public static Location getLocation(Logger logger, WebElement element, Location location) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)element, (String)"element");
        ArgumentGuard.notNull((Object)location, (String)"location");
        logger.verbose(String.format("BordersAdditionFrameLocationProvider(logger, element, %s)", location));
        int leftBorderWidth = BordersAwareElementContentLocationProvider.getPropertyValue(logger, element, "border-left-width");
        int topBorderWidth = BordersAwareElementContentLocationProvider.getPropertyValue(logger, element, "border-top-width");
        Location contentLocation = location.offset(leftBorderWidth, topBorderWidth);
        logger.verbose("Done!");
        return contentLocation;
    }

    protected static int getPropertyValue(Logger logger, WebElement element, String propName) {
        int propNumericValue;
        try {
            String propValue;
            logger.verbose("Get element border left width...");
            if (element instanceof EyesRemoteWebElement) {
                logger.verbose("Element is an EyesWebElement, using 'getComputedStyle'.");
                try {
                    propValue = ((EyesRemoteWebElement)element).getComputedStyle(propName);
                }
                catch (WebDriverException e) {
                    logger.verbose("Using getComputedStyle failed: " + e.getMessage());
                    logger.verbose("Using getCssValue...");
                    propValue = element.getCssValue(propName);
                }
                logger.verbose("Done!");
            } else {
                logger.verbose(String.format("Element is not an EyesWebElement! (when trying to get %s) Element's class: %s", propName, element.getClass().getName()));
                logger.verbose("Using getCssValue...");
                propValue = element.getCssValue(propName);
                logger.verbose("Done!");
            }
            propNumericValue = Math.round(Float.valueOf(propValue.trim().replace("px", "")).floatValue());
            logger.verbose(propName + ": " + propNumericValue);
        }
        catch (WebDriverException e) {
            logger.verbose(String.format("Couldn't get the element's %s: %s. Falling back to default", propName, e.getMessage()));
            propNumericValue = 0;
        }
        return propNumericValue;
    }
}

