/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.capture.CssTreeNode;
import com.applitools.eyes.selenium.capture.Separators;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.rendering.VisualGridEyes;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.utils.EfficientStringReplace;
import com.applitools.utils.GeneralUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class DomCapture {
    private final String CAPTURE_DOM;
    private final String CAPTURE_DOM_FOR_IE;
    private final String POLL_RESULT;
    private final String POLL_RESULT_FOR_IE;
    private final Phaser cssPhaser = new Phaser();
    private static ServerConnector serverConnector = null;
    private final EyesSeleniumDriver driver;
    private final Logger logger;
    private String cssStartToken;
    private String cssEndToken;
    private final Map<String, CssTreeNode> cssNodesToReplace = Collections.synchronizedMap(new HashMap());
    private boolean shouldWaitForPhaser = false;
    private final UserAgent userAgent;

    public DomCapture(SeleniumEyes eyes) {
        serverConnector = eyes.getServerConnector();
        this.logger = eyes.getLogger();
        this.driver = (EyesSeleniumDriver)eyes.getDriver();
        this.userAgent = eyes.getUserAgent();
        try {
            this.CAPTURE_DOM = GeneralUtils.readToEnd((InputStream)DomCapture.class.getResourceAsStream("/dom-capture/dist/captureDomAndPoll.js"));
            this.CAPTURE_DOM_FOR_IE = GeneralUtils.readToEnd((InputStream)DomCapture.class.getResourceAsStream("/dom-capture/dist/captureDomAndPollForIE.js"));
            this.POLL_RESULT = GeneralUtils.readToEnd((InputStream)VisualGridEyes.class.getResourceAsStream("/dom-capture/dist/pollResult.js"));
            this.POLL_RESULT_FOR_IE = GeneralUtils.readToEnd((InputStream)VisualGridEyes.class.getResourceAsStream("/dom-capture/dist/pollResultForIE.js"));
        }
        catch (IOException e) {
            throw new EyesException("Failed getting resources for dom scripts", (Throwable)e);
        }
    }

    public String getPageDom(PositionProvider positionProvider) {
        PositionMemento originalPosition = positionProvider.getState();
        positionProvider.setPosition(Location.ZERO);
        FrameChain originalFC = this.driver.getFrameChain().clone();
        String baseUrl = (String)this.driver.executeScript("return document.location.href", new Object[0]);
        String dom = this.getFrameDom(baseUrl);
        if (originalFC != null) {
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
        }
        try {
            if (this.shouldWaitForPhaser) {
                this.cssPhaser.awaitAdvanceInterruptibly(0, 60L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        HashMap<String, String> cssStringsToReplace = new HashMap<String, String>();
        for (String url : this.cssNodesToReplace.keySet()) {
            cssStringsToReplace.put(url, this.cssNodesToReplace.get(url).toString());
        }
        String domJson = EfficientStringReplace.efficientStringReplace((String)this.cssStartToken, (String)this.cssEndToken, (String)dom, cssStringsToReplace);
        positionProvider.restoreState(originalPosition);
        return domJson;
    }

    private String getFrameDom(String baseUrl) {
        Separators separators;
        this.logger.verbose("Trying to get DOM from driver");
        String domScript = this.userAgent.isInternetExplorer() ? this.CAPTURE_DOM_FOR_IE : this.CAPTURE_DOM;
        String pollingScript = this.userAgent.isInternetExplorer() ? this.POLL_RESULT_FOR_IE : this.POLL_RESULT;
        ArrayList<String> missingCssList = new ArrayList<String>();
        ArrayList<String> missingFramesList = new ArrayList<String>();
        ArrayList<String> data = new ArrayList<String>();
        try {
            String scriptResult = EyesSeleniumUtils.runDomScript(this.logger, this.driver, this.userAgent, domScript, null, pollingScript);
            scriptResult = (String)GeneralUtils.parseJsonToObject((String)scriptResult, String.class);
            separators = this.parseScriptResult(scriptResult, missingCssList, missingFramesList, data);
        }
        catch (Exception e) {
            throw new EyesException("Failed running dom capture script", (Throwable)e);
        }
        this.cssStartToken = separators.cssStartToken;
        this.cssEndToken = separators.cssEndToken;
        this.fetchCssFiles(baseUrl, missingCssList, null);
        Map<Object, Object> framesData = new HashMap();
        try {
            framesData = this.recurseFrames(missingFramesList);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        return EfficientStringReplace.efficientStringReplace((String)separators.iframeStartToken, (String)separators.iframeEndToken, (String)((String)data.get(0)), framesData);
    }

    private Separators parseScriptResult(String scriptResult, List<String> missingCssList, List<String> missingFramesList, List<String> data) {
        String[] lines = scriptResult.split("\\r?\\n");
        Separators separators = null;
        try {
            separators = (Separators)GeneralUtils.parseJsonToObject((String)lines[0], Separators.class);
            ArrayList<List<String>> blocks = new ArrayList<List<String>>();
            blocks.add(missingCssList);
            blocks.add(missingFramesList);
            blocks.add(data);
            int blockIndex = 0;
            int lineIndex = 1;
            do {
                String str;
                if (separators.separator.equals(str = lines[lineIndex++])) {
                    ++blockIndex;
                    continue;
                }
                ((List)blocks.get(blockIndex)).add(str);
            } while (lineIndex < lines.length);
            this.logger.verbose("missing css count: " + missingCssList.size());
            this.logger.verbose("missing frames count: " + missingFramesList.size());
        }
        catch (IOException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        this.shouldWaitForPhaser |= !missingCssList.isEmpty();
        return separators;
    }

    private void fetchCssFiles(String baseUrl, List<String> cssUrls, final CssTreeNode parentNode) {
        for (final String cssUrl : cssUrls) {
            if (cssUrl == null || cssUrl.isEmpty()) continue;
            final URI uri = this.resolveUriString(baseUrl, cssUrl);
            if (uri == null) {
                this.logger.verbose(String.format("Failed resolving url of css %s", cssUrl));
                continue;
            }
            try {
                this.cssPhaser.register();
                this.logger.verbose(String.format("Downloading css url %s", uri));
                serverConnector.downloadResource(uri, this.userAgent.toString(), baseUrl, (TaskListener)new TaskListener<RGridResource>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onComplete(RGridResource resource) {
                        try {
                            DomCapture.this.logger.verbose(String.format("Css Download Completed. URL: %s", uri));
                            CssTreeNode node = new CssTreeNode(new String(resource.getContent()));
                            node.parse(DomCapture.this.logger);
                            List<String> importedUrls = node.getImportedUrls();
                            if (!importedUrls.isEmpty()) {
                                DomCapture.this.fetchCssFiles(uri.toString(), importedUrls, node);
                            }
                            if (parentNode != null) {
                                parentNode.addChildNode(cssUrl, node);
                            } else {
                                DomCapture.this.cssNodesToReplace.put(cssUrl, node);
                            }
                        }
                        catch (Throwable e) {
                            GeneralUtils.logExceptionStackTrace((Logger)DomCapture.this.logger, (Throwable)e);
                        }
                        finally {
                            DomCapture.this.cssPhaser.arriveAndDeregister();
                            DomCapture.this.logger.verbose("cssPhaser.arriveAndDeregister(); " + uri);
                            DomCapture.this.logger.verbose("current missing - " + DomCapture.this.cssPhaser.getUnarrivedParties());
                        }
                    }

                    public void onFail() {
                        DomCapture.this.logger.log("This flow can't be reached. Please verify.");
                        DomCapture.this.cssPhaser.arriveAndDeregister();
                        DomCapture.this.logger.verbose("cssPhaser.arriveAndDeregister(); " + uri);
                        DomCapture.this.logger.verbose("current missing - " + DomCapture.this.cssPhaser.getUnarrivedParties());
                    }
                });
            }
            catch (Throwable e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
    }

    private Map<String, String> recurseFrames(List<String> missingFramesList) {
        HashMap<String, String> framesData = new HashMap<String, String>();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        FrameChain fc = this.driver.getFrameChain().clone();
        for (String missingFrameLine : missingFramesList) {
            this.logger.verbose("Switching to frame line :" + missingFrameLine);
            String originLocation = (String)this.driver.executeScript("return document.location.href", new Object[0]);
            try {
                String[] missingFrameXpaths;
                for (String missingFrameXpath : missingFrameXpaths = missingFrameLine.split(",")) {
                    this.logger.verbose("switching to specific frame : " + missingFrameXpath);
                    WebElement frame = this.driver.findElement(By.xpath((String)missingFrameXpath));
                    this.logger.verbose("Switched to frame(" + missingFrameXpath + ") with src(" + frame.getAttribute("src") + ")");
                    switchTo.frame(frame);
                }
                String locationAfterSwitch = (String)this.driver.executeScript("return document.location.href", new Object[0]);
                if (locationAfterSwitch.equals(originLocation)) {
                    this.logger.verbose("Switching to frame failed");
                    framesData.put(missingFrameLine, "");
                    continue;
                }
                String result = this.getFrameDom(locationAfterSwitch);
                framesData.put(missingFrameLine, result);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                framesData.put(missingFrameLine, "");
            }
            switchTo.frames(fc);
        }
        return framesData;
    }

    private URI resolveUriString(String baseUrl, String uri) {
        if (uri.toLowerCase().startsWith("data:") || uri.toLowerCase().startsWith("javascript:")) {
            return null;
        }
        try {
            return new URI(baseUrl).resolve(uri);
        }
        catch (Exception e) {
            this.logger.log("Error resolving uri:" + uri);
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            return null;
        }
    }
}

