/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionMemento;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;

public class CssTranslatePositionProvider
implements PositionProvider,
ISeleniumPositionProvider {
    protected final Logger logger;
    protected final IEyesJsExecutor executor;
    private final WebElement scrollRootElement;
    private final String JSSetTransform = "var originalTransform = arguments[0].style.transform;arguments[0].style.transform = '%s';return originalTransform;";
    private Location lastSetPosition = Location.ZERO;

    public CssTranslatePositionProvider(Logger logger, IEyesJsExecutor executor, WebElement scrollRootElement) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        ArgumentGuard.notNull((Object)scrollRootElement, (String)"scrollRootElement");
        this.logger = logger;
        this.executor = executor;
        this.scrollRootElement = scrollRootElement;
        logger.verbose("creating CssTranslatePositionProvider");
    }

    public Location getCurrentPosition() {
        this.logger.verbose("position to return: " + this.lastSetPosition);
        return this.lastSetPosition;
    }

    public Location setPosition(Location location) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        this.logger.verbose("CssTranslatePositionProvider - Setting position to: " + location);
        Location negatedLocation = new Location(-location.getX(), -location.getY());
        Location negatedLocation2 = new Location(10, -location.getY());
        this.executor.executeScript(String.format("arguments[0].style.transform='translate(%dpx,%dpx)';", negatedLocation2.getX(), negatedLocation2.getY()), new Object[]{this.scrollRootElement});
        this.executor.executeScript(String.format("arguments[0].style.transform='translate(%dpx,%dpx)';", negatedLocation.getX(), negatedLocation.getY()), new Object[]{this.scrollRootElement});
        this.logger.verbose("Done!");
        this.lastSetPosition = location;
        return this.lastSetPosition;
    }

    public RectangleSize getEntireSize() {
        RectangleSize entireSize = EyesDriverUtils.getEntireElementSize((Logger)this.logger, (IEyesJsExecutor)this.executor, (WebElement)this.scrollRootElement);
        this.logger.verbose("CssTranslatePositionProvider - Entire size: " + entireSize);
        return entireSize;
    }

    public PositionMemento getState() {
        return new CssTranslatePositionMemento((String)this.executor.executeScript("return arguments[0].style.transform;", new Object[]{this.scrollRootElement}), this.lastSetPosition);
    }

    public void restoreState(PositionMemento state) {
        this.executor.executeScript(String.format("var originalTransform = arguments[0].style.transform;arguments[0].style.transform = '%s';return originalTransform;", ((CssTranslatePositionMemento)state).getTransform()), new Object[]{this.scrollRootElement});
        this.lastSetPosition = ((CssTranslatePositionMemento)state).getPosition();
    }

    @Override
    public WebElement getScrolledElement() {
        return this.scrollRootElement;
    }
}

