/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.exceptions.CoordinatesTypeConversionException;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.Borders;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class EyesWebDriverScreenshot
extends EyesScreenshot {
    private final EyesSeleniumDriver driver;
    private final FrameChain frameChain;
    private Location currentFrameScrollPosition;
    private final ScreenshotType screenshotType;
    private Location frameLocationInScreenshot;
    private final Region frameWindow;

    public EyesWebDriverScreenshot(Logger logger, EyesSeleniumDriver driver, BufferedImage image, ScreenshotType screenshotType, Location frameLocationInScreenshot) {
        super(logger, image);
        Object positionProvider;
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        this.driver = driver;
        this.screenshotType = this.updateScreenshotType(screenshotType, image);
        if (frameLocationInScreenshot == null && driver.getEyes().checkFrameOrElement) {
            WebElement frameScrollRoot = driver.getEyes().getCurrentFrameScrollRootElement();
            positionProvider = ScrollPositionProviderFactory.getScrollPositionProvider(driver.getUserAgent(), logger, (IEyesJsExecutor)driver, frameScrollRoot);
        } else {
            positionProvider = driver.getEyes().getCurrentFramePositionProvider() != null ? driver.getEyes().getCurrentFramePositionProvider() : driver.getEyes().getPositionProvider();
        }
        this.frameChain = driver.getFrameChain();
        try {
            this.updateCurrentScrollPosition((PositionProvider)positionProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateFrameLocationInScreenshot(frameLocationInScreenshot);
        RectangleSize frameContentSize = this.getFrameContentSize();
        if (!frameContentSize.isEmpty()) {
            this.frameWindow = new Region(this.frameLocationInScreenshot, frameContentSize);
            Region imageSizeAsRegion = new Region(0, 0, image.getWidth(), image.getHeight());
            this.frameWindow.intersect(imageSizeAsRegion);
        } else {
            this.frameWindow = new Region(0, 0, image.getWidth(), image.getHeight());
        }
        if (this.frameWindow.getWidth() <= 0 || this.frameWindow.getHeight() <= 0) {
            throw new EyesException("Got empty frame window for screenshot!");
        }
    }

    private void updateCurrentScrollPosition(PositionProvider positionProvider) {
        try {
            this.currentFrameScrollPosition = positionProvider.getCurrentPosition();
        }
        catch (Exception e) {
            this.currentFrameScrollPosition = new Location(0, 0);
        }
    }

    private RectangleSize getFrameContentSize() {
        if (EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            return new RectangleSize(0, 0);
        }
        EyesRemoteWebElement frameDocumentElement = (EyesRemoteWebElement)EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        return frameDocumentElement.getClientSize();
    }

    public EyesWebDriverScreenshot(Logger logger, EyesSeleniumDriver driver, BufferedImage image, RectangleSize entireFrameSize, Location frameLocationInScreenshot) {
        super(logger, image);
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        ArgumentGuard.notNull((Object)entireFrameSize, (String)"entireFrameSize");
        this.driver = driver;
        this.frameChain = driver.getFrameChain();
        this.screenshotType = ScreenshotType.ENTIRE_FRAME;
        this.currentFrameScrollPosition = new Location(0, 0);
        this.frameLocationInScreenshot = frameLocationInScreenshot;
        this.frameWindow = new Region(new Location(0, 0), entireFrameSize);
    }

    public static Location calcFrameLocationInScreenshot(Logger logger, EyesSeleniumDriver driver, FrameChain frameChain) {
        EyesTargetLocator switchTo = (EyesTargetLocator)driver.switchTo();
        FrameChain currentFC = frameChain.clone();
        switchTo.defaultContent();
        Location locationInScreenshot = new Location(0, 0);
        for (Frame frame : currentFC) {
            EyesRemoteWebElement eyesFrame = frame.getReference() instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)frame.getReference() : new EyesRemoteWebElement(logger, driver, frame.getReference());
            Rectangle rect = eyesFrame.getBoundingClientRect();
            SizeAndBorders sizeAndBorders = eyesFrame.getSizeAndBorders();
            Borders borders = sizeAndBorders.getBorders();
            rect.setX(rect.getX() + borders.getLeft());
            rect.setY(rect.getY() + borders.getTop());
            locationInScreenshot = locationInScreenshot.offset(rect.getX(), rect.getY());
            switchTo.frame(frame.getReference());
        }
        return locationInScreenshot;
    }

    private void updateFrameLocationInScreenshot(Location location) {
        this.frameLocationInScreenshot = location == null ? (this.frameChain.size() > 0 ? EyesWebDriverScreenshot.calcFrameLocationInScreenshot(this.logger, this.driver, this.frameChain) : new Location(0, 0)) : location;
    }

    private ScreenshotType updateScreenshotType(ScreenshotType screenshotType, BufferedImage image) {
        if (screenshotType == null) {
            RectangleSize viewportSize = this.driver.getEyes().getViewportSize();
            boolean scaleViewport = this.driver.getEyes().shouldStitchContent();
            if (scaleViewport) {
                double pixelRatio = this.driver.getEyes().getDevicePixelRatio();
                viewportSize = viewportSize.scale(pixelRatio);
            }
            screenshotType = image.getWidth() <= viewportSize.getWidth() && image.getHeight() <= viewportSize.getHeight() ? ScreenshotType.VIEWPORT : ScreenshotType.ENTIRE_FRAME;
        }
        return screenshotType;
    }

    public EyesWebDriverScreenshot(Logger logger, EyesSeleniumDriver driver, BufferedImage image) {
        this(logger, driver, image, ScreenshotType.VIEWPORT, null);
    }

    public EyesWebDriverScreenshot(Logger logger, EyesSeleniumDriver driver, BufferedImage image, Region screenshotRegion) {
        super(logger, image);
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        ArgumentGuard.notNull((Object)screenshotRegion, (String)"screenshotRegion");
        this.driver = driver;
        this.frameChain = driver.getFrameChain();
        this.screenshotType = ScreenshotType.ENTIRE_FRAME;
        this.currentFrameScrollPosition = new Location(0, 0);
        this.frameLocationInScreenshot = new Location(0, 0);
        this.frameWindow = new Region(new Location(0, 0), screenshotRegion.getSize());
    }

    public EyesWebDriverScreenshot(Logger logger, EyesSeleniumDriver driver, BufferedImage image, RectangleSize entireFrameSize) {
        super(logger, image);
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        ArgumentGuard.notNull((Object)entireFrameSize, (String)"entireFrameSize");
        this.driver = driver;
        this.frameChain = driver.getFrameChain();
        this.screenshotType = ScreenshotType.ENTIRE_FRAME;
        this.currentFrameScrollPosition = new Location(0, 0);
        this.frameLocationInScreenshot = new Location(0, 0);
        this.frameWindow = new Region(new Location(0, 0), entireFrameSize);
    }

    public Region getFrameWindow() {
        return this.frameWindow;
    }

    public FrameChain getFrameChain() {
        return new FrameChain(this.logger, this.frameChain);
    }

    public EyesWebDriverScreenshot getSubScreenshot(Region region, boolean throwIfClipped) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        Region asIsSubScreenshotRegion = this.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        if (asIsSubScreenshotRegion.isSizeEmpty() || throwIfClipped && !asIsSubScreenshotRegion.getSize().equals((Object)region.getSize())) {
            throw new OutOfBoundsException(String.format("Region [%s] is out of screenshot bounds [%s]", region, this.frameWindow));
        }
        BufferedImage subScreenshotImage = ImageUtils.getImagePart((BufferedImage)this.image, (Region)asIsSubScreenshotRegion);
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, subScreenshotImage, new Region(region.getLeft(), region.getTop(), subScreenshotImage.getWidth(), subScreenshotImage.getHeight()));
        result.updateFrameLocationInScreenshot(new Location(-region.getLeft(), -region.getTop()));
        result.setDomUrl(this.domUrl);
        return result;
    }

    public EyesWebDriverScreenshot getSubScreenshotForRegion(Region region, boolean throwIfClipped) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        Region asIsSubScreenshotRegion = this.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        if (asIsSubScreenshotRegion.isEmpty() || throwIfClipped && !asIsSubScreenshotRegion.getSize().equals((Object)region.getSize())) {
            throw new OutOfBoundsException(String.format("Region [%s] is out of screenshot bounds [%s]", region, this.frameWindow));
        }
        BufferedImage subScreenshotImage = ImageUtils.getImagePart((BufferedImage)this.image, (Region)asIsSubScreenshotRegion);
        return new EyesWebDriverScreenshot(this.logger, this.driver, subScreenshotImage, new Region(region.getLocation(), new RectangleSize(subScreenshotImage.getWidth(), subScreenshotImage.getHeight())));
    }

    public Location convertLocation(Location location, CoordinatesType from, CoordinatesType to) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)from, (String)"from");
        ArgumentGuard.notNull((Object)to, (String)"to");
        if (from == to) {
            return location;
        }
        Location result = location;
        if (this.frameChain.size() == 0 && this.screenshotType == ScreenshotType.ENTIRE_FRAME) {
            if ((from == CoordinatesType.CONTEXT_RELATIVE || from == CoordinatesType.CONTEXT_AS_IS) && to == CoordinatesType.SCREENSHOT_AS_IS) {
                result = result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
            } else if (from == CoordinatesType.SCREENSHOT_AS_IS && (to == CoordinatesType.CONTEXT_RELATIVE || to == CoordinatesType.CONTEXT_AS_IS)) {
                result = result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
            }
            return result;
        }
        block0 : switch (from) {
            case CONTEXT_AS_IS: {
                switch (to) {
                    case CONTEXT_RELATIVE: {
                        result = result.offset(this.currentFrameScrollPosition);
                        break block0;
                    }
                    case SCREENSHOT_AS_IS: {
                        result = result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            case CONTEXT_RELATIVE: {
                switch (to) {
                    case SCREENSHOT_AS_IS: {
                        result = result.offset(-this.currentFrameScrollPosition.getX(), -this.currentFrameScrollPosition.getY());
                        result = result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                    case CONTEXT_AS_IS: {
                        result = result.offset(-this.currentFrameScrollPosition.getX(), -this.currentFrameScrollPosition.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            case SCREENSHOT_AS_IS: {
                switch (to) {
                    case CONTEXT_RELATIVE: {
                        result = result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
                        result = result.offset(this.currentFrameScrollPosition);
                        break block0;
                    }
                    case CONTEXT_AS_IS: {
                        result = result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            default: {
                throw new CoordinatesTypeConversionException(from, to);
            }
        }
        return result;
    }

    public Location getLocationInScreenshot(Location location, CoordinatesType coordinatesType) throws OutOfBoundsException {
        if (!this.frameWindow.contains(location = this.convertLocation(location, coordinatesType, CoordinatesType.SCREENSHOT_AS_IS))) {
            throw new OutOfBoundsException(String.format("Location %s ('%s') is not visible in screenshot!", location, coordinatesType));
        }
        return location;
    }

    public Region getIntersectedRegion(Region region, CoordinatesType resultCoordinatesType) {
        if (region.isSizeEmpty()) {
            return new Region((IRegion)region);
        }
        CoordinatesType originalCoordinatesType = region.getCoordinatesType();
        Region intersectedRegion = this.convertRegionLocation(region, originalCoordinatesType, CoordinatesType.SCREENSHOT_AS_IS);
        switch (originalCoordinatesType) {
            case CONTEXT_RELATIVE: 
            case CONTEXT_AS_IS: {
                intersectedRegion.intersect(this.frameWindow);
                break;
            }
            case SCREENSHOT_AS_IS: {
                intersectedRegion.intersect(new Region(0, 0, this.image.getWidth(), this.image.getHeight()));
                break;
            }
            default: {
                throw new CoordinatesTypeConversionException(String.format("Unknown coordinates type: '%s'", originalCoordinatesType));
            }
        }
        if (intersectedRegion.isSizeEmpty()) {
            return intersectedRegion;
        }
        intersectedRegion = this.convertRegionLocation(intersectedRegion, CoordinatesType.SCREENSHOT_AS_IS, resultCoordinatesType);
        return intersectedRegion;
    }

    public static enum ScreenshotType {
        VIEWPORT,
        ENTIRE_FRAME;

    }
}

