/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.positioning.ElementPositionMemento;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;

public class ElementPositionProvider
implements PositionProvider,
ISeleniumPositionProvider {
    private final EyesRemoteWebElement element;

    public ElementPositionProvider(Logger logger, EyesSeleniumDriver driver, WebElement element) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.element = element instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)element : new EyesRemoteWebElement(logger, driver, element);
    }

    public Location getCurrentPosition() {
        return new Location(this.element.getScrollLeft(), this.element.getScrollTop());
    }

    public Location setPosition(Location location) {
        return this.element.scrollTo(location);
    }

    public RectangleSize getEntireSize() {
        return new RectangleSize(this.element.getScrollWidth(), this.element.getScrollHeight());
    }

    public PositionMemento getState() {
        return new ElementPositionMemento(this.getCurrentPosition());
    }

    public void restoreState(PositionMemento state) {
        ElementPositionMemento s = (ElementPositionMemento)state;
        this.setPosition(new Location(s.getX(), s.getY()));
    }

    public EyesRemoteWebElement getElement() {
        return this.element;
    }

    @Override
    public WebElement getScrolledElement() {
        return this.element;
    }
}

