'use strict';
const absolutizeUrl = require('./absolutizeUrl');

function isInlineFrame(frame) {
  return (
    !/^https?:.+/.test(frame.src) ||
    (frame.contentDocument &&
      frame.contentDocument.location &&
      (['about:blank', 'about:srcdoc'].includes(frame.contentDocument.location.href) ||
        (frame.getAttribute('src') === '' &&
          frame.contentDocument.location.href ===
            absolutizeUrl(frame.getAttribute('src'), frame.ownerDocument.location.href))))
  );
}

module.exports = isInlineFrame;
