/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ViewportMetaTag;
import com.applitools.eyes.selenium.capture.ISizeAdjuster;

public class MobileDeviceSizeAdjuster
implements ISizeAdjuster {
    private final String GetViewportMetaTagContentScript = "var meta = document.querySelector('head > meta[name=viewport]');var viewport = (meta == null) ? '' : meta.getAttribute('content');return viewport;";
    protected ViewportMetaTag viewportMetaTag;

    public MobileDeviceSizeAdjuster(IEyesJsExecutor jsExecutor) {
        String viewportMetaTagContent = (String)jsExecutor.executeScript("var meta = document.querySelector('head > meta[name=viewport]');var viewport = (meta == null) ? '' : meta.getAttribute('content');return viewport;", new Object[0]);
        this.viewportMetaTag = ViewportMetaTag.parseViewportMetaTag((String)viewportMetaTagContent);
    }

    @Override
    public Region adjustRegion(Region inputRegion, RectangleSize deviceLogicalViewportSize) {
        if (this.viewportMetaTag.getFollowDeviceWidth()) {
            return inputRegion;
        }
        float widthRatio = (float)inputRegion.getWidth() / (float)deviceLogicalViewportSize.getWidth();
        Region adjustedRegion = new Region(inputRegion.getLeft(), inputRegion.getTop(), deviceLogicalViewportSize.getWidth(), Math.round((float)inputRegion.getHeight() / widthRatio));
        return adjustedRegion;
    }
}

