/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.dom.DomScriptUtils;
import com.applitools.eyes.dom.ScriptExecutor;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.capture.CssTreeNode;
import com.applitools.eyes.selenium.capture.Separators;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.utils.EfficientStringReplace;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class DomCapture {
    private final Phaser cssPhaser = new Phaser();
    private static ServerConnector serverConnector = null;
    private final String testId;
    private final EyesSeleniumDriver driver;
    private final Logger logger;
    String cssStartToken;
    String cssEndToken;
    final Map<String, CssTreeNode> cssNodesToReplace = Collections.synchronizedMap(new HashMap());
    private boolean shouldWaitForPhaser = false;
    private final UserAgent userAgent;

    public DomCapture(SeleniumEyes eyes) {
        serverConnector = eyes.getServerConnector();
        this.logger = eyes.getLogger();
        this.driver = (EyesSeleniumDriver)eyes.getDriver();
        this.userAgent = eyes.getUserAgent();
        this.testId = eyes.getTestId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPageDom(PositionProvider positionProvider) {
        PositionMemento originalPosition = positionProvider.getState();
        positionProvider.setPosition(Location.ZERO);
        try {
            FrameChain originalFC = this.driver.getFrameChain().clone();
            EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
            switchTo.defaultContent();
            String baseUrl = (String)this.driver.executeScript("return document.location.href", new Object[0]);
            String dom = this.getFrameDom(baseUrl, Collections.singletonList(baseUrl));
            if (originalFC != null) {
                switchTo.frames(originalFC);
            }
            try {
                if (this.shouldWaitForPhaser) {
                    this.cssPhaser.awaitAdvanceInterruptibly(0, 5L, TimeUnit.MINUTES);
                }
            }
            catch (InterruptedException | TimeoutException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[]{this.testId});
            }
            this.shouldWaitForPhaser = false;
            HashMap<String, String> cssStringsToReplace = new HashMap<String, String>();
            for (String url : this.cssNodesToReplace.keySet()) {
                try {
                    String escapedCss = new ObjectMapper().writeValueAsString((Object)this.cssNodesToReplace.get(url).toString());
                    if (escapedCss.startsWith("\"") && escapedCss.endsWith("\"")) {
                        escapedCss = escapedCss.substring(1, escapedCss.length() - 1);
                    }
                    cssStringsToReplace.put(url, escapedCss);
                }
                catch (JsonProcessingException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[0]);
                }
            }
            String string = EfficientStringReplace.efficientStringReplace((String)this.cssStartToken, (String)this.cssEndToken, (String)dom, cssStringsToReplace);
            return string;
        }
        finally {
            positionProvider.restoreState(originalPosition);
        }
    }

    public String getFrameDom(String baseUrl, List<String> framesPath) {
        Separators separators;
        ScriptExecutor executor = new ScriptExecutor(){

            public Object execute(String script) {
                return DomCapture.this.driver.executeScript(script, new Object[0]);
            }
        };
        ArrayList<String> missingCssList = new ArrayList<String>();
        ArrayList<String> missingFramesList = new ArrayList<String>();
        ArrayList<String> data = new ArrayList<String>();
        try {
            String scriptResult = DomScriptUtils.runDomCapture((Logger)this.logger, (ScriptExecutor)executor, Collections.singleton(this.testId), (UserAgent)this.userAgent);
            separators = this.parseScriptResult(scriptResult, missingCssList, missingFramesList, data);
        }
        catch (Exception e) {
            throw new EyesException("Failed running dom capture script", (Throwable)e);
        }
        this.cssStartToken = separators.cssStartToken;
        this.cssEndToken = separators.cssEndToken;
        this.fetchCssFiles(baseUrl, missingCssList, null);
        Map<Object, Object> framesData = new HashMap();
        try {
            framesData = this.recurseFrames(missingFramesList, framesPath);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[]{this.testId});
        }
        return EfficientStringReplace.efficientStringReplace((String)separators.iframeStartToken, (String)separators.iframeEndToken, (String)((String)data.get(0)), framesData);
    }

    private Separators parseScriptResult(String scriptResult, List<String> missingCssList, List<String> missingFramesList, List<String> data) {
        String[] lines = scriptResult.split("\\r?\\n");
        Separators separators = null;
        try {
            separators = (Separators)GeneralUtils.parseJsonToObject((String)lines[0], Separators.class);
            ArrayList<List<String>> blocks = new ArrayList<List<String>>();
            blocks.add(missingCssList);
            blocks.add(missingFramesList);
            blocks.add(data);
            int blockIndex = 0;
            int lineIndex = 1;
            do {
                String str;
                if (separators.separator.equals(str = lines[lineIndex++])) {
                    ++blockIndex;
                    continue;
                }
                ((List)blocks.get(blockIndex)).add(str);
            } while (lineIndex < lines.length);
            this.logger.log(this.testId, Stage.CHECK, Type.DOM_SCRIPT, new Pair[]{Pair.of((Object)"missingCssCount", (Object)missingCssList.size()), Pair.of((Object)"missingFramesCount", (Object)missingFramesList.size())});
        }
        catch (IOException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[]{this.testId});
        }
        return separators;
    }

    private void fetchCssFiles(String baseUrl, List<String> cssUrls, final CssTreeNode parentNode) {
        for (final String cssUrl : cssUrls) {
            URI uri;
            if (cssUrl == null || cssUrl.isEmpty() || (uri = this.resolveUriString(baseUrl, cssUrl)) == null) continue;
            try {
                this.cssPhaser.register();
                this.shouldWaitForPhaser = true;
                serverConnector.downloadResource(uri, this.userAgent.toString(), baseUrl, Collections.emptySet(), (TaskListener)new TaskListener<RGridResource>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onComplete(RGridResource resource) {
                        try {
                            CssTreeNode node = new CssTreeNode(new String(resource.getContent()));
                            node.parse(DomCapture.this.logger);
                            List<String> importedUrls = node.getImportedUrls();
                            if (!importedUrls.isEmpty()) {
                                DomCapture.this.fetchCssFiles(uri.toString(), importedUrls, node);
                            }
                            if (parentNode != null) {
                                parentNode.addChildNode(cssUrl, node);
                            } else {
                                DomCapture.this.cssNodesToReplace.put(cssUrl, node);
                            }
                        }
                        catch (Throwable e) {
                            GeneralUtils.logExceptionStackTrace((Logger)DomCapture.this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[]{DomCapture.this.testId});
                        }
                        finally {
                            DomCapture.this.cssPhaser.arriveAndDeregister();
                        }
                    }

                    public void onFail() {
                        DomCapture.this.cssPhaser.arriveAndDeregister();
                    }
                });
            }
            catch (Throwable e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[]{this.testId});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> recurseFrames(List<String> missingFramesList, List<String> framesPath) {
        HashMap<String, String> framesData = new HashMap<String, String>();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        FrameChain fc = this.driver.getFrameChain().clone();
        for (String missingFrameLine : missingFramesList) {
            try {
                String[] missingFrameXpaths;
                for (String missingFrameXpath : missingFrameXpaths = missingFrameLine.split(",")) {
                    WebElement frame = this.driver.findElement(By.xpath((String)missingFrameXpath));
                    switchTo.frame(frame);
                }
                String locationAfterSwitch = (String)this.driver.executeScript("return document.location.href", new Object[0]);
                if (framesPath.contains(locationAfterSwitch)) {
                    framesData.put(missingFrameLine, "");
                    continue;
                }
                ArrayList<String> newFramePath = new ArrayList<String>(framesPath);
                newFramePath.add(locationAfterSwitch);
                String result = this.getFrameDom(locationAfterSwitch, newFramePath);
                framesData.put(missingFrameLine, result);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[]{this.testId});
                framesData.put(missingFrameLine, "");
            }
            finally {
                switchTo.frames(fc);
            }
        }
        return framesData;
    }

    private URI resolveUriString(String baseUrl, String uri) {
        if (uri.toLowerCase().startsWith("data:") || uri.toLowerCase().startsWith("javascript:")) {
            return null;
        }
        try {
            return new URI(baseUrl).resolve(uri);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[]{this.testId});
            return null;
        }
    }
}

