/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.capture.ScreenshotProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.capture.ImageProviderFactory;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.TakesScreenshot;

public class SeleniumScreenshotProvider
implements ScreenshotProvider {
    private final SeleniumEyes eyes;
    private final EyesSeleniumDriver driver;
    private final Logger logger;
    private final DebugScreenshotsProvider debugScreenshotsProvider;

    public SeleniumScreenshotProvider(SeleniumEyes eyes, EyesSeleniumDriver driver, Logger logger, DebugScreenshotsProvider debugScreenshotsProvider) {
        this.eyes = eyes;
        this.driver = driver;
        this.logger = logger;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
    }

    public BufferedImage getViewPortScreenshot(Stage stage) {
        String uaString = this.driver.getUserAgent();
        UserAgent userAgent = null;
        if (uaString != null) {
            userAgent = UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        }
        UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        ImageProvider provider = ImageProviderFactory.getImageProvider(userAgent, this.eyes, this.logger, (TakesScreenshot)this.driver);
        BufferedImage image = provider.getImage();
        this.logger.log(this.eyes.getTestId(), stage, new Pair[]{Pair.of((Object)"imageSize", (Object)new RectangleSize(image.getWidth(), image.getHeight()))});
        this.debugScreenshotsProvider.save(image, "initial");
        if (this.eyes.getIsCutProviderExplicitlySet()) {
            image = this.eyes.getCutProvider().cut(image);
            this.logger.log(this.eyes.getTestId(), stage, new Pair[]{Pair.of((Object)"croppedImageSize", (Object)new RectangleSize(image.getWidth(), image.getHeight()))});
            this.debugScreenshotsProvider.save(image, "cut");
        }
        double scaleRatio = 1.0 / this.eyes.getDevicePixelRatio();
        if (this.eyes.getIsScaleProviderExplicitlySet()) {
            scaleRatio = this.eyes.getScaleProvider().getScaleRatio();
        }
        this.logger.log(this.eyes.getTestId(), stage, new Pair[]{Pair.of((Object)"scaleRatio", (Object)scaleRatio)});
        return ImageUtils.scaleImage((BufferedImage)image, (double)scaleRatio);
    }
}

