/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.ICheckSettings;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.BaseVisualLocatorsProvider;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.locators.TextRegionSettings;
import com.applitools.eyes.locators.VisualLocatorSettings;
import com.applitools.eyes.locators.VisualLocatorsProvider;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.Configuration;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.ISeleniumEyes;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.rendering.VisualGridEyes;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.services.VisualGridRunner;
import com.applitools.utils.ArgumentGuard;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Eyes
implements IEyesBase {
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private boolean isVisualGridEyes = false;
    private VisualGridEyes visualGridEyes = null;
    private SeleniumEyes seleniumEyes;
    private ISeleniumEyes activeEyes;
    private com.applitools.eyes.config.Configuration configuration = new com.applitools.eyes.config.Configuration();
    private ImageRotation rotation;
    VisualLocatorsProvider visualLocatorsProvider;
    ConfigurationProvider configurationProvider = new ConfigurationProvider(){

        public com.applitools.eyes.config.Configuration get() {
            return Eyes.this.configuration;
        }
    };

    public Eyes() {
        this.seleniumEyes = new SeleniumEyes(this.configurationProvider, (EyesRunner)new ClassicRunner());
        this.activeEyes = this.seleniumEyes;
    }

    public Eyes(EyesRunner runner) {
        this();
        Object object = runner = runner == null ? new ClassicRunner() : runner;
        if (runner instanceof VisualGridRunner) {
            this.visualGridEyes = new VisualGridEyes((VisualGridRunner)runner, this.configurationProvider);
            this.activeEyes = this.visualGridEyes;
            this.isVisualGridEyes = true;
        } else {
            this.seleniumEyes = new SeleniumEyes(this.configurationProvider, runner);
            this.activeEyes = this.seleniumEyes;
        }
    }

    private void afterOpen() {
        this.visualLocatorsProvider = new BaseVisualLocatorsProvider(this.getLogger(), this.seleniumEyes.getTestId(), this.seleniumEyes.getServerConnector(), this.seleniumEyes.getScreenshotProvider(), this.seleniumEyes.getDevicePixelRatio(), this.seleniumEyes.getConfiguration().getAppName(), this.getDebugScreenshotsProvider());
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setImageProvider(this.seleniumEyes.getImageProvider());
        }
    }

    public WebDriver open(WebDriver webDriver) {
        if (this.activeEyes != this.seleniumEyes) {
            this.configuration.setIsVisualGrid(true);
            this.seleniumEyes.open(webDriver);
        }
        webDriver = this.activeEyes.open(webDriver);
        this.afterOpen();
        return webDriver;
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        if (this.activeEyes != this.seleniumEyes) {
            this.configuration.setIsVisualGrid(true);
            this.seleniumEyes.open(driver);
        }
        driver = this.activeEyes.open(driver, appName, testName, null);
        this.afterOpen();
        return driver;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        if (this.activeEyes != this.seleniumEyes) {
            this.configuration.setIsVisualGrid(true);
            this.seleniumEyes.open(driver);
        }
        driver = this.activeEyes.open(driver, appName, testName, viewportSize);
        this.afterOpen();
        return driver;
    }

    public void setServerUrl(String serverUrl) {
        this.configuration.setServerUrl(serverUrl);
        this.activeEyes.serverUrl(serverUrl);
    }

    public void setServerUrl(URI serverUri) {
        this.activeEyes.serverUrl(serverUri.toString());
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        this.configuration.setProxy(proxySettings);
        this.activeEyes.proxy(proxySettings);
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.activeEyes.setIsDisabled(isDisabled);
    }

    public void check(ICheckSettings checkSettings) {
        this.check((String)null, checkSettings);
    }

    public TestResults close() {
        return this.close(true);
    }

    public TestResults abortIfNotClosed() {
        return this.abort();
    }

    public TestResults abort() {
        return this.activeEyes.abort();
    }

    public void abortAsync() {
        this.activeEyes.abortAsync();
    }

    public boolean getIsDisabled() {
        return this.activeEyes.getIsDisabled();
    }

    public String getApiKey() {
        return this.activeEyes.getApiKey();
    }

    public void setApiKey(String apiKey) {
        if (this.seleniumEyes != this.activeEyes) {
            this.seleniumEyes.apiKey(apiKey);
        }
        this.activeEyes.apiKey(apiKey);
    }

    public void setBranchName(String branchName) {
        this.configuration.setBranchName(branchName);
    }

    public void setParentBranchName(String branchName) {
        this.configuration.setParentBranchName(branchName);
    }

    public void setHideCaret(boolean hideCaret) {
        this.configuration.setHideCaret(hideCaret);
    }

    public void setMatchTimeout(int ms) {
        this.configuration.setMatchTimeout(ms);
    }

    public int getMatchTimeout() {
        return this.configuration.getMatchTimeout();
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.configuration.setSaveNewTests(saveNewTests);
    }

    public boolean getSaveNewTests() {
        return this.configuration.getSaveNewTests();
    }

    public void setSaveFailedTests(boolean saveFailedTests) {
        this.configuration.setSaveFailedTests(saveFailedTests);
    }

    public boolean getSaveFailedTests() {
        return this.configuration.getSaveNewTests();
    }

    public void setBatch(BatchInfo batch) {
        this.configuration.setBatch(batch);
    }

    public BatchInfo getBatch() {
        return this.configuration.getBatch();
    }

    public void setFailureReports(FailureReports failureReports) {
        this.configuration.setFailureReports(failureReports);
    }

    public FailureReports getFailureReports() {
        return this.configuration.getFailureReports();
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.configuration.setDefaultMatchSettings(defaultMatchSettings);
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.configuration.getDefaultMatchSettings();
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.configuration.getDefaultMatchSettings().setMatchLevel(matchLevel);
    }

    public MatchLevel getMatchLevel() {
        return this.configuration.getDefaultMatchSettings().getMatchLevel();
    }

    public String getFullAgentId() {
        return this.activeEyes.getFullAgentId();
    }

    public boolean getIsOpen() {
        return this.activeEyes.getIsOpen();
    }

    public static URI getDefaultServerUrl() {
        return SeleniumEyes.getDefaultServerUrl();
    }

    public void setLogHandler(LogHandler logHandler) {
        this.activeEyes.setLogHandler(logHandler);
    }

    public LogHandler getLogHandler() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getLogHandler();
        }
        if (this.visualGridEyes.getLogger() != null) {
            return this.visualGridEyes.getLogger().getLogHandler();
        }
        return null;
    }

    public Logger getLogger() {
        return this.activeEyes.getLogger();
    }

    public void setImageCut(CutProvider cutProvider) {
        this.seleniumEyes.setImageCut(cutProvider);
    }

    public boolean getIsCutProviderExplicitlySet() {
        return this.seleniumEyes.getIsCutProviderExplicitlySet();
    }

    public void check(String tag, ICheckSettings checkSettings) {
        this.activeEyes.check(tag, checkSettings);
    }

    public TestResults close(boolean shouldThrowException) {
        return this.activeEyes.close(shouldThrowException);
    }

    public void setScaleRatio(Double scaleRatio) {
        this.seleniumEyes.setScaleRatio(scaleRatio);
    }

    public double getScaleRatio() {
        return this.seleniumEyes.getScaleRatio();
    }

    public void addProperty(String name, String value) {
        this.activeEyes.addProperty(name, value);
    }

    public void clearProperties() {
        this.activeEyes.clearProperties();
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        this.seleniumEyes.setSaveDebugScreenshots(saveDebugScreenshots);
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setSaveDebugScreenshots(saveDebugScreenshots);
        }
    }

    public boolean getSaveDebugScreenshots() {
        return this.seleniumEyes.getSaveDebugScreenshots();
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.seleniumEyes.setDebugScreenshotsPath(pathToSave);
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setDebugScreenshotsPath(pathToSave);
        }
    }

    public String getDebugScreenshotsPath() {
        return this.seleniumEyes.getDebugScreenshotsPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.seleniumEyes.setDebugScreenshotsPrefix(prefix);
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setDebugScreenshotsPrefix(prefix);
        }
    }

    public String getDebugScreenshotsPrefix() {
        return this.seleniumEyes.getDebugScreenshotsPrefix();
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        return this.seleniumEyes.getDebugScreenshotsProvider();
    }

    public boolean getIgnoreCaret() {
        return this.configuration.getIgnoreCaret();
    }

    public void setIgnoreCaret(boolean value) {
        this.configuration.setIgnoreCaret(value);
    }

    public int getStitchOverlap() {
        return this.configuration.getStitchOverlap();
    }

    public void setStitchOverlap(int pixels) {
        this.configuration.setStitchOverlap(pixels);
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(Region region, int matchTimeout, String tag) throws TestFailedException {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.check((ICheckSettings)Target.region(region).timeout(matchTimeout).withName(tag));
    }

    public void checkRegion(WebElement element) {
        this.checkRegion(element, -1, null, true);
    }

    public void checkRegion(WebElement element, boolean stitchContent) {
        this.checkRegion(element, -1, null, stitchContent);
    }

    public void checkRegion(WebElement element, String tag) {
        this.checkRegion(element, -1, tag);
    }

    public void checkRegion(WebElement element, String tag, boolean stitchContent) {
        this.checkRegion(element, -1, tag, stitchContent);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag) {
        this.checkRegion(element, matchTimeout, tag, true);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.check((ICheckSettings)Target.region(element).timeout(matchTimeout).withName(tag).fully(stitchContent));
    }

    public void checkRegion(By selector) {
        this.checkRegion(selector, -1, null, false);
    }

    public void checkRegion(By selector, boolean stitchContent) {
        this.checkRegion(selector, -1, null, stitchContent);
    }

    public void checkRegion(By selector, String tag) {
        this.checkRegion(selector, -1, tag, true);
    }

    public void checkRegion(By selector, String tag, boolean stitchContent) {
        this.checkRegion(selector, -1, tag, stitchContent);
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        this.checkRegion(selector, matchTimeout, tag, true);
    }

    public void checkRegion(By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector) {
        this.checkRegionInFrame(frameIndex, selector, null);
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, null, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameIndex, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector) {
        this.checkRegionInFrame(frameNameOrId, selector, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, null, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(WebElement frameReference, By selector) {
        this.checkRegionInFrame(frameReference, selector, -1, null);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, null, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, true);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameReference, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkElement(WebElement element) {
        this.checkElement(element, null);
    }

    public void checkElement(WebElement element, String tag) {
        this.checkElement(element, -1, tag);
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.checkElement(selector, -1, null);
    }

    public void checkElement(By selector, String tag) {
        this.checkElement(selector, -1, tag);
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully());
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        this.seleniumEyes.addMouseTrigger(action, control, cursor);
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
        this.seleniumEyes.addMouseTrigger(action, element);
    }

    public void addTextTrigger(Region control, String text) {
        this.seleniumEyes.addTextTrigger(control, text);
    }

    public void addTextTrigger(WebElement element, String text) {
        this.seleniumEyes.addTextTrigger(element, text);
    }

    public RectangleSize getViewportSize() {
        return this.seleniumEyes.getViewportSize();
    }

    public static RectangleSize getViewportSize(WebDriver driver) {
        return SeleniumEyes.getViewportSize(driver);
    }

    public static void setViewportSize(WebDriver driver, RectangleSize size) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        EyesDriverUtils.setViewportSize((Logger)new Logger(), (WebDriver)driver, (RectangleSize)size);
    }

    public boolean getHideCaret() {
        return this.configuration.getHideCaret();
    }

    public boolean shouldStitchContent() {
        return this.seleniumEyes.shouldStitchContent();
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.configuration.setForceFullPageScreenshot(shouldForce);
    }

    public boolean getForceFullPageScreenshot() {
        Boolean forceFullPageScreenshot = this.configuration.getForceFullPageScreenshot();
        if (forceFullPageScreenshot == null) {
            return this.isVisualGridEyes;
        }
        return forceFullPageScreenshot;
    }

    public void setWaitBeforeScreenshots(int waitBeforeScreenshots) {
        this.configuration.setWaitBeforeScreenshots(waitBeforeScreenshots);
    }

    public int getWaitBeforeScreenshots() {
        return this.configuration.getWaitBeforeScreenshots();
    }

    public void setScrollToRegion(boolean shouldScroll) {
        this.seleniumEyes.setScrollToRegion(shouldScroll);
    }

    public boolean getScrollToRegion() {
        return this.seleniumEyes.getScrollToRegion();
    }

    public void setStitchMode(StitchMode mode) {
        this.configuration.setStitchMode(mode);
    }

    public StitchMode getStitchMode() {
        return this.configuration.getStitchMode();
    }

    public void setHideScrollbars(boolean shouldHide) {
        this.configuration.setHideScrollbars(shouldHide);
    }

    public boolean getHideScrollbars() {
        return this.configuration.getHideScrollbars();
    }

    public ImageRotation getRotation() {
        return this.seleniumEyes.getRotation();
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        WebDriver driver = this.getDriver();
        if (driver != null) {
            ((EyesSeleniumDriver)driver).setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        return this.seleniumEyes.getDevicePixelRatio();
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.window().timeout(matchTimeout));
    }

    public void checkWindow(String tag, boolean fully) {
        this.check(tag, (ICheckSettings)Target.window().fully(fully));
    }

    public void check(ICheckSettings ... checkSettings) {
        this.activeEyes.check(checkSettings);
    }

    public void checkFrame(String frameNameOrId) {
        this.checkFrame(frameNameOrId, null);
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.checkFrame(frameNameOrId, -1, tag);
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).fully().timeout(matchTimeout));
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).timeout(matchTimeout));
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.timeout(matchTimeout));
    }

    public void checkFrame(String[] framesPath, String tag) {
        this.checkFrame(framesPath, -1, tag);
    }

    public void checkFrame(String[] framesPath) {
        this.checkFrame(framesPath, null);
    }

    public URI getServerUrl() {
        return this.activeEyes.getServerUrl();
    }

    public void setAgentId(String agentId) {
        this.configuration.setAgentId(agentId);
    }

    public String getAgentId() {
        return this.configuration.getAgentId();
    }

    public void setServerConnector(ServerConnector serverConnector) {
        this.seleniumEyes.setServerConnector(serverConnector);
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setServerConnector(serverConnector);
        }
    }

    public AbstractProxySettings getProxy() {
        return this.configuration.getProxy();
    }

    public void setAppName(String appName) {
        this.configuration.setAppName(appName);
    }

    public String getAppName() {
        return this.configuration.getAppName();
    }

    public String getHostOS() {
        return this.configuration.getHostOS();
    }

    public String getHostApp() {
        return this.configuration.getHostApp();
    }

    public void setBaselineName(String baselineName) {
        this.setBaselineEnvName(baselineName);
    }

    public String getBaselineName() {
        return this.getBaselineEnvName();
    }

    public void setBaselineEnvName(String baselineEnvName) {
        this.configuration.setBaselineEnvName(baselineEnvName);
    }

    public String getBaselineEnvName() {
        return this.configuration.getBaselineEnvName();
    }

    public void setEnvName(String envName) {
        this.configuration.setEnvironmentName(envName);
    }

    public String getEnvName() {
        return this.configuration.getEnvironmentName();
    }

    public PositionProvider getPositionProvider() {
        return this.seleniumEyes.getPositionProvider();
    }

    public void setPositionProvider(PositionProvider positionProvider) {
        this.seleniumEyes.setPositionProvider(positionProvider);
    }

    public void setExplicitViewportSize(RectangleSize explicitViewportSize) {
        this.seleniumEyes.setExplicitViewportSize(explicitViewportSize);
    }

    public void log(String message) {
        this.activeEyes.getLogger().log(TraceLevel.Notice, Stage.GENERAL, message);
    }

    public boolean isSendDom() {
        return this.configuration.isSendDom();
    }

    public void setSendDom(boolean isSendDom) {
        this.configuration.setSendDom(isSendDom);
    }

    public void setHostOS(String hostOS) {
        this.configuration.setHostOS(hostOS);
    }

    public void setHostApp(String hostApp) {
        this.configuration.setHostApp(hostApp);
    }

    public RenderingInfo getRenderingInfo() {
        return null;
    }

    public String getBranchName() {
        return this.configuration.getBranchName();
    }

    public String getParentBranchName() {
        return this.configuration.getParentBranchName();
    }

    public void setBaselineBranchName(String branchName) {
        this.configuration.setBaselineBranchName(branchName);
    }

    public String getBaselineBranchName() {
        return this.configuration.getBaselineBranchName();
    }

    public void setSaveDiffs(Boolean saveDiffs) {
        this.configuration.setSaveDiffs(saveDiffs);
    }

    public Boolean getSaveDiffs() {
        return this.configuration.getSaveDiffs();
    }

    public void setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.configuration.setIgnoreDisplacements(isIgnoreDisplacements);
    }

    public boolean getIgnoreDisplacements() {
        return this.configuration.getIgnoreDisplacements();
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.configuration.setDebugResourceWriter(debugResourceWriter);
    }

    @Deprecated
    public void setAppEnvironment(String hostOS, String hostApp) {
        this.setHostOS(hostOS);
        this.setHostApp(hostApp);
    }

    public WebDriver getDriver() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getDriver();
        }
        return this.visualGridEyes.getDriver();
    }

    public FrameChain getOriginalFC() {
        return this.seleniumEyes.getOriginalFC();
    }

    public PositionProvider getCurrentFramePositionProvider() {
        return this.seleniumEyes.getCurrentFramePositionProvider();
    }

    public Region getRegionToCheck() {
        return this.seleniumEyes.getRegionToCheck();
    }

    public void setRegionToCheck(Region regionToCheck) {
        this.seleniumEyes.setRegionToCheck(regionToCheck);
    }

    public WebElement getCurrentFrameScrollRootElement() {
        return this.seleniumEyes.getCurrentFrameScrollRootElement();
    }

    public ServerConnector getServerConnector() {
        return this.seleniumEyes.getServerConnector();
    }

    public Configuration getConfiguration() {
        return new Configuration(this.configuration);
    }

    public void setConfiguration(com.applitools.eyes.config.Configuration configuration) {
        AbstractProxySettings proxy;
        URI serverUrl;
        ArgumentGuard.notNull((Object)configuration, (String)"configuration");
        String apiKey = configuration.getApiKey();
        if (apiKey != null) {
            this.setApiKey(apiKey);
        }
        if ((serverUrl = configuration.getServerUrl()) != null) {
            this.setServerUrl(serverUrl.toString());
        }
        if ((proxy = configuration.getProxy()) != null) {
            this.setProxy(proxy);
        }
        this.configuration = new com.applitools.eyes.config.Configuration(configuration);
    }

    public void closeAsync() {
        this.activeEyes.closeAsync();
    }

    public Map<String, List<Region>> locate(VisualLocatorSettings visualLocatorSettings) {
        ArgumentGuard.notNull((Object)visualLocatorSettings, (String)"visualLocatorSettings");
        return this.visualLocatorsProvider.getLocators(visualLocatorSettings);
    }

    public Map<String, List<TextRegion>> extractTextRegions(TextRegionSettings textRegionSettings) {
        return this.seleniumEyes.extractTextRegions(textRegionSettings);
    }

    public List<String> extractText(BaseOcrRegion ... ocrRegions) {
        return this.seleniumEyes.extractText(ocrRegions);
    }
}

