/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.capture.MobileScreenshotImageProvider;
import com.applitools.utils.ImageUtils;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.openqa.selenium.TakesScreenshot;

public class AndroidScreenshotImageProvider
extends MobileScreenshotImageProvider {
    public AndroidScreenshotImageProvider(SeleniumEyes eyes, Logger logger, TakesScreenshot tsInstance, UserAgent userAgent) {
        super(eyes, logger, tsInstance, userAgent);
    }

    @Override
    public BufferedImage getImage() {
        BufferedImage image = super.getImage();
        this.logger.verbose("Bitmap Size: " + image.getWidth() + "," + image.getHeight());
        this.eyes.getDebugScreenshotsProvider().save(image, "ANDROID");
        if (this.eyes.getIsCutProviderExplicitlySet()) {
            return image;
        }
        RectangleSize originalViewportSize = this.getViewportSize();
        this.logger.verbose("logical viewport size: " + originalViewportSize);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        this.logger.verbose("physical device pixel size: " + imageWidth + "," + imageHeight);
        float widthRatio = (float)image.getWidth() / (float)originalViewportSize.getWidth();
        float height = widthRatio * (float)originalViewportSize.getHeight();
        Rectangle cropRect = new Rectangle(0, 0, imageWidth, Math.round(height));
        image = ImageUtils.cropImage((Logger)this.logger, (BufferedImage)image, (Rectangle)cropRect);
        return image;
    }
}

