/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.frames;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.Borders;
import com.applitools.eyes.selenium.positioning.ScrollPositionMemento;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class Frame {
    private final WebElement reference;
    private final Location location;
    private final RectangleSize outerSize;
    private final RectangleSize innerSize;
    private final Location originalLocation;
    private final IEyesJsExecutor jsExecutor;
    private final Logger logger;
    private PositionMemento positionMemento;
    private WebElement scrollRootElement;
    private String originalOverflow;
    private Region bounds;
    private Borders borderWidths;

    public Frame(Logger logger, WebElement reference, Location location, RectangleSize outerSize, RectangleSize innerSize, Location originalLocation, Region bounds, Borders borderWidths, IEyesJsExecutor jsExecutor) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)reference, (String)"reference");
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)outerSize, (String)"outerSize");
        ArgumentGuard.notNull((Object)innerSize, (String)"innerSize");
        ArgumentGuard.notNull((Object)originalLocation, (String)"originalLocation");
        ArgumentGuard.notNull((Object)jsExecutor, (String)"jsExecutor");
        logger.verbose(String.format("Frame(logger, reference, %s, %s, %s, %s)", location, outerSize, innerSize, originalLocation));
        this.logger = logger;
        this.reference = reference;
        this.location = location;
        this.outerSize = outerSize;
        this.innerSize = innerSize;
        this.originalLocation = originalLocation;
        this.positionMemento = new ScrollPositionMemento(originalLocation);
        this.jsExecutor = jsExecutor;
        this.bounds = bounds;
        this.borderWidths = borderWidths;
    }

    public WebElement getReference() {
        return this.reference;
    }

    public Location getLocation() {
        return this.location;
    }

    public RectangleSize getOuterSize() {
        return this.outerSize;
    }

    public RectangleSize getInnerSize() {
        return this.innerSize;
    }

    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    public WebElement getScrollRootElement() {
        return this.scrollRootElement;
    }

    public void setScrollRootElement(WebElement scrollRootElement) {
        this.scrollRootElement = scrollRootElement;
    }

    public void hideScrollbars(WebDriver driver) {
        WebElement scrollRootElement = this.getScrollRootElement(driver);
        this.logger.verbose("hiding scrollbars of element: " + scrollRootElement);
        this.originalOverflow = (String)this.jsExecutor.executeScript("var origOF = arguments[0].style.overflow; arguments[0].style.overflow='hidden'; return origOF;", new Object[]{scrollRootElement});
    }

    public void returnToOriginalOverflow(WebDriver driver) {
        WebElement scrollRootElement = this.getScrollRootElement(driver);
        this.logger.verbose("returning overflow of element to its original value: " + scrollRootElement);
        this.jsExecutor.executeScript("arguments[0].style.overflow='" + this.originalOverflow + "';", new Object[]{scrollRootElement});
    }

    public void returnToOriginalPosition(EyesWebDriver driver) {
        WebElement scrollRootElement = this.getScrollRootElement(driver);
        ScrollPositionProvider positionProvider = ScrollPositionProviderFactory.getScrollPositionProvider(driver.getUserAgent(), this.logger, this.jsExecutor, scrollRootElement);
        positionProvider.restoreState(this.positionMemento);
    }

    private WebElement getScrollRootElement(WebDriver driver) {
        WebElement scrollRootElement = this.getScrollRootElement();
        if (scrollRootElement == null) {
            this.logger.verbose("no scroll root element. selecting default.");
            scrollRootElement = driver.findElement(By.tagName((String)"html"));
        }
        return scrollRootElement;
    }

    public Region getBounds() {
        return this.bounds;
    }

    public Borders getBorderWidths() {
        return this.borderWidths;
    }
}

