/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.rendering;

import com.applitools.ICheckSettings;
import com.applitools.ICheckSettingsInternal;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.IGetAccessibilityRegion;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MultiLogHandler;
import com.applitools.eyes.NullLogHandler;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.ISeleniumEyes;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.ISeleniumFrameCheckTarget;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.rendering.EyesConnector;
import com.applitools.eyes.selenium.rendering.IGetSeleniumRegion;
import com.applitools.eyes.selenium.rendering.WebElementRegion;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.ScriptResponse;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.IRenderingEyes;
import com.applitools.eyes.visualgrid.services.RunningTest;
import com.applitools.eyes.visualgrid.services.ScoreTask;
import com.applitools.eyes.visualgrid.services.VisualGridRunner;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class VisualGridEyes
implements ISeleniumEyes,
IRenderingEyes {
    private static long DOM_EXTRACTION_TIMEOUT = 300000L;
    private Logger logger;
    private String apiKey;
    private String serverUrl;
    private final VisualGridRunner renderingGridRunner;
    private final List<RunningTest> testList = Collections.synchronizedList(new ArrayList());
    private final List<RunningTest> testsInCloseProcess = Collections.synchronizedList(new ArrayList());
    private AtomicBoolean isVGEyesIssuedOpenTasks = new AtomicBoolean(false);
    private IRenderingEyes.EyesListener listener;
    List<TestResultContainer> allTestResults = new ArrayList<TestResultContainer>();
    private String PROCESS_RESOURCES;
    private EyesWebDriver webDriver;
    private RenderingInfo renderingInfo;
    private IEyesConnector VGEyesConnector;
    private IDebugResourceWriter debugResourceWriter;
    private String url;
    private Set<Future<TestResultContainer>> closeFuturesSet = new HashSet<Future<TestResultContainer>>();
    private Boolean isDisabled = Boolean.FALSE;
    private ServerConnector serverConnector = null;
    private final ConfigurationProvider configurationProvider;
    private UserAgent userAgent = null;
    private RectangleSize viewportSize;
    private AtomicBoolean isCheckTimerTimedOut = new AtomicBoolean(false);
    private Timer timer = null;
    private final List<PropertyData> properties = new ArrayList<PropertyData>();
    private static final String GET_ELEMENT_XPATH_JS = "var el = arguments[0];var xpath = '';do { var parent = el.parentElement; var index = 1; if (parent !== null) {  var children = parent.children;  for (var childIdx in children) {    var child = children[childIdx];    if (child === el) break;    if (child.tagName === el.tagName) index++;  }}xpath = '/' + el.tagName + '[' + index + ']' + xpath; el = parent;} while (el !== null);return '/' + xpath;";
    private RunningTest.RunningTestListener testListener;

    public VisualGridEyes(VisualGridRunner renderingGridManager, ConfigurationProvider configurationProvider) {
        try {
            this.PROCESS_RESOURCES = GeneralUtils.readToEnd((InputStream)VisualGridEyes.class.getResourceAsStream("/processPageAndSerializePoll.js"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.testListener = new RunningTest.RunningTestListener(){

            public void onTaskComplete(VisualGridTask task, RunningTest test) {
                switch (task.getType()) {
                    case CLOSE: 
                    case ABORT: {
                        VisualGridEyes.this.isVGEyesIssuedOpenTasks.set(false);
                    }
                }
                if (VisualGridEyes.this.listener != null) {
                    VisualGridEyes.this.listener.onTaskComplete(task, (IRenderingEyes)VisualGridEyes.this);
                }
            }

            public void onRenderComplete() {
                VisualGridEyes.this.listener.onRenderComplete();
            }
        };
        this.configurationProvider = configurationProvider;
        ArgumentGuard.notNull((Object)renderingGridManager, (String)"renderingGridRunner");
        this.renderingGridRunner = renderingGridManager;
        this.logger = renderingGridManager.getLogger();
    }

    public void setLogHandler(LogHandler logHandler) {
        if (this.getIsDisabled()) {
            return;
        }
        LogHandler currentLogHandler = this.logger.getLogHandler();
        this.logger = new Logger();
        this.logger.setLogHandler((LogHandler)new MultiLogHandler(new LogHandler[]{currentLogHandler, logHandler}));
        if (currentLogHandler.isOpen() && !logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public LogHandler getLogHandler() {
        if (this.getIsDisabled()) {
            return NullLogHandler.instance;
        }
        return this.logger.getLogHandler();
    }

    @Override
    public void apiKey(String apiKey) {
        this.setApiKey(apiKey);
    }

    @Override
    public void serverUrl(String serverUrl) {
        this.setServerUrl(serverUrl);
    }

    public void serverUrl(URI serverUrl) {
        this.setServerUrl(serverUrl.toString());
    }

    @Override
    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) throws EyesException {
        this.getConfiguration().setAppName(appName).setTestName(testName);
        if (viewportSize != null && !viewportSize.isEmpty()) {
            this.getConfiguration().setViewportSize(new RectangleSize(viewportSize));
        }
        return this.open(driver);
    }

    @Override
    public WebDriver open(WebDriver webDriver) {
        this.logger.verbose("enter");
        if (!this.validateEyes()) {
            return webDriver;
        }
        ArgumentGuard.notNull((Object)webDriver, (String)"webDriver");
        ArgumentGuard.notNull((Object)this.getConfiguration().getTestName(), (String)"testName");
        ArgumentGuard.notNull((Object)this.getConfiguration().getAppName(), (String)"appName");
        this.initDriver(webDriver);
        String uaString = this.webDriver.getUserAgent();
        if (uaString != null) {
            this.logger.verbose(String.format("User-Agent: %s", uaString));
            this.userAgent = UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        }
        this.setViewportSize(this.webDriver);
        this.ensureBrowsers();
        if (this.getConfiguration().getBatch() == null) {
            this.getConfiguration().setBatch(new BatchInfo(null));
        }
        this.logger.verbose("getting all browsers info...");
        List browserInfoList = this.getConfiguration().getBrowsersInfo();
        this.logger.verbose("creating test descriptors for each browser info...");
        this.getConfiguration().setViewportSize(this.viewportSize);
        if (this.getConfiguration().getBrowsersInfo() == null) {
            RectangleSize viewportSize = this.getConfiguration().getViewportSize();
            this.getConfiguration().addBrowser(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, this.getConfiguration().getBaselineEnvName()));
        }
        for (RenderBrowserInfo browserInfo : browserInfoList) {
            this.logger.verbose("creating test descriptor");
            RunningTest test = new RunningTest(this.createVGEyesConnector(browserInfo), this.configurationProvider, browserInfo, this.logger, this.testListener);
            this.testList.add(test);
        }
        this.logger.verbose(String.format("opening %d tests...", this.testList.size()));
        this.renderingGridRunner.open((IRenderingEyes)this, this.renderingInfo);
        this.logger.verbose("done");
        return this.webDriver != null ? this.webDriver : webDriver;
    }

    private void ensureBrowsers() {
        if (this.getConfiguration().getBrowsersInfo().isEmpty()) {
            this.getConfiguration().getBrowsersInfo().add(new RenderBrowserInfo(this.viewportSize, BrowserType.CHROME));
        }
    }

    private void setViewportSize(EyesWebDriver webDriver) {
        List browserInfoList;
        this.viewportSize = this.getConfiguration().getViewportSize();
        if (this.viewportSize == null && (browserInfoList = this.getConfiguration().getBrowsersInfo()) != null && !browserInfoList.isEmpty()) {
            for (RenderBrowserInfo deviceInfo : browserInfoList) {
                if (deviceInfo.getEmulationInfo() != null) continue;
                this.viewportSize = new RectangleSize(deviceInfo.getWidth(), deviceInfo.getHeight());
            }
        }
        if (this.viewportSize == null) {
            this.viewportSize = EyesSeleniumUtils.getViewportSize(webDriver);
        }
        try {
            EyesSeleniumUtils.setViewportSize(this.logger, webDriver, this.viewportSize);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
    }

    private IEyesConnector createVGEyesConnector(RenderBrowserInfo browserInfo) {
        String apiKey;
        URI serverUri;
        this.logger.verbose("creating VisualGridEyes server connector");
        EyesConnector VGEyesConnector = new EyesConnector(this.getConfiguration(), this.properties, browserInfo);
        if (browserInfo.getEmulationInfo() != null) {
            VGEyesConnector.setDevice(browserInfo.getEmulationInfo().getDeviceName() + " (Chrome emulation)");
        } else if (browserInfo.getIosDeviceInfo() != null) {
            VGEyesConnector.setDevice(browserInfo.getIosDeviceInfo().getDeviceName());
        }
        VGEyesConnector.setLogHandler(this.logger.getLogHandler());
        VGEyesConnector.setProxy(this.getConfiguration().getProxy());
        if (this.serverConnector != null) {
            VGEyesConnector.setServerConnector(this.serverConnector);
        }
        if ((serverUri = this.getServerUrl()) != null) {
            VGEyesConnector.setServerUrl(serverUri.toString());
        }
        if ((apiKey = this.getApiKey()) == null) {
            throw new EyesException("Missing API key");
        }
        VGEyesConnector.setApiKey(apiKey);
        if (this.renderingInfo == null) {
            this.logger.verbose("initializing rendering info...");
            this.renderingInfo = VGEyesConnector.getRenderingInfo();
        }
        VGEyesConnector.setRenderInfo(this.renderingInfo);
        this.VGEyesConnector = VGEyesConnector;
        return VGEyesConnector;
    }

    private void initDriver(WebDriver webDriver) {
        String currentUrl;
        if (webDriver instanceof RemoteWebDriver) {
            this.webDriver = new EyesWebDriver(this.logger, null, (RemoteWebDriver)webDriver);
        }
        this.url = currentUrl = webDriver.getCurrentUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningTest getNextTestToClose() {
        List<RunningTest> list = this.testsInCloseProcess;
        synchronized (list) {
            List<RunningTest> list2 = this.testList;
            synchronized (list2) {
                for (RunningTest runningTest : this.testList) {
                    if (runningTest.isTestClose() || !runningTest.isTestReadyToClose() || this.testsInCloseProcess.contains(runningTest)) continue;
                    return runningTest;
                }
            }
        }
        return null;
    }

    public Collection<Future<TestResultContainer>> close() {
        if (!this.validateEyes()) {
            return new ArrayList<Future<TestResultContainer>>();
        }
        return this.closeAndReturnResults(false);
    }

    @Override
    public TestResults close(boolean throwException) {
        Collection<Future<TestResultContainer>> close = this.close();
        return this.parseCloseFutures(close, throwException);
    }

    private TestResults parseCloseFutures(Collection<Future<TestResultContainer>> close, boolean shouldThrowException) {
        if (close != null && !close.isEmpty()) {
            TestResultContainer errorResult = null;
            TestResultContainer firstResult = null;
            try {
                for (Future<TestResultContainer> closeFuture : close) {
                    Throwable error;
                    TestResultContainer testResultContainer = closeFuture.get();
                    if (firstResult == null) {
                        firstResult = testResultContainer;
                    }
                    if ((error = testResultContainer.getException()) == null || errorResult != null) continue;
                    errorResult = testResultContainer;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            if (errorResult != null) {
                if (shouldThrowException) {
                    throw new Error(errorResult.getException());
                }
                return errorResult.getTestResults();
            }
            if (firstResult != null) {
                return firstResult.getTestResults();
            }
        }
        return null;
    }

    public TestResults abortIfNotClosed() {
        List<Future<TestResultContainer>> futures = this.abortAndCollectTasks();
        return this.parseCloseFutures(futures, false);
    }

    public boolean getIsOpen() {
        return !this.isEyesClosed();
    }

    public String getApiKey() {
        return this.apiKey == null ? this.renderingGridRunner.getApiKey() : this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setIsDisabled(Boolean disabled) {
        this.isDisabled = disabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled == null ? this.renderingGridRunner.getIsDisabled() : this.isDisabled.booleanValue();
    }

    public URI getServerUrl() {
        URI uri;
        if (this.VGEyesConnector != null && (uri = this.VGEyesConnector.getServerUrl()) != null) {
            return uri;
        }
        String str = this.serverUrl == null ? this.renderingGridRunner.getServerUrl() : this.serverUrl;
        return str == null ? null : URI.create(str);
    }

    private Collection<Future<TestResultContainer>> closeAndReturnResults(boolean throwException) {
        if (!this.validateEyes()) {
            return new ArrayList<Future<TestResultContainer>>();
        }
        if (this.closeFuturesSet == null) {
            this.closeFuturesSet = new HashSet<Future<TestResultContainer>>();
        }
        Throwable exception = null;
        this.logger.verbose("enter " + this.getConfiguration().getBatch());
        try {
            Collection<Future<TestResultContainer>> futureList = this.closeAsync();
            this.renderingGridRunner.close((IRenderingEyes)this);
            for (Future<TestResultContainer> future : futureList) {
                try {
                    TestResultContainer testResultContainer = future.get();
                    if (exception != null || testResultContainer.getException() == null) continue;
                    exception = testResultContainer.getException();
                }
                catch (Throwable e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        if (throwException && exception != null) {
            throw new Error(exception);
        }
        return this.closeFuturesSet;
    }

    public Collection<Future<TestResultContainer>> closeAsync() {
        if (!this.validateEyes()) {
            return new ArrayList<Future<TestResultContainer>>();
        }
        ArrayList<Future<TestResultContainer>> futureList = null;
        try {
            futureList = new ArrayList<Future<TestResultContainer>>();
            for (RunningTest runningTest : this.testList) {
                this.logger.verbose("running test name: " + this.getConfiguration().getTestName());
                this.logger.verbose("is current running test open: " + runningTest.isTestOpen());
                this.logger.verbose("is current running test ready to close: " + runningTest.isTestReadyToClose());
                this.logger.verbose("is current running test closed: " + runningTest.isTestClose());
                this.logger.verbose("closing current running test");
                FutureTask closeFuture = runningTest.close();
                if (closeFuture == null) continue;
                futureList.addAll(Collections.singleton(closeFuture));
                this.logger.verbose("adding closeFuture to futureList");
            }
            this.closeFuturesSet.addAll(futureList);
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        return futureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ScoreTask getBestScoreTaskForCheck() {
        int bestScore = -1;
        ScoreTask currentBest = null;
        for (RunningTest runningTest : this.testList) {
            List visualGridTaskList;
            List list = visualGridTaskList = runningTest.getVisualGridTaskList();
            synchronized (list) {
                if (visualGridTaskList.isEmpty()) {
                    continue;
                }
                VisualGridTask visualGridTask = (VisualGridTask)visualGridTaskList.get(0);
                if (!runningTest.isTestOpen() || visualGridTask.getType() != VisualGridTask.TaskType.CHECK || !visualGridTask.isTaskReadyToCheck()) {
                    continue;
                }
            }
            ScoreTask scoreTask = runningTest.getScoreTaskObjectByType(VisualGridTask.TaskType.CHECK);
            if (scoreTask == null || bestScore >= scoreTask.getScore()) continue;
            currentBest = scoreTask;
            bestScore = scoreTask.getScore();
        }
        return currentBest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoreTask getBestScoreTaskForOpen() {
        int bestMark = -1;
        ScoreTask currentBest = null;
        List<RunningTest> list = this.testList;
        synchronized (list) {
            for (RunningTest runningTest : this.testList) {
                ScoreTask currentScoreTask = runningTest.getScoreTaskObjectByType(VisualGridTask.TaskType.OPEN);
                if (currentScoreTask == null || bestMark >= currentScoreTask.getScore()) continue;
                bestMark = currentScoreTask.getScore();
                currentBest = currentScoreTask;
            }
        }
        return currentBest;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public boolean isEyesClosed() {
        boolean isVGEyesClosed = true;
        for (RunningTest runningTest : this.testList) {
            isVGEyesClosed = isVGEyesClosed && runningTest.isTestClose();
        }
        return isVGEyesClosed;
    }

    public void setListener(IRenderingEyes.EyesListener listener) {
        this.listener = listener;
    }

    @Override
    public void check(ICheckSettings ... checkSettings) {
        if (!this.validateEyes()) {
            return;
        }
        for (ICheckSettings checkSetting : checkSettings) {
            this.check(checkSetting);
        }
    }

    @Override
    public void check(String name, ICheckSettings checkSettings) {
        if (!this.validateEyes()) {
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        if (name != null) {
            checkSettings = checkSettings.withName(name);
        }
        this.check(checkSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(ICheckSettings checkSettings) {
        this.logger.verbose("enter");
        if (!this.validateEyes()) {
            return;
        }
        ArgumentGuard.notOfType((Object)checkSettings, ICheckSettings.class, (String)"checkSettings");
        this.waitBeforeDomSnapshot();
        try {
            FrameChain originalFC = this.webDriver.getFrameChain().clone();
            EyesTargetLocator switchTo = (EyesTargetLocator)this.webDriver.switchTo();
            checkSettings = this.switchFramesAsNeeded(checkSettings, switchTo);
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
            this.isCheckTimerTimedOut.set(false);
            List<VisualGridTask> openVisualGridTasks = this.addOpenTaskToAllRunningTest();
            ArrayList<VisualGridTask> visualGridTaskList = new ArrayList<VisualGridTask>();
            FrameData scriptResult = this.captureDomSnapshot(originalFC, switchTo, checkSettingsInternal);
            List<VisualGridSelector[]> regionsXPaths = this.getRegionsXPaths(checkSettingsInternal);
            this.logger.verbose("regionXPaths : " + regionsXPaths);
            this.trySetTargetSelector((SeleniumCheckSettings)checkSettings);
            checkSettingsInternal = this.updateCheckSettings(checkSettings);
            List<RunningTest> filteredTests = VisualGridEyes.collectTestsForCheck(this.logger, this.testList);
            String source = this.webDriver.getCurrentUrl();
            for (RunningTest runningTest : filteredTests) {
                VisualGridTask checkVisualGridTask = runningTest.check((ICheckSettings)checkSettingsInternal, regionsXPaths, source);
                visualGridTaskList.add(checkVisualGridTask);
            }
            this.logger.verbose("added check tasks  (" + checkSettingsInternal.toString() + ")");
            this.renderingGridRunner.check((ICheckSettings)checkSettingsInternal, this.debugResourceWriter, scriptResult, this.VGEyesConnector, visualGridTaskList, openVisualGridTasks, new VisualGridRunner.RenderListener(){

                public void onRenderSuccess() {
                }

                public void onRenderFailed(Exception e) {
                    GeneralUtils.logExceptionStackTrace((Logger)VisualGridEyes.this.logger, (Throwable)e);
                }
            }, regionsXPaths, this.userAgent);
            this.logger.verbose("created renderTask  (" + checkSettings.toString() + ")");
            switchTo.frames(originalFC);
        }
        catch (Throwable e) {
            Error error = new Error(e);
            this.abort(e);
            for (RunningTest runningTest : this.testList) {
                runningTest.setTestInExceptionMode((Throwable)error);
            }
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        finally {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
    }

    public static List<RunningTest> collectTestsForCheck(Logger logger, List<RunningTest> tests) {
        ArrayList<RunningTest> filteredTests = new ArrayList<RunningTest>();
        for (RunningTest test : tests) {
            boolean lastTaskIsNotAClosingTask;
            List taskList = test.getVisualGridTaskList();
            VisualGridTask visualGridTask = null;
            if (!taskList.isEmpty()) {
                visualGridTask = (VisualGridTask)taskList.get(taskList.size() - 1);
            }
            VisualGridTask.TaskType lastTaskType = null;
            if (visualGridTask != null) {
                lastTaskType = visualGridTask.getType();
            }
            boolean testIsOpenAndNotClosed = lastTaskType == null && test.isOpenTaskIssued() && !test.isCloseTaskIssued();
            boolean bl = lastTaskIsNotAClosingTask = lastTaskType != null && lastTaskType != VisualGridTask.TaskType.CLOSE && lastTaskType != VisualGridTask.TaskType.ABORT;
            if (!testIsOpenAndNotClosed && !lastTaskIsNotAClosingTask) continue;
            filteredTests.add(test);
        }
        return filteredTests;
    }

    private ICheckSettings switchFramesAsNeeded(ICheckSettings checkSettings, EyesTargetLocator switchTo) {
        int switchedToCount = this.switchToFrame((ISeleniumCheckTarget)checkSettings);
        boolean isFullPage = this.isFullPage((ICheckSettingsInternal)checkSettings);
        if (switchedToCount > 0 && isFullPage) {
            FrameChain frameChain = this.webDriver.getFrameChain().clone();
            Frame frame = frameChain.pop();
            checkSettings = ((SeleniumCheckSettings)checkSettings).region(frame.getReference());
            switchTo.parentFrame();
        }
        return checkSettings;
    }

    private boolean isFullPage(ICheckSettingsInternal checkSettingsInternal) {
        boolean isFullPage = true;
        Boolean b = checkSettingsInternal.isStitchContent();
        if (b != null) {
            isFullPage = b;
        } else {
            b = this.getConfiguration().isForceFullPageScreenshot();
            if (b != null) {
                isFullPage = b;
            }
        }
        return isFullPage;
    }

    private FrameData captureDomSnapshot(FrameChain originalFC, EyesTargetLocator switchTo, ICheckSettingsInternal checkSettingsInternal) throws InterruptedException {
        this.logger.verbose("Dom extraction starting   (" + checkSettingsInternal.toString() + ")");
        this.timer = new Timer("VG_Check_StopWatch", true);
        this.timer.schedule((TimerTask)new TimeoutTask(), DOM_EXTRACTION_TIMEOUT);
        ScriptResponse.Status status = null;
        ScriptResponse scriptResponse = null;
        do {
            String resultAsString = (String)this.webDriver.executeScript(this.PROCESS_RESOURCES + "return __processPageAndSerializePoll();", new Object[0]);
            try {
                scriptResponse = (ScriptResponse)GeneralUtils.parseJsonToObject((String)resultAsString, ScriptResponse.class);
                this.logger.verbose("Dom extraction polling...");
                status = scriptResponse.getStatus();
            }
            catch (IOException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
            Thread.sleep(200L);
        } while (status == ScriptResponse.Status.WIP && !this.isCheckTimerTimedOut.get());
        this.timer.cancel();
        if (status == ScriptResponse.Status.ERROR) {
            switchTo.frames(originalFC);
            throw new EyesException("DomSnapshot Error: " + scriptResponse.getError());
        }
        if (this.isCheckTimerTimedOut.get()) {
            switchTo.frames(originalFC);
            throw new EyesException("Domsnapshot Timed out");
        }
        FrameData scriptResult = scriptResponse != null ? scriptResponse.getValue() : null;
        this.logger.verbose("Dom extracted  (" + checkSettingsInternal.toString() + ")");
        return scriptResult;
    }

    private void waitBeforeDomSnapshot() {
        int waitBeforeScreenshots = this.getConfiguration().getWaitBeforeScreenshots();
        try {
            Thread.sleep(waitBeforeScreenshots);
        }
        catch (InterruptedException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
    }

    private ICheckSettingsInternal updateCheckSettings(ICheckSettings checkSettings) {
        Boolean b;
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        MatchLevel matchLevel = checkSettingsInternal.getMatchLevel();
        Boolean fully = checkSettingsInternal.isStitchContent();
        Boolean sendDom = checkSettingsInternal.isSendDom();
        Boolean ignoreDisplacements = checkSettingsInternal.isIgnoreDisplacements();
        if (matchLevel == null) {
            checkSettings = checkSettings.matchLevel(this.getConfiguration().getMatchLevel());
        }
        if (fully == null) {
            b = this.getConfiguration().isForceFullPageScreenshot();
            checkSettings = checkSettings.fully(Boolean.valueOf(b == null ? true : b));
        }
        if (sendDom == null) {
            b = this.getConfiguration().isSendDom();
            checkSettings = checkSettings.sendDom(b == null ? true : b);
        }
        if (ignoreDisplacements == null) {
            checkSettings = checkSettings.ignoreDisplacements(this.getConfiguration().getIgnoreDisplacements());
        }
        return (ICheckSettingsInternal)checkSettings;
    }

    private void trySetTargetSelector(SeleniumCheckSettings checkSettings) {
        By targetSelector;
        WebElement element = checkSettings.getTargetElement();
        FrameChain frameChain = this.webDriver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.webDriver.switchTo();
        this.switchToFrame(checkSettings);
        if (element == null && (targetSelector = checkSettings.getTargetSelector()) != null) {
            element = this.webDriver.findElement(targetSelector);
        }
        if (element != null) {
            String xpath = (String)this.webDriver.executeScript(GET_ELEMENT_XPATH_JS, element);
            VisualGridSelector vgs = new VisualGridSelector(xpath, (Object)"target");
            checkSettings.setTargetSelector(vgs);
        }
        switchTo.frames(frameChain);
    }

    private int switchToFrame(ISeleniumCheckTarget checkTarget) {
        if (checkTarget == null) {
            return 0;
        }
        List<FrameLocator> frameChain = checkTarget.getFrameChain();
        int switchedToFrameCount = 0;
        for (FrameLocator frameLocator : frameChain) {
            if (!this.switchToFrame(frameLocator)) continue;
            ++switchedToFrameCount;
        }
        return switchedToFrameCount;
    }

    private boolean switchToFrame(ISeleniumFrameCheckTarget frameTarget) {
        WebElement frameElement;
        WebDriver.TargetLocator switchTo = this.webDriver.switchTo();
        if (frameTarget.getFrameIndex() != null) {
            switchTo.frame(frameTarget.getFrameIndex().intValue());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameNameOrId() != null) {
            switchTo.frame(frameTarget.getFrameNameOrId());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameReference() != null) {
            switchTo.frame(frameTarget.getFrameReference());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameSelector() != null && (frameElement = this.webDriver.findElement(frameTarget.getFrameSelector())) != null) {
            switchTo.frame(frameElement);
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        return false;
    }

    private void updateFrameScrollRoot(IScrollRootElementContainer frameTarget) {
        WebElement rootElement = this.getScrollRootElement(frameTarget);
        Frame frame = this.webDriver.getFrameChain().peek();
        frame.setScrollRootElement(rootElement);
    }

    private WebElement getScrollRootElement(IScrollRootElementContainer scrollRootElementContainer) {
        WebElement scrollRootElement = null;
        if (!EyesSeleniumUtils.isMobileDevice(this.webDriver)) {
            if (scrollRootElementContainer == null) {
                scrollRootElement = this.webDriver.findElement(By.tagName((String)"html"));
            } else {
                scrollRootElement = scrollRootElementContainer.getScrollRootElement();
                if (scrollRootElement == null) {
                    By scrollRootSelector = scrollRootElementContainer.getScrollRootSelector();
                    scrollRootElement = this.webDriver.findElement(scrollRootSelector != null ? scrollRootSelector : By.tagName((String)"html"));
                }
            }
        }
        return scrollRootElement;
    }

    private synchronized List<VisualGridTask> addOpenTaskToAllRunningTest() {
        this.logger.verbose("enter");
        ArrayList<VisualGridTask> visualGridTasks = new ArrayList<VisualGridTask>();
        for (RunningTest runningTest : this.testList) {
            if (runningTest.isOpenTaskIssued()) continue;
            VisualGridTask visualGridTask = runningTest.open();
            visualGridTasks.add(visualGridTask);
        }
        this.logger.verbose("calling addOpenTaskToAllRunningTest.open");
        this.isVGEyesIssuedOpenTasks.set(true);
        this.logger.verbose("exit");
        return visualGridTasks;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List<RunningTest> getAllRunningTests() {
        return this.testList;
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.debugResourceWriter = debugResourceWriter;
    }

    public String toString() {
        return "SeleniumVGEyes - url: " + this.url;
    }

    public void setServerConnector(ServerConnector serverConnector) {
        this.serverConnector = serverConnector;
    }

    public String getFullAgentId() {
        String agentId = this.getConfiguration().getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    private Configuration getConfiguration() {
        return this.configurationProvider.get();
    }

    public String getBaseAgentId() {
        return "eyes.selenium.visualgrid.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    public void setBatch(BatchInfo batch) {
        if (this.isDisabled.booleanValue()) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.verbose("setBatch(" + batch + ")");
        this.getConfiguration().setBatch(batch);
    }

    private List<VisualGridSelector[]> getRegionsXPaths(ICheckSettingsInternal csInternal) {
        List<WebElementRegion>[] elementLists;
        ArrayList<VisualGridSelector[]> result = new ArrayList<VisualGridSelector[]>();
        for (List<WebElementRegion> elementList : elementLists = this.collectSeleniumRegions(csInternal)) {
            ArrayList<VisualGridSelector> xpaths = new ArrayList<VisualGridSelector>();
            for (WebElementRegion webElementRegion : elementList) {
                if (webElementRegion.getElement() == null) continue;
                String xpath = (String)this.webDriver.executeScript(GET_ELEMENT_XPATH_JS, webElementRegion.getElement());
                xpaths.add(new VisualGridSelector(xpath, webElementRegion.getRegion()));
            }
            result.add(xpaths.toArray(new VisualGridSelector[0]));
        }
        return result;
    }

    private List<WebElementRegion>[] collectSeleniumRegions(ICheckSettingsInternal csInternal) {
        By targetSelector;
        CheckSettings settings = (CheckSettings)csInternal;
        GetRegion[] ignoreRegions = settings.getIgnoreRegions();
        GetRegion[] layoutRegions = settings.getLayoutRegions();
        GetRegion[] strictRegions = settings.getStrictRegions();
        GetRegion[] contentRegions = settings.getContentRegions();
        GetFloatingRegion[] floatingRegions = settings.getFloatingRegions();
        IGetAccessibilityRegion[] accessibilityRegions = settings.getAccessibilityRegions();
        List<WebElementRegion> ignoreElements = this.getElementsFromRegions(Arrays.asList(ignoreRegions));
        List<WebElementRegion> layoutElements = this.getElementsFromRegions(Arrays.asList(layoutRegions));
        List<WebElementRegion> strictElements = this.getElementsFromRegions(Arrays.asList(strictRegions));
        List<WebElementRegion> contentElements = this.getElementsFromRegions(Arrays.asList(contentRegions));
        List<WebElementRegion> floatingElements = this.getElementsFromRegions(Arrays.asList(floatingRegions));
        List<WebElementRegion> accessibilityElements = this.getElementsFromRegions(Arrays.asList(accessibilityRegions));
        ISeleniumCheckTarget iSeleniumCheckTarget = (ISeleniumCheckTarget)csInternal;
        WebElement targetElement = iSeleniumCheckTarget.getTargetElement();
        if (targetElement == null && (targetSelector = iSeleniumCheckTarget.getTargetSelector()) != null) {
            targetElement = this.webDriver.findElement(targetSelector);
        }
        WebElementRegion target = new WebElementRegion(targetElement, "target");
        ArrayList<WebElementRegion> targetElementList = new ArrayList<WebElementRegion>();
        targetElementList.add(target);
        List[] lists = new List[]{ignoreElements, layoutElements, strictElements, contentElements, floatingElements, accessibilityElements, targetElementList};
        return lists;
    }

    private List<WebElementRegion> getElementsFromRegions(List regionsProvider) {
        ArrayList<WebElementRegion> elements = new ArrayList<WebElementRegion>();
        for (Object getRegion : regionsProvider) {
            if (!(getRegion instanceof IGetSeleniumRegion)) continue;
            IGetSeleniumRegion getSeleniumRegion = (IGetSeleniumRegion)getRegion;
            List<WebElement> webElements = getSeleniumRegion.getElements(this.webDriver);
            for (WebElement webElement : webElements) {
                elements.add(new WebElementRegion(webElement, getRegion));
            }
        }
        return elements;
    }

    public void addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    private boolean validateEyes() {
        if (this.isDisabled.booleanValue()) {
            this.logger.verbose("WARNING! Invalid Operation - Eyes Disabled!");
            return false;
        }
        if (!this.renderingGridRunner.isServicesOn()) {
            this.logger.verbose("WARNING! Invalid Operation - visualGridRunner.getAllTestResults already called!");
            return false;
        }
        return true;
    }

    public List<TestResultContainer> getAllTestResults() {
        return this.allTestResults;
    }

    @Override
    public EyesWebDriver getDriver() {
        return this.webDriver;
    }

    public IBatchCloser getBatchCloser() {
        return this.testList.get(0).getBatchCloser();
    }

    public String getBatchId() {
        return this.getConfiguration().getBatch().getId();
    }

    private void abort(Throwable e) {
        for (RunningTest runningTest : this.testList) {
            runningTest.abort(true, e);
        }
    }

    public void abortAsync() {
        this.abortAndCollectTasks();
    }

    public TestResults abort() {
        List<Future<TestResultContainer>> tasks = this.abortAndCollectTasks();
        return this.parseCloseFutures(tasks, false);
    }

    private List<Future<TestResultContainer>> abortAndCollectTasks() {
        ArrayList<Future<TestResultContainer>> tasks = new ArrayList<Future<TestResultContainer>>();
        for (RunningTest runningTest : this.testList) {
            Future task = runningTest.abort(false, null);
            tasks.add(task);
        }
        return tasks;
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            VisualGridEyes.this.logger.verbose("Check Timer timeout.");
            VisualGridEyes.this.isCheckTimerTimedOut.set(true);
        }
    }
}

