/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;

public class Frame {
    protected final Logger logger;
    protected final WebElement reference;
    protected final Location location;
    protected final RectangleSize size;
    protected final RectangleSize innerSize;
    protected final Location parentScrollPosition;
    protected final Location originalLocation;

    public Frame(Logger logger, WebElement reference, Location location, RectangleSize size, RectangleSize innerSize, Location parentScrollPosition, Location originalLocation) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)reference, (String)"reference");
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)size, (String)"size");
        ArgumentGuard.notNull((Object)innerSize, (String)"innerSize");
        ArgumentGuard.notNull((Object)parentScrollPosition, (String)"parentScrollPosition");
        ArgumentGuard.notNull((Object)originalLocation, (String)"originalLocation");
        logger.verbose(String.format("Frame(logger, reference, %s, %s, %s, %s)", location, size, innerSize, parentScrollPosition));
        this.logger = logger;
        this.reference = reference;
        this.location = location;
        this.size = size;
        this.innerSize = innerSize;
        this.parentScrollPosition = parentScrollPosition;
        this.originalLocation = originalLocation;
    }

    public WebElement getReference() {
        return this.reference;
    }

    public Location getLocation() {
        return this.location;
    }

    public RectangleSize getSize() {
        return this.size;
    }

    public RectangleSize getInnerSize() {
        return this.innerSize;
    }

    public Location getParentScrollPosition() {
        return this.parentScrollPosition;
    }

    public Location getOriginalLocation() {
        return this.originalLocation;
    }
}

