/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.selenium.Eyes;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshot;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class FirefoxScreenshotImageProvider
implements ImageProvider {
    private final Eyes eyes;
    private final Logger logger;
    private final TakesScreenshot tsInstance;

    public FirefoxScreenshotImageProvider(Eyes eyes, Logger logger, TakesScreenshot tsInstance) {
        this.eyes = eyes;
        this.logger = logger;
        this.tsInstance = tsInstance;
    }

    public BufferedImage getImage() {
        this.logger.verbose("Getting screenshot as base64...");
        String screenshot64 = (String)this.tsInstance.getScreenshotAs(OutputType.BASE64);
        this.logger.verbose("Done getting base64! Creating BufferedImage...");
        BufferedImage image = ImageUtils.imageFromBase64((String)screenshot64);
        this.eyes.getDebugScreenshotsProvider().save(image, "FIREFOX_FRAME");
        EyesWebDriver eyesWebDriver = (EyesWebDriver)this.eyes.getDriver();
        FrameChain frameChain = eyesWebDriver.getFrameChain();
        if (frameChain.size() > 0) {
            EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, eyesWebDriver, image);
            Location loc = screenshot.getFrameWindow().getLocation();
            this.logger.verbose("");
            this.logger.verbose("frame.getLocation(): " + loc);
            this.logger.verbose("");
            double scaleRatio = this.eyes.getDevicePixelRatio();
            RectangleSize viewportSize = this.eyes.getViewportSize();
            viewportSize = viewportSize.scale(scaleRatio);
            loc = loc.scale(scaleRatio);
            BufferedImage fullImage = new BufferedImage(viewportSize.getWidth(), viewportSize.getHeight(), image.getType());
            fullImage.getRaster().setRect(loc.getX(), loc.getY(), image.getData());
            return fullImage;
        }
        return image;
    }
}

