const assert = require('assert');
const {promisify: p} = require('util');
const pollify = require('../src/pollify');
const delay = p(setTimeout);

describe('pollify', () => {
  it('works', async () => {
    const func = result => new Promise(resolve => setTimeout(resolve, 100, result));
    const funcPoll = pollify(func, {}, 'key')();
    assert.strictEqual(typeof funcPoll, 'function');
    const r = funcPoll('result');
    assert.deepStrictEqual(r, {status: 'WIP'});
    await delay(100);
    const r2 = funcPoll('result 2');
    assert.deepStrictEqual(r2, {status: 'SUCCESS', value: 'result'});
  });

  it('returns error when rejects', async () => {
    const func = () => new Promise((_, reject) => setTimeout(reject, 100, new Error('error')));
    const funcPoll = pollify(func, {}, 'key')();
    const r = funcPoll();
    assert.deepStrictEqual(r, {status: 'WIP'});
    await delay(100);
    const r2 = funcPoll();
    assert.deepStrictEqual(r2, {status: 'ERROR', error: 'error'});
  });
});
