/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.selenium.Eyes;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class SafariScreenshotImageProvider
implements ImageProvider {
    private final Eyes eyes;
    private final Logger logger;
    private final TakesScreenshot tsInstance;
    private final IEyesJsExecutor jsExecutor;

    public SafariScreenshotImageProvider(Eyes eyes, Logger logger, TakesScreenshot tsInstance) {
        this.eyes = eyes;
        this.logger = logger;
        this.tsInstance = tsInstance;
        this.jsExecutor = new SeleniumJavaScriptExecutor((EyesWebDriver)eyes.getDriver());
    }

    public BufferedImage getImage() {
        this.logger.verbose("Getting screenshot as base64...");
        String screenshot64 = (String)this.tsInstance.getScreenshotAs(OutputType.BASE64);
        this.logger.verbose("Done getting base64! Creating BufferedImage...");
        BufferedImage image = ImageUtils.imageFromBase64((String)screenshot64);
        this.eyes.getDebugScreenshotsProvider().save(image, "SAFARI");
        if (!this.eyes.getForceFullPageScreenshot()) {
            Location loc;
            FrameChain currentFrameChain = ((EyesWebDriver)this.eyes.getDriver()).getFrameChain();
            if (currentFrameChain.size() == 0) {
                ScrollPositionProvider positionProvider = new ScrollPositionProvider(this.logger, this.jsExecutor);
                loc = positionProvider.getCurrentPosition();
            } else {
                loc = currentFrameChain.getDefaultContentScrollPosition();
            }
            double scaleRatio = this.eyes.getDevicePixelRatio();
            RectangleSize viewportSize = this.eyes.getViewportSize();
            viewportSize = viewportSize.scale(scaleRatio);
            loc = loc.scale(scaleRatio);
            BufferedImage cutImage = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(loc, viewportSize));
            return cutImage;
        }
        return image;
    }
}

