/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchWindowDataWithScreenshot;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.ScaleProviderIdentityFactory;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.diagnostics.TimedAppOutput;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.ICheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.positioning.NullRegionProvider;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.scaling.FixedScaleProviderFactory;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.selenium.ContextBasedScaleProviderFactory;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshot;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshotFactory;
import com.applitools.eyes.selenium.capture.FullPageCaptureAlgorithm;
import com.applitools.eyes.selenium.capture.ImageProviderFactory;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.ISeleniumFrameCheckTarget;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionProvider;
import com.applitools.eyes.selenium.positioning.ElementPositionProvider;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensationFactory;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.regionVisibility.MoveToRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.NopRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.RegionVisibilityStrategy;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Eyes
extends EyesBase {
    public static final double UNKNOWN_DEVICE_PIXEL_RATIO = 0.0;
    public static final double DEFAULT_DEVICE_PIXEL_RATIO = 1.0;
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private static final int RESPONSE_TIME_DEFAULT_DEADLINE = 10;
    private static final int RESPONSE_TIME_DEFAULT_DIFF_FROM_DEADLINE = 20;
    private static final int DEFAULT_WAIT_BEFORE_SCREENSHOTS = 100;
    private EyesWebDriver driver;
    private boolean dontGetTitle = false;
    private boolean forceFullPageScreenshot = false;
    private boolean checkFrameOrElement = false;
    private Region regionToCheck = null;
    private boolean hideScrollbars = false;
    private ImageRotation rotation;
    private double devicePixelRatio = 0.0;
    private StitchMode stitchMode = StitchMode.SCROLL;
    private int waitBeforeScreenshots = 100;
    private RegionVisibilityStrategy regionVisibilityStrategy = new MoveToRegionVisibilityStrategy(this.logger);
    private ElementPositionProvider elementPositionProvider;
    private SeleniumJavaScriptExecutor jsExecutor;
    private UserAgent userAgent;
    private ImageProvider imageProvider;
    private RegionPositionCompensation regionPositionCompensation;
    private WebElement targetElement = null;
    private boolean stitchContent = false;

    public Region getRegionToCheck() {
        return this.regionToCheck;
    }

    public void setRegionToCheck(Region regionToCheck) {
        this.regionToCheck = regionToCheck;
    }

    public boolean shouldStitchContent() {
        return this.stitchContent;
    }

    public Eyes(URI serverUrl) {
        super(serverUrl);
    }

    public Eyes() {
        this(Eyes.getDefaultServerUrl());
    }

    public String getBaseAgentId() {
        return "eyes.selenium.java/3.26";
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.forceFullPageScreenshot = shouldForce;
    }

    public boolean getForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    public void setWaitBeforeScreenshots(int waitBeforeScreenshots) {
        this.waitBeforeScreenshots = waitBeforeScreenshots <= 0 ? 100 : waitBeforeScreenshots;
    }

    public int getWaitBeforeScreenshots() {
        return this.waitBeforeScreenshots;
    }

    public void setScrollToRegion(boolean shouldScroll) {
        this.regionVisibilityStrategy = shouldScroll ? new MoveToRegionVisibilityStrategy(this.logger) : new NopRegionVisibilityStrategy(this.logger);
    }

    public boolean getScrollToRegion() {
        return !(this.regionVisibilityStrategy instanceof NopRegionVisibilityStrategy);
    }

    public void setStitchMode(StitchMode mode) {
        this.logger.verbose("setting stitch mode to " + (Object)((Object)mode));
        this.stitchMode = mode;
        if (this.driver != null) {
            this.initPositionProvider();
        }
    }

    public StitchMode getStitchMode() {
        return this.stitchMode;
    }

    public void setHideScrollbars(boolean shouldHide) {
        this.hideScrollbars = shouldHide;
    }

    public boolean getHideScrollbars() {
        return this.hideScrollbars;
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        if (this.driver != null) {
            this.driver.setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        return this.open(driver, appName, testName, viewportSize, null);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        return this.open(driver, appName, testName, null, null);
    }

    protected WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return driver;
        }
        this.initDriver(driver);
        String uaString = this.driver.getUserAgent();
        if (uaString != null) {
            this.userAgent = UserAgent.ParseUserAgentString((String)uaString, (boolean)true);
        }
        this.imageProvider = ImageProviderFactory.getImageProvider(this.userAgent, this, this.logger, this.driver);
        this.regionPositionCompensation = RegionPositionCompensationFactory.getRegionPositionCompensation(this.userAgent, this, this.logger);
        this.openBase(appName, testName, viewportSize, sessionType);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.devicePixelRatio = 0.0;
        this.jsExecutor = new SeleniumJavaScriptExecutor(this.driver);
        this.initPositionProvider();
        this.driver.setRotation(this.rotation);
        return this.driver;
    }

    private void initDriver(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesWebDriver(this.logger, this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesWebDriver) {
            this.driver = (EyesWebDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    private void initPositionProvider() {
        StitchMode stitchMode = this.getStitchMode();
        this.logger.verbose("initializing position provider. stitchMode: " + (Object)((Object)stitchMode));
        switch (stitchMode) {
            case CSS: {
                this.setPositionProvider(new CssTranslatePositionProvider(this.logger, this.jsExecutor));
                break;
            }
            default: {
                this.setPositionProvider(new ScrollPositionProvider(this.logger, this.jsExecutor));
            }
        }
    }

    protected WebDriver open(WebDriver driver, String appName, String testName, SessionType sessionType) {
        return this.open(driver, appName, testName, null, sessionType);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.checkWindow(-1, tag);
    }

    public void checkWindow(int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckWindow(%d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.logger.log(String.format("CheckWindow(%d, '%s')", matchTimeout, tag));
        this.regionToCheck = null;
        super.checkWindowBase((RegionProvider)NullRegionProvider.INSTANCE, tag, false, matchTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWindow(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.open(driver, appName, testName, viewportSize);
        try {
            this.checkWindow(testName);
            this.close();
        }
        finally {
            this.abortIfNotClosed();
        }
    }

    public void testWindow(WebDriver driver, String appName, String testName) {
        this.testWindow(driver, appName, testName, null);
    }

    public void testWindow(WebDriver driver, String testName, RectangleSize viewportSize) {
        this.testWindow(driver, null, testName, viewportSize);
    }

    public void testWindow(WebDriver driver, String testName) {
        this.testWindow(driver, testName, (RectangleSize)null);
    }

    public void testResponseTime(final WebDriver driver, String appName, String testName, final WebDriverAction action, int deadline, int timeout) {
        this.open(driver, appName, testName, SessionType.PROGRESSION);
        Runnable runnableAction = null;
        if (action != null) {
            runnableAction = new Runnable(){

                @Override
                public void run() {
                    action.drive(driver);
                }
            };
        }
        MatchWindowDataWithScreenshot result = super.testResponseTimeBase((RegionProvider)NullRegionProvider.INSTANCE, runnableAction, deadline, timeout, 5000L);
        this.logger.verbose("Checking if deadline was exceeded...");
        boolean deadlineExceeded = true;
        if (result != null) {
            TimedAppOutput tao = (TimedAppOutput)result.getMatchWindowData().getAppOutput();
            long resultElapsed = tao.getElapsed();
            long deadlineMs = deadline * 1000;
            this.logger.verbose(String.format("Deadline: %d, Elapsed time for match: %d", deadlineMs, resultElapsed));
            deadlineExceeded = resultElapsed > deadlineMs;
        }
        this.logger.verbose("Deadline exceeded? " + deadlineExceeded);
        this.closeResponseTime(deadlineExceeded);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline) {
        this.testResponseTime(driver, appName, testName, action, deadline, deadline + 20);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action) {
        this.testResponseTime(driver, appName, testName, action, 10, 30);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline) {
        this.testResponseTime(driver, appName, testName, null, deadline, deadline + 20);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName) {
        this.testResponseTime(driver, appName, testName, null, 10, 30);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline, int timeout, RectangleSize viewportSize) {
        Eyes.setViewportSize(driver, viewportSize);
        this.testResponseTime(driver, appName, testName, action, deadline, timeout);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, action, deadline, deadline + 20, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, action, 10, 30, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline, int timeout, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, null, deadline, timeout, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, deadline, deadline + 20, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, 10, 30, viewportSize);
    }

    public void check(String name, ICheckSettings checkSettings) {
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        this.logger.verbose(String.format("check(\"%s\", checkSettings) - begin", name));
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        ISeleniumCheckTarget seleniumCheckTarget = checkSettings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)checkSettings : null;
        this.stitchContent = checkSettingsInternal.getStitchContent();
        final Region targetRegion = checkSettingsInternal.getTargetRegion();
        int switchedToFrameCount = this.switchToFrame(seleniumCheckTarget);
        this.regionToCheck = null;
        if (targetRegion != null) {
            this.checkWindowBase(new RegionProvider(){

                public Region getRegion() {
                    return targetRegion;
                }
            }, name, false, checkSettings);
        } else if (seleniumCheckTarget != null) {
            By targetSelector = seleniumCheckTarget.getTargetSelector();
            WebElement targetElement = seleniumCheckTarget.getTargetElement();
            if (targetElement == null && targetSelector != null) {
                targetElement = this.driver.findElement(targetSelector);
            }
            if (targetElement != null) {
                this.targetElement = targetElement;
                if (this.stitchContent) {
                    this.checkElement(name, checkSettings);
                } else {
                    this.checkRegion(name, checkSettings);
                }
                this.targetElement = null;
            } else if (seleniumCheckTarget.getFrameChain().size() > 0) {
                if (this.stitchContent) {
                    this.checkFullFrameOrElement(name, checkSettings);
                } else {
                    this.checkFrameFluent(name, checkSettings);
                }
            } else {
                this.checkWindowBase((RegionProvider)NullRegionProvider.INSTANCE, name, false, checkSettings);
            }
        }
        while (switchedToFrameCount > 0) {
            this.driver.switchTo().parentFrame();
            --switchedToFrameCount;
        }
        this.stitchContent = false;
        this.logger.verbose("check - done!");
    }

    protected void checkFrameFluent(String name, ICheckSettings checkSettings) {
        FrameChain frameChain = new FrameChain(this.logger, this.driver.getFrameChain());
        Frame targetFrame = frameChain.pop();
        this.targetElement = targetFrame.getReference();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        switchTo.framesDoScroll(frameChain);
        this.checkRegion(name, checkSettings);
        this.targetElement = null;
    }

    private int switchToFrame(ISeleniumCheckTarget checkTarget) {
        if (checkTarget == null) {
            return 0;
        }
        List<FrameLocator> frameChain = checkTarget.getFrameChain();
        int switchedToFrameCount = 0;
        for (FrameLocator frameLocator : frameChain) {
            if (!this.switchToFrame(frameLocator)) continue;
            ++switchedToFrameCount;
        }
        return switchedToFrameCount;
    }

    private boolean switchToFrame(ISeleniumFrameCheckTarget frameTarget) {
        WebElement frameElement;
        WebDriver.TargetLocator switchTo = this.driver.switchTo();
        if (frameTarget.getFrameIndex() != null) {
            switchTo.frame(frameTarget.getFrameIndex().intValue());
            return true;
        }
        if (frameTarget.getFrameNameOrId() != null) {
            switchTo.frame(frameTarget.getFrameNameOrId());
            return true;
        }
        if (frameTarget.getFrameSelector() != null && (frameElement = this.driver.findElement(frameTarget.getFrameSelector())) != null) {
            switchTo.frame(frameElement);
            return true;
        }
        return false;
    }

    private void checkFullFrameOrElement(String name, ICheckSettings checkSettings) {
        this.checkFrameOrElement = true;
        this.logger.verbose("checkFullFrameOrElement()");
        this.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                if (Eyes.this.checkFrameOrElement) {
                    FrameChain fc = Eyes.this.ensureFrameVisible();
                    ScaleProviderFactory scaleProviderFactory = Eyes.this.updateScalingParams();
                    BufferedImage screenshotImage = Eyes.this.imageProvider.getImage();
                    Eyes.this.debugScreenshotsProvider.save(screenshotImage, "checkFullFrameOrElement");
                    scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
                    EyesTargetLocator switchTo = (EyesTargetLocator)Eyes.this.driver.switchTo();
                    switchTo.frames(fc);
                    EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(Eyes.this.logger, Eyes.this.driver, screenshotImage);
                    Eyes.this.logger.verbose("replacing regionToCheck");
                    Eyes.this.setRegionToCheck(screenshot.getFrameWindow());
                }
                return Region.EMPTY;
            }
        }, name, false, checkSettings);
        this.checkFrameOrElement = false;
    }

    private FrameChain ensureFrameVisible() {
        FrameChain originalFC = new FrameChain(this.logger, this.driver.getFrameChain());
        FrameChain fc = new FrameChain(this.logger, this.driver.getFrameChain());
        while (fc.size() > 0) {
            this.driver.getRemoteWebDriver().switchTo().parentFrame();
            Frame frame = fc.pop();
            this.positionProvider.setPosition(frame.getLocation());
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
        return originalFC;
    }

    private void ensureElementVisible(WebElement element) {
        if (this.targetElement == null) {
            return;
        }
        FrameChain originalFC = new FrameChain(this.logger, this.driver.getFrameChain());
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        EyesRemoteWebElement eyesRemoteWebElement = new EyesRemoteWebElement(this.logger, this.driver, element);
        Region elementBounds = eyesRemoteWebElement.getBounds();
        Location currentFrameOffset = originalFC.getCurrentFrameOffset();
        elementBounds = elementBounds.offset(currentFrameOffset.getX(), currentFrameOffset.getY());
        Region viewportBounds = this.getViewportScrollBounds();
        if (!viewportBounds.contains(elementBounds)) {
            this.ensureFrameVisible();
            Point p = element.getLocation();
            Location elementLocation = new Location(p.getX(), p.getY());
            if (originalFC.size() > 0 && !element.equals(originalFC.peek())) {
                switchTo.frames(originalFC);
            }
            this.positionProvider.setPosition(elementLocation);
        }
    }

    private Region getViewportScrollBounds() {
        FrameChain originalFrameChain = new FrameChain(this.logger, this.driver.getFrameChain());
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        switchTo.defaultContent();
        ScrollPositionProvider spp = new ScrollPositionProvider(this.logger, this.jsExecutor);
        Location location = spp.getCurrentPosition();
        Region viewportBounds = new Region(location, this.getViewportSize());
        switchTo.frames(originalFrameChain);
        return viewportBounds;
    }

    private void checkRegion(String name, ICheckSettings checkSettings) {
        this.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                Point p = Eyes.this.targetElement.getLocation();
                Dimension d = Eyes.this.targetElement.getSize();
                return new Region(p.getX(), p.getY(), d.getWidth(), d.getHeight(), CoordinatesType.CONTEXT_RELATIVE);
            }
        }, name, false, checkSettings);
        this.logger.verbose("Done! trying to scroll back to original position..");
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(final Region region, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion([%s], %d, '%s'): Ignored", region, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.logger.verbose(String.format("CheckRegion([%s], %d, '%s')", region, matchTimeout, tag));
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return region;
            }
        }, tag, false, matchTimeout);
    }

    public void checkRegion(WebElement element) {
        this.checkRegion(element, null);
    }

    public void checkRegion(WebElement element, boolean stitchContent) {
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(element);
        } else {
            this.checkRegion(element);
        }
        this.stitchContent = false;
    }

    public void checkRegion(WebElement element, String tag) {
        this.checkRegion(element, -1, tag);
    }

    public void checkRegion(WebElement element, String tag, boolean stitchContent) {
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(element, tag);
        } else {
            this.checkRegion(element, tag);
        }
        this.stitchContent = false;
    }

    public void checkRegion(final WebElement element, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion(element, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.logger.log(String.format("CheckRegion(element, %d, '%s')", matchTimeout, tag));
        this.regionToCheck = null;
        Point locationAsPoint = element.getLocation();
        this.regionVisibilityStrategy.moveToRegion(this.positionProvider, new Location(locationAsPoint.getX(), locationAsPoint.getY()));
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                Point p = element.getLocation();
                Dimension d = element.getSize();
                return new Region(p.getX(), p.getY(), d.getWidth(), d.getHeight(), CoordinatesType.CONTEXT_RELATIVE);
            }
        }, tag, false, matchTimeout);
        this.logger.verbose("Done! trying to scroll back to original position..");
        this.regionVisibilityStrategy.returnToOriginalPosition(this.positionProvider);
        this.logger.verbose("Done!");
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag, boolean stitchContent) {
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(element, matchTimeout, tag);
        } else {
            this.checkRegion(element, matchTimeout, tag);
        }
        this.stitchContent = false;
    }

    public void checkRegion(By selector) {
        this.checkRegion(selector, null);
    }

    public void checkRegion(By selector, boolean stitchContent) {
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(selector);
        } else {
            this.checkRegion(selector);
        }
        this.stitchContent = false;
    }

    public void checkRegion(By selector, String tag) {
        this.checkRegion(selector, -1, tag);
    }

    public void checkRegion(By selector, String tag, boolean stitchContent) {
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(selector, tag);
        } else {
            this.checkRegion(selector, tag);
        }
        this.stitchContent = false;
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion(selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.checkRegion(this.driver.findElement(selector), matchTimeout, tag);
    }

    public void checkRegion(By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(selector, matchTimeout, tag);
        } else {
            this.checkRegion(selector, matchTimeout, tag);
        }
        this.stitchContent = false;
    }

    public void checkRegionInFrame(int frameIndex, By selector) {
        this.checkRegionInFrame(frameIndex, selector, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, null, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag) {
        this.checkRegionInFrame(frameIndex, selector, tag, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameIndex, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame(%d, selector, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameIndex);
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(selector, matchTimeout, tag);
        } else {
            this.checkRegion(selector, matchTimeout, tag);
        }
        this.stitchContent = false;
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(String frameNameOrId, By selector) {
        this.checkRegionInFrame(frameNameOrId, selector, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, null, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame('%s', selector, %d, '%s'): Ignored", frameNameOrId, matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameNameOrId);
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(selector, matchTimeout, tag);
        } else {
            this.checkRegion(selector, matchTimeout, tag);
        }
        this.stitchContent = false;
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(WebElement frameReference, By selector) {
        this.checkRegionInFrame(frameReference, selector, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, null, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag) {
        this.checkRegionInFrame(frameReference, selector, tag, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameReference, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame(frame, selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameReference);
        this.stitchContent = stitchContent;
        if (stitchContent) {
            this.checkElement(selector, matchTimeout, tag);
        } else {
            this.checkRegion(selector, matchTimeout, tag);
        }
        this.stitchContent = false;
        this.driver.switchTo().parentFrame();
    }

    protected ScaleProviderFactory updateScalingParams() {
        if (this.devicePixelRatio == 0.0 && this.scaleProviderHandler.get() instanceof NullScaleProvider) {
            ScaleProviderFactory factory;
            this.logger.verbose("Trying to extract device pixel ratio...");
            try {
                this.devicePixelRatio = EyesSeleniumUtils.getDevicePixelRatio(this.jsExecutor);
            }
            catch (Exception e) {
                this.logger.verbose("Failed to extract device pixel ratio! Using default.");
                this.devicePixelRatio = 1.0;
            }
            this.logger.verbose(String.format("Device pixel ratio: %f", this.devicePixelRatio));
            this.logger.verbose("Setting scale provider...");
            try {
                factory = this.getScaleProviderFactory();
            }
            catch (Exception e) {
                this.logger.verbose("Failed to set ContextBasedScaleProvider.");
                this.logger.verbose("Using FixedScaleProvider instead...");
                factory = new FixedScaleProviderFactory(1.0 / this.devicePixelRatio, this.scaleProviderHandler);
            }
            this.logger.verbose("Done!");
            return factory;
        }
        SimplePropertyHandler nullProvider = new SimplePropertyHandler();
        return new ScaleProviderIdentityFactory((ScaleProvider)this.scaleProviderHandler.get(), (PropertyHandler)nullProvider);
    }

    private ScaleProviderFactory getScaleProviderFactory() {
        return new ContextBasedScaleProviderFactory(this.logger, this.positionProvider.getEntireSize(), (RectangleSize)this.viewportSizeHandler.get(), this.devicePixelRatio, false, (PropertyHandler<ScaleProvider>)this.scaleProviderHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCurrentFrame(int matchTimeout, String tag) {
        try {
            this.logger.verbose(String.format("CheckCurrentFrame(%d, '%s')", matchTimeout, tag));
            this.checkFrameOrElement = true;
            this.logger.verbose("Getting screenshot as base64..");
            String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            this.logger.verbose("Done! Creating image object...");
            BufferedImage screenshotImage = ImageUtils.imageFromBase64((String)screenshot64);
            ScaleProvider scaleProvider = this.updateScalingParams().getScaleProvider(screenshotImage.getWidth());
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (ScaleProvider)scaleProvider);
            this.logger.verbose("Done! Building required object...");
            EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            this.logger.verbose("Done!");
            this.logger.verbose("replacing regionToCheck");
            this.setRegionToCheck(screenshot.getFrameWindow());
            super.checkWindowBase((RegionProvider)NullRegionProvider.INSTANCE, tag, false, matchTimeout);
        }
        finally {
            this.checkFrameOrElement = false;
            this.regionToCheck = null;
        }
    }

    public void checkFrame(String frameNameOrId) {
        this.checkFrame(frameNameOrId, -1, null);
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.checkFrame(frameNameOrId, -1, tag);
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%s, %d, '%s'): Ignored", frameNameOrId, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)frameNameOrId, (String)"frameNameOrId");
        this.logger.log(String.format("CheckFrame(%s, %d, '%s')", frameNameOrId, matchTimeout, tag));
        this.check(tag, Target.frame(frameNameOrId).timeout(matchTimeout).fully());
        this.logger.verbose("Done!");
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, -1, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%d, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        ArgumentGuard.greaterThanOrEqualToZero((long)frameIndex, (String)"frameIndex");
        this.logger.log(String.format("CheckFrame(%d, %d, '%s')", frameIndex, matchTimeout, tag));
        this.check(tag, Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkFrame(element, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)frameReference, (String)"frameReference");
        this.logger.log(String.format("CheckFrame(element, %d, '%s')", matchTimeout, tag));
        this.logger.verbose("Switching to frame based on element reference...");
        this.driver.switchTo().frame(frameReference);
        this.logger.verbose("Done!");
        this.checkCurrentFrame(matchTimeout, tag);
        this.logger.verbose("Switching back to parent frame...");
        this.driver.switchTo().parentFrame();
        this.logger.verbose("Done!");
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkFrame(framePath, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)framePath, (String)"framePath");
        ArgumentGuard.greaterThanZero((long)framePath.length, (String)"framePath.length");
        this.logger.log(String.format("checkFrame(framePath, %d, '%s')", matchTimeout, tag));
        FrameChain originalFrameChain = this.driver.getFrameChain();
        this.logger.verbose("Switching to parent frame according to frames path..");
        String[] parentFramePath = new String[framePath.length - 1];
        System.arraycopy(framePath, 0, parentFramePath, 0, parentFramePath.length);
        ((EyesTargetLocator)this.driver.switchTo()).frames(parentFramePath);
        this.logger.verbose("Done! Calling checkFrame..");
        this.checkFrame(framePath[framePath.length - 1], matchTimeout, tag);
        this.logger.verbose("Done! switching to default content..");
        this.driver.switchTo().defaultContent();
        this.logger.verbose("Done! Switching back into the original frame..");
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrameChain);
        this.logger.verbose("Done!");
    }

    public void checkFrame(String[] framesPath, String tag) {
        this.checkFrame(framesPath, -1, tag);
    }

    public void checkFrame(String[] framesPath) {
        this.checkFrame(framesPath, -1, null);
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkRegionInFrame(framePath, selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)framePath, (String)"framePath");
        ArgumentGuard.greaterThanZero((long)framePath.length, (String)"framePath.length");
        this.logger.log(String.format("checkFrame(framePath, %d, '%s')", matchTimeout, tag));
        FrameChain originalFrameChain = this.driver.getFrameChain();
        this.logger.verbose("Switching to parent frame according to frames path..");
        String[] parentFramePath = new String[framePath.length - 1];
        System.arraycopy(framePath, 0, parentFramePath, 0, parentFramePath.length);
        ((EyesTargetLocator)this.driver.switchTo()).frames(parentFramePath);
        this.logger.verbose("Done! Calling checkRegionInFrame..");
        this.checkRegionInFrame(framePath[framePath.length - 1], selector, matchTimeout, tag, stitchContent);
        this.logger.verbose("Done! switching back to default content..");
        this.driver.switchTo().defaultContent();
        this.logger.verbose("Done! Switching into the original frame..");
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrameChain);
        this.logger.verbose("Done!");
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(framePath, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(String[] framePath, By selector, String tag) {
        this.checkRegionInFrame(framePath, selector, -1, tag);
    }

    public void checkRegionInFrame(String[] framePath, By selector) {
        this.checkRegionInFrame(framePath, selector, -1, null);
    }

    public void checkElement(WebElement element) {
        this.checkElement(element, null);
    }

    public void checkElement(WebElement element, String tag) {
        this.checkElement(element, -1, tag);
    }

    private void checkElement(String name, ICheckSettings checkSettings) {
        this.checkElement(this.targetElement, name, checkSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkElement(WebElement element, String name, ICheckSettings checkSettings) {
        EyesRemoteWebElement eyesElement = element instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)element : new EyesRemoteWebElement(this.logger, this.driver, element);
        this.regionToCheck = null;
        PositionProvider originalPositionProvider = this.positionProvider;
        ScrollPositionProvider scrollPositionProvider = new ScrollPositionProvider(this.logger, this.jsExecutor);
        Location originalScrollPosition = scrollPositionProvider.getCurrentPosition();
        String originalOverflow = null;
        Point pl = eyesElement.getLocation();
        try {
            this.checkFrameOrElement = true;
            String displayStyle = eyesElement.getComputedStyle("display");
            if (!displayStyle.equals("inline")) {
                this.elementPositionProvider = new ElementPositionProvider(this.logger, this.driver, (WebElement)eyesElement);
            }
            originalOverflow = eyesElement.getOverflow();
            eyesElement.setOverflow("hidden");
            int elementWidth = eyesElement.getClientWidth();
            int elementHeight = eyesElement.getClientHeight();
            int borderLeftWidth = eyesElement.getComputedStyleInteger("border-left-width");
            int borderTopWidth = eyesElement.getComputedStyleInteger("border-top-width");
            Region elementRegion = new Region(pl.getX() + borderLeftWidth, pl.getY() + borderTopWidth, elementWidth, elementHeight, CoordinatesType.CONTEXT_RELATIVE);
            this.logger.verbose("Element region: " + elementRegion);
            this.logger.verbose("replacing regionToCheck");
            this.regionToCheck = elementRegion;
            this.checkWindowBase((RegionProvider)NullRegionProvider.INSTANCE, name, false, checkSettings);
            if (originalOverflow != null) {
                eyesElement.setOverflow(originalOverflow);
            }
            this.checkFrameOrElement = false;
        }
        catch (Throwable throwable) {
            if (originalOverflow != null) {
                eyesElement.setOverflow(originalOverflow);
            }
            this.checkFrameOrElement = false;
            scrollPositionProvider.setPosition(originalScrollPosition);
            this.positionProvider = originalPositionProvider;
            this.regionToCheck = null;
            this.elementPositionProvider = null;
            throw throwable;
        }
        scrollPositionProvider.setPosition(originalScrollPosition);
        this.positionProvider = originalPositionProvider;
        this.regionToCheck = null;
        this.elementPositionProvider = null;
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.checkElement(element, tag, Target.region(element).timeout(matchTimeout));
    }

    public void checkElement(By selector) {
        this.checkElement(selector, null);
    }

    public void checkElement(By selector, String tag) {
        this.checkElement(selector, -1, tag);
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckElement(selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.checkElement(this.driver.findElement(selector), matchTimeout, tag);
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        elementRegion = this.lastScreenshot.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        this.addMouseTriggerBase(action, elementRegion, elementRegion.getMiddleOffset());
    }

    public void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring '%s' (different frame)", text));
            return;
        }
        this.addTextTriggerBase(control, text);
    }

    public void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        this.addTextTrigger(elementRegion, text);
    }

    public RectangleSize getViewportSize() {
        RectangleSize viewportSize = (RectangleSize)this.viewportSizeHandler.get();
        if (viewportSize == null) {
            viewportSize = this.driver.getDefaultContentViewportSize();
        }
        return viewportSize;
    }

    public static RectangleSize getViewportSize(WebDriver driver) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        return EyesSeleniumUtils.getViewportSizeOrDisplaySize(new Logger(), driver);
    }

    protected void setViewportSize(RectangleSize size) {
        if (this.viewportSizeHandler instanceof ReadOnlyPropertyHandler) {
            this.logger.verbose("Ignored (viewport size given explicitly)");
            return;
        }
        FrameChain originalFrame = this.driver.getFrameChain();
        this.driver.switchTo().defaultContent();
        try {
            EyesSeleniumUtils.setViewportSize(this.logger, this.driver, size);
        }
        catch (EyesException e) {
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
            throw new TestFailedException("Failed to set the viewport size", (Throwable)e);
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        this.viewportSizeHandler.set((Object)new RectangleSize(size.getWidth(), size.getHeight()));
    }

    public static void setViewportSize(WebDriver driver, RectangleSize size) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        EyesSeleniumUtils.setViewportSize(new Logger(), driver, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EyesScreenshot getScreenshot() {
        this.logger.verbose("getScreenshot()");
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        String originalOverflow = null;
        if (this.hideScrollbars) {
            try {
                originalOverflow = EyesSeleniumUtils.hideScrollbars(this.driver, 200);
            }
            catch (EyesDriverOperationException e) {
                this.logger.log("WARNING: Failed to hide scrollbars! Error: " + e.getMessage());
            }
        }
        try {
            EyesWebDriverScreenshot result;
            EyesWebDriverScreenshotFactory screenshotFactory = new EyesWebDriverScreenshotFactory(this.logger, this.driver);
            FrameChain originalFrameChain = new FrameChain(this.logger, this.driver.getFrameChain());
            FullPageCaptureAlgorithm algo = new FullPageCaptureAlgorithm(this.logger, this.userAgent);
            EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
            if (this.checkFrameOrElement) {
                this.logger.verbose("Check frame/element requested");
                switchTo.framesDoScroll(originalFrameChain);
                BufferedImage entireFrameOrElement = algo.getStitchedRegion(this.imageProvider, this.regionToCheck, this.positionProvider, this.getElementPositionProvider(), scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), this.getWaitBeforeScreenshots(), this.debugScreenshotsProvider, screenshotFactory, this.getStitchOverlap(), this.regionPositionCompensation);
                this.logger.verbose("Building screenshot object...");
                result = new EyesWebDriverScreenshot(this.logger, this.driver, entireFrameOrElement, new RectangleSize(entireFrameOrElement.getWidth(), entireFrameOrElement.getHeight()));
            } else if (this.forceFullPageScreenshot || this.stitchContent) {
                this.logger.verbose("Full page screenshot requested.");
                Location originalFramePosition = originalFrameChain.size() > 0 ? originalFrameChain.getDefaultContentScrollPosition() : new Location(0, 0);
                switchTo.defaultContent();
                BufferedImage fullPageImage = algo.getStitchedRegion(this.imageProvider, Region.EMPTY, new ScrollPositionProvider(this.logger, this.jsExecutor), this.positionProvider, scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), this.getWaitBeforeScreenshots(), this.debugScreenshotsProvider, screenshotFactory, this.getStitchOverlap(), this.regionPositionCompensation);
                switchTo.frames(originalFrameChain);
                result = new EyesWebDriverScreenshot(this.logger, this.driver, fullPageImage, null, originalFramePosition);
            } else {
                CutProvider cutProvider;
                this.ensureElementVisible(this.targetElement);
                this.logger.verbose("Screenshot requested...");
                BufferedImage screenshotImage = this.imageProvider.getImage();
                this.debugScreenshotsProvider.save(screenshotImage, "original");
                ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
                if (scaleProvider.getScaleRatio() != 1.0) {
                    this.logger.verbose("scaling...");
                    screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (ScaleProvider)scaleProvider);
                    this.debugScreenshotsProvider.save(screenshotImage, "scaled");
                }
                if (!((cutProvider = (CutProvider)this.cutProviderHandler.get()) instanceof NullCutProvider)) {
                    this.logger.verbose("cutting...");
                    screenshotImage = cutProvider.cut(screenshotImage);
                    this.debugScreenshotsProvider.save(screenshotImage, "cut");
                }
                this.logger.verbose("Creating screenshot object...");
                result = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            }
            this.logger.verbose("Done!");
            EyesWebDriverScreenshot eyesWebDriverScreenshot = result;
            return eyesWebDriverScreenshot;
        }
        finally {
            if (this.hideScrollbars) {
                try {
                    EyesSeleniumUtils.setOverflow(this.driver, originalOverflow);
                }
                catch (EyesDriverOperationException e) {
                    this.logger.log("WARNING: Failed to revert overflow! Error: " + e.getMessage());
                }
            }
        }
    }

    protected String getTitle() {
        if (!this.dontGetTitle) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                this.logger.verbose("failed (" + ex.getMessage() + ")");
                this.dontGetTitle = true;
            }
        }
        return "";
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = super.getAppEnvironment();
        RemoteWebDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() == null) {
            this.logger.log("No OS set, checking for mobile OS...");
            if (EyesSeleniumUtils.isMobileDevice((WebDriver)underlyingDriver)) {
                String platformName = null;
                this.logger.log("Mobile device detected! Checking device type..");
                if (EyesSeleniumUtils.isAndroid((WebDriver)underlyingDriver)) {
                    this.logger.log("Android detected.");
                    platformName = "Android";
                } else if (EyesSeleniumUtils.isIOS((WebDriver)underlyingDriver)) {
                    this.logger.log("iOS detected.");
                    platformName = "iOS";
                } else {
                    this.logger.log("Unknown device type.");
                }
                if (platformName != null) {
                    String majorVersion;
                    String os = platformName;
                    String platformVersion = EyesSeleniumUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
                    if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                        os = os + " " + majorVersion;
                    }
                    this.logger.verbose("Setting OS: " + os);
                    appEnv.setOs(os);
                }
            } else {
                this.logger.log("No mobile OS detected.");
            }
        }
        this.logger.log("Done!");
        return appEnv;
    }

    public PositionProvider getElementPositionProvider() {
        return this.elementPositionProvider == null ? this.positionProvider : this.elementPositionProvider;
    }

    public static interface WebDriverAction {
        public void drive(WebDriver var1);
    }
}

