/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.positioning.NullRegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class FullPageCaptureAlgorithm {
    private static final int MIN_SCREENSHOT_PART_HEIGHT = 10;
    private final Logger logger;
    private final RegionPositionCompensation regionPositionCompensation;
    private final int waitBeforeScreenshots;
    private final DebugScreenshotsProvider debugScreenshotsProvider;
    private final EyesScreenshotFactory screenshotFactory;
    private final PositionProvider originProvider;
    private final ScaleProviderFactory scaleProviderFactory;
    private final CutProvider cutProvider;
    private final int stitchingOverlap;
    private final ImageProvider imageProvider;

    public FullPageCaptureAlgorithm(Logger logger, RegionPositionCompensation regionPositionCompensation, int waitBeforeScreenshots, DebugScreenshotsProvider debugScreenshotsProvider, EyesScreenshotFactory screenshotFactory, PositionProvider originProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, int stitchingOverlap, ImageProvider imageProvider) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.waitBeforeScreenshots = waitBeforeScreenshots;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
        this.screenshotFactory = screenshotFactory;
        this.originProvider = originProvider;
        this.scaleProviderFactory = scaleProviderFactory;
        this.cutProvider = cutProvider;
        this.stitchingOverlap = stitchingOverlap;
        this.imageProvider = imageProvider;
        this.regionPositionCompensation = regionPositionCompensation != null ? regionPositionCompensation : new NullRegionPositionCompensation();
    }

    private void saveDebugScreenshotPart(BufferedImage image, Region region, String name) {
        String suffix = String.format("part-%s-%d_%d_%dx%d", name, region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
        this.debugScreenshotsProvider.save(image, suffix);
    }

    public BufferedImage getStitchedRegion(Region region, Region fullArea, PositionProvider positionProvider) {
        Region regionInScreenshot;
        this.logger.verbose("getStitchedRegion()");
        ArgumentGuard.notNull((Object)region, (String)"region");
        ArgumentGuard.notNull((Object)positionProvider, (String)"positionProvider");
        this.logger.verbose(String.format("positionProvider: %s ; Region: %s", positionProvider.getClass(), region));
        PositionMemento originalStitchedState = positionProvider.getState();
        PositionMemento originalPosition = this.originProvider.getState();
        this.originProvider.setPosition(Location.ZERO);
        this.logger.verbose("Getting top/left image...");
        BufferedImage image = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(image, "original");
        ScaleProvider scaleProvider = this.scaleProviderFactory.getScaleProvider(image.getWidth());
        double pixelRatio = 1.0 / scaleProvider.getScaleRatio();
        CutProvider scaledCutProvider = this.cutProvider.scale(pixelRatio);
        if (!(scaledCutProvider instanceof NullCutProvider)) {
            image = scaledCutProvider.cut(image);
            this.debugScreenshotsProvider.save(image, "original-cut");
        }
        if (!(regionInScreenshot = this.getRegionInScreenshot(region, image, pixelRatio)).isSizeEmpty()) {
            image = ImageUtils.getImagePart((BufferedImage)image, (Region)regionInScreenshot);
            this.saveDebugScreenshotPart(image, region, "cropped");
        }
        if (pixelRatio != 1.0) {
            image = ImageUtils.scaleImage((BufferedImage)image, (double)(1.0 / pixelRatio));
            this.debugScreenshotsProvider.save(image, "scaled");
        }
        if (fullArea == null || fullArea.isEmpty()) {
            RectangleSize entireSize;
            try {
                entireSize = positionProvider.getEntireSize();
                this.logger.verbose("Entire size of region context: " + entireSize);
            }
            catch (EyesDriverOperationException e) {
                this.logger.log("WARNING: Failed to extract entire size of region context" + e.getMessage());
                this.logger.log("Using image size instead: " + image.getWidth() + "x" + image.getHeight());
                entireSize = new RectangleSize(image.getWidth(), image.getHeight());
            }
            if (image.getWidth() >= entireSize.getWidth() && image.getHeight() >= entireSize.getHeight()) {
                this.originProvider.restoreState(originalPosition);
                return image;
            }
            fullArea = new Region(Location.ZERO, entireSize);
        }
        RectangleSize partImageSize = new RectangleSize(image.getWidth(), Math.max(image.getHeight() - this.stitchingOverlap, 10));
        this.logger.verbose(String.format("entire page region: %s, image part size: %s", fullArea, partImageSize));
        Iterable imageParts = fullArea.getSubRegions(partImageSize);
        this.logger.verbose("Creating stitchedImage container.");
        BufferedImage stitchedImage = new BufferedImage(fullArea.getWidth(), fullArea.getHeight(), image.getType());
        this.logger.verbose("Done! Adding initial screenshot..");
        Raster initialPart = image.getData();
        this.logger.verbose(String.format("Initial part:(0,0)[%d x %d]", initialPart.getWidth(), initialPart.getHeight()));
        stitchedImage.getRaster().setRect(0, 0, initialPart);
        this.logger.verbose("Done!");
        Location lastSuccessfulLocation = new Location(0, 0);
        RectangleSize lastSuccessfulPartSize = new RectangleSize(initialPart.getWidth(), initialPart.getHeight());
        this.logger.verbose("Getting the rest of the image parts...");
        BufferedImage partImage = null;
        for (Region partRegion : imageParts) {
            this.logger.verbose(String.format("Taking screenshot for %s", partRegion));
            positionProvider.setPosition(partRegion.getLocation());
            GeneralUtils.sleep((long)this.waitBeforeScreenshots);
            Location originPosition = positionProvider.getCurrentPosition();
            Location targetPosition = originPosition.offset(-fullArea.getLeft(), -fullArea.getTop());
            this.logger.verbose(String.format("Origin Position is set to %s", originPosition));
            this.logger.verbose("Getting image...");
            partImage = this.imageProvider.getImage();
            this.debugScreenshotsProvider.save(partImage, "original-scrolled-" + positionProvider.getCurrentPosition().toStringForFilename());
            if (!(scaledCutProvider instanceof NullCutProvider)) {
                this.logger.verbose("cutting...");
                partImage = scaledCutProvider.cut(partImage);
                this.debugScreenshotsProvider.save(partImage, "original-scrolled-cut-" + positionProvider.getCurrentPosition().toStringForFilename());
            }
            if (!regionInScreenshot.isSizeEmpty()) {
                this.logger.verbose("cropping...");
                partImage = ImageUtils.getImagePart((BufferedImage)partImage, (Region)regionInScreenshot);
                this.saveDebugScreenshotPart(partImage, partRegion, "original-scrolled-" + positionProvider.getCurrentPosition().toStringForFilename());
            }
            if (pixelRatio != 1.0) {
                this.logger.verbose("scaling...");
                partImage = ImageUtils.scaleImage((BufferedImage)partImage, (double)(1.0 / pixelRatio));
                this.saveDebugScreenshotPart(partImage, partRegion, "original-scrolled-" + positionProvider.getCurrentPosition().toStringForFilename() + "-scaled-");
            }
            this.logger.verbose("Stitching part into the image container...");
            stitchedImage.getRaster().setRect(targetPosition.getX(), targetPosition.getY(), partImage.getData());
            this.logger.verbose("Done!");
            lastSuccessfulLocation = originPosition;
        }
        if (partImage != null) {
            lastSuccessfulPartSize = new RectangleSize(partImage.getWidth(), partImage.getHeight());
        }
        this.logger.verbose("Stitching done!");
        positionProvider.restoreState(originalStitchedState);
        this.originProvider.restoreState(originalPosition);
        int actualImageWidth = lastSuccessfulLocation.getX() + lastSuccessfulPartSize.getWidth();
        int actualImageHeight = lastSuccessfulLocation.getY() + lastSuccessfulPartSize.getHeight();
        this.logger.verbose("Extracted entire size: " + fullArea.getSize());
        this.logger.verbose("Actual stitched size: " + actualImageWidth + "x" + actualImageHeight);
        if (actualImageWidth < stitchedImage.getWidth() || actualImageHeight < stitchedImage.getHeight()) {
            this.logger.verbose("Trimming unnecessary margins..");
            stitchedImage = ImageUtils.getImagePart((BufferedImage)stitchedImage, (Region)new Region(0, 0, Math.min(actualImageWidth, stitchedImage.getWidth()), Math.min(actualImageHeight, stitchedImage.getHeight())));
            this.logger.verbose("Done!");
        }
        this.debugScreenshotsProvider.save(stitchedImage, "stitched");
        return stitchedImage;
    }

    private Region getRegionInScreenshot(Region region, BufferedImage image, double pixelRatio) {
        this.logger.verbose("Creating screenshot object...");
        EyesScreenshot screenshot = this.screenshotFactory.makeScreenshot(image);
        this.logger.verbose("Getting region in screenshot...");
        Region regionInScreenshot = screenshot.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        this.logger.verbose("Region in screenshot: " + regionInScreenshot);
        regionInScreenshot = regionInScreenshot.scale(pixelRatio);
        this.logger.verbose("Scaled region: " + regionInScreenshot);
        regionInScreenshot = this.regionPositionCompensation.compensateRegionPosition(regionInScreenshot, pixelRatio);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.verbose("Region after intersect: " + regionInScreenshot);
        return regionInScreenshot;
    }
}

