/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.frames;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public final class Frame {
    private final WebElement reference;
    private final Location location;
    private final RectangleSize size;
    private final RectangleSize innerSize;
    private final Location originalLocation;
    private final String originalOverflow;
    private final JavascriptExecutor jsExecutor;
    private final String rootElementForHidingScrollbars;

    public Frame(Logger logger, WebElement reference, Location location, RectangleSize size, RectangleSize innerSize, Location originalLocation, String originalOverflow, JavascriptExecutor jsExecutor) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)reference, (String)"reference");
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)size, (String)"size");
        ArgumentGuard.notNull((Object)innerSize, (String)"innerSize");
        ArgumentGuard.notNull((Object)originalLocation, (String)"originalLocation");
        ArgumentGuard.notNull((Object)originalOverflow, (String)"originalOverflow");
        ArgumentGuard.notNull((Object)jsExecutor, (String)"jsExecutor");
        logger.verbose(String.format("Frame(logger, reference, %s, %s, %s, %s)", location, size, innerSize, originalLocation));
        this.reference = reference;
        this.location = location;
        this.size = size;
        this.innerSize = innerSize;
        this.originalLocation = originalLocation;
        this.originalOverflow = originalOverflow;
        this.jsExecutor = jsExecutor;
        this.rootElementForHidingScrollbars = EyesSeleniumUtils.selectRootElement(jsExecutor);
    }

    public WebElement getReference() {
        return this.reference;
    }

    public Location getLocation() {
        return this.location;
    }

    public RectangleSize getSize() {
        return this.size;
    }

    public RectangleSize getInnerSize() {
        return this.innerSize;
    }

    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    public String getOriginalOverflow() {
        return this.originalOverflow;
    }

    public void returnToOriginalOverflow() {
        EyesSeleniumUtils.setOverflow(this.jsExecutor, this.originalOverflow, this.rootElementForHidingScrollbars);
    }

    public void hideScrollbars() {
        EyesSeleniumUtils.hideScrollbars(this.jsExecutor, 200, this.rootElementForHidingScrollbars);
    }
}

