/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.wrappers;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ArgumentGuard;
import java.util.List;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesTargetLocator
implements WebDriver.TargetLocator {
    private final Logger logger;
    private final EyesWebDriver driver;
    private final SeleniumJavaScriptExecutor jsExecutor;
    private final ScrollPositionProvider scrollPosition;
    private final WebDriver.TargetLocator targetLocator;
    private PositionMemento defaultContentPositionMemento;

    public void willSwitchToFrame(WebElement targetFrame) {
        ArgumentGuard.notNull((Object)targetFrame, (String)"targetFrame");
        EyesRemoteWebElement eyesFrame = targetFrame instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)targetFrame : new EyesRemoteWebElement(this.logger, this.driver, targetFrame);
        Point pl = targetFrame.getLocation();
        Dimension ds = targetFrame.getSize();
        int clientWidth = eyesFrame.getClientWidth();
        int clientHeight = eyesFrame.getClientHeight();
        int borderLeftWidth = eyesFrame.getComputedStyleInteger("border-left-width");
        int borderTopWidth = eyesFrame.getComputedStyleInteger("border-top-width");
        Location contentLocation = new Location(pl.getX() + borderLeftWidth, pl.getY() + borderTopWidth);
        Location originalLocation = this.scrollPosition.getCurrentPosition();
        String frameOverflow = eyesFrame.getOverflow();
        Frame frame = new Frame(this.logger, targetFrame, contentLocation, new RectangleSize(ds.getWidth(), ds.getHeight()), new RectangleSize(clientWidth, clientHeight), originalLocation, frameOverflow, this.driver);
        this.driver.getFrameChain().push(frame);
    }

    public EyesTargetLocator(Logger logger, EyesWebDriver driver, WebDriver.TargetLocator targetLocator) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)targetLocator, (String)"targetLocator");
        this.logger = logger;
        this.driver = driver;
        this.targetLocator = targetLocator;
        this.jsExecutor = new SeleniumJavaScriptExecutor(driver);
        this.scrollPosition = new ScrollPositionProvider(logger, this.jsExecutor);
    }

    public WebDriver frame(int index) {
        this.logger.verbose(String.format("EyesTargetLocator.frame(%d)", index));
        this.logger.verbose("Getting frames list...");
        List<WebElement> frames = this.driver.findElementsByCssSelector("frame, iframe");
        if (index > frames.size()) {
            throw new NoSuchFrameException(String.format("Frame index [%d] is invalid!", index));
        }
        this.logger.verbose("Done! getting the specific frame...");
        WebElement targetFrame = frames.get(index);
        this.logger.verbose("Done! Making preparations...");
        this.willSwitchToFrame(targetFrame);
        this.logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(index);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frame(String nameOrId) {
        this.logger.verbose(String.format("EyesTargetLocator.frame('%s')", nameOrId));
        this.logger.verbose("Getting frames by name...");
        List<WebElement> frames = this.driver.findElementsByName(nameOrId);
        if (frames.size() == 0) {
            this.logger.verbose("No frames Found! Trying by id...");
            frames = this.driver.findElementsById(nameOrId);
            if (frames.size() == 0) {
                throw new NoSuchFrameException(String.format("No frame with name or id '%s' exists!", nameOrId));
            }
        }
        this.logger.verbose("Done! Making preparations...");
        this.willSwitchToFrame(frames.get(0));
        this.logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(nameOrId);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frame(WebElement frameElement) {
        this.logger.verbose("EyesTargetLocator.frame(element)");
        this.logger.verbose("Making preparations...");
        this.willSwitchToFrame(frameElement);
        this.logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(frameElement);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver parentFrame() {
        this.logger.verbose("EyesTargetLocator.parentFrame()");
        if (this.driver.getFrameChain().size() != 0) {
            this.logger.verbose("Making preparations..");
            this.driver.getFrameChain().pop();
            this.logger.verbose("Done! Switching to parent frame..");
            this.targetLocator.parentFrame();
        }
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver framesDoScroll(FrameChain frameChain) {
        this.logger.verbose("EyesTargetLocator.framesDoScroll(frameChain)");
        this.driver.switchTo().defaultContent();
        this.defaultContentPositionMemento = this.scrollPosition.getState();
        for (Frame frame : frameChain) {
            this.logger.verbose("Scrolling by parent scroll position...");
            Location frameLocation = frame.getLocation();
            this.scrollPosition.setPosition(frameLocation);
            this.logger.verbose("Done! Switching to frame...");
            this.driver.switchTo().frame(frame.getReference());
            this.logger.verbose("Done!");
        }
        this.logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver frames(FrameChain frameChain) {
        this.logger.verbose("EyesTargetLocator.frames(frameChain)");
        this.driver.switchTo().defaultContent();
        for (Frame frame : frameChain) {
            this.driver.switchTo().frame(frame.getReference());
        }
        this.logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver frames(String[] framesPath) {
        this.logger.verbose("EyesTargetLocator.frames(framesPath)");
        for (String frameNameOrId : framesPath) {
            this.logger.verbose("Switching to frame...");
            this.driver.switchTo().frame(frameNameOrId);
            this.logger.verbose("Done!");
        }
        this.logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver window(String nameOrHandle) {
        this.logger.verbose("EyesTargetLocator.window()");
        this.driver.getFrameChain().clear();
        this.logger.verbose("Done! Switching to window...");
        this.targetLocator.window(nameOrHandle);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver defaultContent() {
        this.logger.verbose("EyesTargetLocator.defaultContent()");
        if (this.driver.getFrameChain().size() != 0) {
            this.logger.verbose("Making preparations...");
            this.driver.getFrameChain().clear();
            this.logger.verbose("Done! Switching to default content...");
        }
        this.targetLocator.defaultContent();
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebElement activeElement() {
        this.logger.verbose("EyesTargetLocator.activeElement()");
        this.logger.verbose("Switching to element...");
        WebElement element = this.targetLocator.activeElement();
        if (!(element instanceof RemoteWebElement)) {
            throw new EyesException("Not a remote web element!");
        }
        EyesRemoteWebElement result = new EyesRemoteWebElement(this.logger, this.driver, (WebElement)((RemoteWebElement)element));
        this.logger.verbose("Done!");
        return result;
    }

    public Alert alert() {
        this.logger.verbose("EyesTargetLocator.alert()");
        this.logger.verbose("Switching to alert...");
        Alert result = this.targetLocator.alert();
        this.logger.verbose("Done!");
        return result;
    }

    public void resetScroll() {
        if (this.defaultContentPositionMemento != null) {
            this.scrollPosition.restoreState(this.defaultContentPositionMemento);
        }
    }
}

