/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;

public class EyesSeleniumUtils {
    private static final String NATIVE_APP = "NATIVE_APP";
    private static final String JS_GET_VIEWPORT_SIZE = "var height = undefined;var width = undefined;  if (window.innerHeight) {height = window.innerHeight;}  else if (document.documentElement && document.documentElement.clientHeight) {height = document.documentElement.clientHeight;}  else { var b = document.getElementsByTagName('body')[0]; if (b.clientHeight) {height = b.clientHeight;}}; if (window.innerWidth) {width = window.innerWidth;} else if (document.documentElement && document.documentElement.clientWidth) {width = document.documentElement.clientWidth;} else { var b = document.getElementsByTagName('body')[0]; if (b.clientWidth) {width = b.clientWidth;}};return [width, height];";
    private static final String JS_GET_CURRENT_SCROLL_POSITION = "var doc = document.documentElement; var x = window.scrollX || ((window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0)); var y = window.scrollY || ((window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0));return [x, y];";
    private static final String JS_GET_CONTENT_ENTIRE_SIZE = "var scrollWidth = document.documentElement.scrollWidth; var bodyScrollWidth = document.body.scrollWidth; var totalWidth = Math.max(scrollWidth, bodyScrollWidth); var clientHeight = document.documentElement.clientHeight; var bodyClientHeight = document.body.clientHeight; var scrollHeight = document.documentElement.scrollHeight; var bodyScrollHeight = document.body.scrollHeight; var maxDocElementHeight = Math.max(clientHeight, scrollHeight); var maxBodyHeight = Math.max(bodyClientHeight, bodyScrollHeight); var totalHeight = Math.max(maxDocElementHeight, maxBodyHeight); return [totalWidth, totalHeight];";
    private static final String[] JS_TRANSFORM_KEYS = new String[]{"transform", "-webkit-transform"};

    public static Location getPageLocation(Coordinates coordinates) {
        if (coordinates == null) {
            return null;
        }
        Point p = coordinates.onPage();
        return new Location(p.getX(), p.getY());
    }

    public static Location getViewportLocation(Coordinates coordinates) {
        if (coordinates == null) {
            return null;
        }
        Point p = coordinates.inViewPort();
        return new Location(p.getX(), p.getY());
    }

    public static WebDriver getUnderlyingDriver(WebDriver driver) {
        if (driver instanceof EyesWebDriver) {
            driver = ((EyesWebDriver)driver).getRemoteWebDriver();
        }
        return driver;
    }

    public static boolean isMobileDevice(WebDriver driver) {
        driver = EyesSeleniumUtils.getUnderlyingDriver(driver);
        return driver instanceof AppiumDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLandscapeOrientation(Logger logger, WebDriver driver) {
        if (EyesSeleniumUtils.isMobileDevice(driver)) {
            AppiumDriver appiumDriver = (AppiumDriver)EyesSeleniumUtils.getUnderlyingDriver(driver);
            String originalContext = null;
            try {
                originalContext = appiumDriver.getContext();
                if (appiumDriver.getContextHandles().size() > 1 && !originalContext.equalsIgnoreCase(NATIVE_APP)) {
                    appiumDriver.context(NATIVE_APP);
                } else {
                    originalContext = null;
                }
            }
            catch (WebDriverException e) {
                originalContext = null;
            }
            try {
                ScreenOrientation orientation = appiumDriver.getOrientation();
                boolean bl = orientation == ScreenOrientation.LANDSCAPE;
                return bl;
            }
            catch (Exception e) {
                logger.log("WARNING: Couldn't get device orientation. Assuming Portrait.");
                boolean bl = false;
                return bl;
            }
            finally {
                if (originalContext != null) {
                    appiumDriver.context(originalContext);
                }
            }
        }
        return false;
    }

    public static String selectRootElement(JavascriptExecutor executor) {
        return "documentElement";
    }

    public static String setOverflow(JavascriptExecutor executor, String value, String rootElement) {
        if (rootElement == null) {
            rootElement = "body";
        }
        String script = String.format("var origOverflow = document.%s.style.overflow; document.%s.style.overflow = '%s'; return origOverflow;", rootElement, rootElement, value == null ? "" : value);
        try {
            return (String)executor.executeScript(script, new Object[0]);
        }
        catch (WebDriverException e) {
            throw new EyesDriverOperationException("Failed to set overflow", e);
        }
    }

    public static String hideScrollbars(JavascriptExecutor executor, int stabilizationTimeout, String rootElement) {
        String originalOverflow = EyesSeleniumUtils.setOverflow(executor, "hidden", rootElement);
        if (stabilizationTimeout > 0) {
            try {
                Thread.sleep(stabilizationTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return originalOverflow;
    }

    public static Location getCurrentScrollPosition(IEyesJsExecutor executor) {
        List positionAsList = (List)executor.executeScript(JS_GET_CURRENT_SCROLL_POSITION, new Object[0]);
        return new Location((int)Math.ceil(((Number)positionAsList.get(0)).doubleValue()), (int)Math.ceil(((Number)positionAsList.get(1)).doubleValue()));
    }

    public static void setCurrentScrollPosition(IEyesJsExecutor executor, Location location) {
        executor.executeScript(String.format("window.scrollTo(%d,%d)", location.getX(), location.getY()), new Object[0]);
    }

    public static RectangleSize getCurrentFrameContentEntireSize(IEyesJsExecutor executor) {
        RectangleSize result;
        try {
            Object retVal = executor.executeScript(JS_GET_CONTENT_ENTIRE_SIZE, new Object[0]);
            List esAsList = (List)retVal;
            result = new RectangleSize(((Long)esAsList.get(0)).intValue(), ((Long)esAsList.get(1)).intValue());
        }
        catch (WebDriverException e) {
            throw new EyesDriverOperationException("Failed to extract entire size!");
        }
        return result;
    }

    public static RectangleSize getViewportSize(JavascriptExecutor executor) {
        List vsAsList = (List)executor.executeScript(JS_GET_VIEWPORT_SIZE, new Object[0]);
        return new RectangleSize(((Long)vsAsList.get(0)).intValue(), ((Long)vsAsList.get(1)).intValue());
    }

    public static RectangleSize getViewportSizeOrDisplaySize(Logger logger, WebDriver driver) {
        logger.verbose("getViewportSizeOrDisplaySize()");
        try {
            return EyesSeleniumUtils.getViewportSize((JavascriptExecutor)driver);
        }
        catch (Exception ex) {
            logger.verbose(String.format("Failed to extract viewport size using Javascript: %s", ex.getMessage()));
            logger.verbose("Using window size as viewport size.");
            Dimension windowSize = driver.manage().window().getSize();
            int width = windowSize.getWidth();
            int height = windowSize.getHeight();
            try {
                if (EyesSeleniumUtils.isLandscapeOrientation(logger, driver) && height > width) {
                    int height2 = width;
                    width = height;
                    height = height2;
                }
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
            logger.verbose(String.format("Done! Size %d x %d", width, height));
            return new RectangleSize(width, height);
        }
    }

    public static boolean setBrowserSize(Logger logger, WebDriver driver, RectangleSize requiredSize) {
        RectangleSize currentSize;
        int SLEEP = 1000;
        int RETRIES = 3;
        int retriesLeft = 3;
        Dimension dRequiredSize = new Dimension(requiredSize.getWidth(), requiredSize.getHeight());
        do {
            logger.verbose("Trying to set browser size to: " + requiredSize);
            driver.manage().window().setSize(dRequiredSize);
            GeneralUtils.sleep((long)1000L);
            Dimension dCurrentSize = driver.manage().window().getSize();
            currentSize = new RectangleSize(dCurrentSize.getWidth(), dCurrentSize.getHeight());
            logger.verbose("Current browser size: " + currentSize);
        } while (--retriesLeft > 0 && !currentSize.equals((Object)requiredSize));
        return currentSize == requiredSize;
    }

    public static boolean setBrowserSizeByViewportSize(Logger logger, WebDriver driver, RectangleSize actualViewportSize, RectangleSize requiredViewportSize) {
        Dimension browserSize = driver.manage().window().getSize();
        logger.verbose("Current browser size: " + browserSize);
        RectangleSize requiredBrowserSize = new RectangleSize(browserSize.width + (requiredViewportSize.getWidth() - actualViewportSize.getWidth()), browserSize.height + (requiredViewportSize.getHeight() - actualViewportSize.getHeight()));
        return EyesSeleniumUtils.setBrowserSize(logger, driver, requiredBrowserSize);
    }

    public static void setViewportSize(Logger logger, WebDriver driver, RectangleSize size) {
        ArgumentGuard.notNull((Object)size, (String)"size");
        logger.verbose("setViewportSize(" + size + ")");
        RectangleSize requiredSize = new RectangleSize(size.getWidth(), size.getHeight());
        RectangleSize actualViewportSize = EyesSeleniumUtils.getViewportSize((JavascriptExecutor)driver);
        logger.verbose("Initial viewport size:" + actualViewportSize);
        if (actualViewportSize.equals((Object)requiredSize)) {
            logger.verbose("Required size already set.");
            return;
        }
        try {
            driver.manage().window().setPosition(new Point(0, 0));
        }
        catch (WebDriverException e) {
            logger.verbose("Warning: Failed to move the browser window to (0,0)");
        }
        EyesSeleniumUtils.setBrowserSizeByViewportSize(logger, driver, actualViewportSize, requiredSize);
        actualViewportSize = EyesSeleniumUtils.getViewportSize((JavascriptExecutor)driver);
        if (actualViewportSize.equals((Object)requiredSize)) {
            return;
        }
        logger.verbose("Trying workaround for maximization...");
        EyesSeleniumUtils.setBrowserSizeByViewportSize(logger, driver, actualViewportSize, requiredSize);
        actualViewportSize = EyesSeleniumUtils.getViewportSize((JavascriptExecutor)driver);
        logger.verbose("Current viewport size: " + actualViewportSize);
        if (actualViewportSize.equals((Object)requiredSize)) {
            return;
        }
        int MAX_DIFF = 3;
        int widthDiff = actualViewportSize.getWidth() - requiredSize.getWidth();
        int widthStep = widthDiff > 0 ? -1 : 1;
        int heightDiff = actualViewportSize.getHeight() - requiredSize.getHeight();
        int heightStep = heightDiff > 0 ? -1 : 1;
        Dimension dBrowserSize = driver.manage().window().getSize();
        RectangleSize browserSize = new RectangleSize(dBrowserSize.getWidth(), dBrowserSize.getHeight());
        int currWidthChange = 0;
        int currHeightChange = 0;
        if (Math.abs(widthDiff) <= 3 && Math.abs(heightDiff) <= 3) {
            logger.verbose("Trying workaround for zoom...");
            int retriesLeft = Math.abs((widthDiff == 0 ? 1 : widthDiff) * (heightDiff == 0 ? 1 : heightDiff)) * 2;
            RectangleSize lastRequiredBrowserSize = null;
            do {
                RectangleSize requiredBrowserSize;
                logger.verbose("Retries left: " + retriesLeft);
                if (Math.abs(currWidthChange) <= Math.abs(widthDiff) && actualViewportSize.getWidth() != requiredSize.getWidth()) {
                    currWidthChange += widthStep;
                }
                if (Math.abs(currHeightChange) <= Math.abs(heightDiff) && actualViewportSize.getHeight() != requiredSize.getHeight()) {
                    currHeightChange += heightStep;
                }
                if ((requiredBrowserSize = new RectangleSize(browserSize.getWidth() + currWidthChange, browserSize.getHeight() + currHeightChange)).equals(lastRequiredBrowserSize)) {
                    logger.verbose("Browser size is as required but viewport size does not match!");
                    logger.verbose("Browser size: " + requiredBrowserSize + " , Viewport size: " + actualViewportSize);
                    logger.verbose("Stopping viewport size attempts.");
                    break;
                }
                EyesSeleniumUtils.setBrowserSize(logger, driver, requiredBrowserSize);
                lastRequiredBrowserSize = requiredBrowserSize;
                actualViewportSize = EyesSeleniumUtils.getViewportSize((JavascriptExecutor)driver);
                logger.verbose("Current viewport size: " + actualViewportSize);
                if (!actualViewportSize.equals((Object)requiredSize)) continue;
                return;
            } while ((Math.abs(currWidthChange) <= Math.abs(widthDiff) || Math.abs(currHeightChange) <= Math.abs(heightDiff)) && --retriesLeft > 0);
            logger.verbose("Zoom workaround failed.");
        }
        throw new EyesException("Failed to set viewport size!");
    }

    public static boolean isAndroid(WebDriver driver) {
        driver = EyesSeleniumUtils.getUnderlyingDriver(driver);
        return driver instanceof AndroidDriver;
    }

    public static boolean isIOS(WebDriver driver) {
        driver = EyesSeleniumUtils.getUnderlyingDriver(driver);
        return driver instanceof IOSDriver;
    }

    public static String getPlatformVersion(HasCapabilities driver) {
        Capabilities capabilities = driver.getCapabilities();
        Object platformVersionObj = capabilities.getCapability("platformVersion");
        return platformVersionObj == null ? null : String.valueOf(platformVersionObj);
    }

    public static float getDevicePixelRatio(IEyesJsExecutor executor) {
        return Float.parseFloat(executor.executeScript("return window.devicePixelRatio", new Object[0]).toString());
    }

    public static Map<String, String> getCurrentTransform(IEyesJsExecutor executor) {
        String script = "return { ";
        for (String key : JS_TRANSFORM_KEYS) {
            script = script + "'" + key + "': document.documentElement.style['" + key + "'],";
        }
        script = script + " }";
        return (Map)executor.executeScript(script, new Object[0]);
    }

    public static void setTransforms(IEyesJsExecutor executor, Map<String, String> transforms) {
        String script = "";
        for (Map.Entry<String, String> entry : transforms.entrySet()) {
            script = script + "document.documentElement.style['" + entry.getKey() + "'] = '" + entry.getValue() + "';";
        }
        executor.executeScript(script, new Object[0]);
    }

    public static void setTransform(IEyesJsExecutor executor, String transform) {
        HashMap<String, String> transforms = new HashMap<String, String>(JS_TRANSFORM_KEYS.length);
        for (String key : JS_TRANSFORM_KEYS) {
            transforms.put(key, transform);
        }
        EyesSeleniumUtils.setTransforms(executor, transforms);
    }

    public static void translateTo(IEyesJsExecutor executor, Location position) {
        EyesSeleniumUtils.setTransform(executor, String.format("translate(-%spx, -%spx)", position.getX(), position.getY()));
    }

    public static RectangleSize getElementVisibleSize(WebElement element) {
        WebElement parent;
        Point location = element.getLocation();
        Dimension size = element.getSize();
        Region region = new Region(location.getX(), location.getY(), size.getWidth(), size.getHeight());
        try {
            parent = element.findElement(By.xpath((String)".."));
        }
        catch (Exception e) {
            parent = null;
        }
        block6: while (true) {
            try {
                while (parent != null && !region.isSizeEmpty()) {
                    Point parentLocation = parent.getLocation();
                    Dimension parentSize = parent.getSize();
                    Region parentRegion = new Region(parentLocation.getX(), parentLocation.getY(), parentSize.getWidth(), parentSize.getHeight());
                    region.intersect(parentRegion);
                    try {
                        parent = parent.findElement(By.xpath((String)".."));
                        continue block6;
                    }
                    catch (Exception e) {
                        parent = null;
                    }
                }
                break;
            }
            catch (Exception ex) {
                GeneralUtils.logExceptionStackTrace((Exception)ex);
                break;
            }
        }
        return region.getSize();
    }
}

