/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.selenium.Eyes;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class IgnoreRegionBySelector
implements GetRegion {
    private By selector;

    public IgnoreRegionBySelector(By selector) {
        this.selector = selector;
    }

    public List<Region> getRegions(EyesBase eyesBase, EyesScreenshot screenshot) {
        List elements = ((Eyes)eyesBase).getDriver().findElements(this.selector);
        ArrayList<Region> values = new ArrayList<Region>(elements.size());
        for (WebElement element : elements) {
            Point locationAsPoint = element.getLocation();
            RectangleSize size = EyesSeleniumUtils.getElementVisibleSize(element);
            Location adjustedLocation = screenshot.getLocationInScreenshot(new Location(locationAsPoint.getX(), locationAsPoint.getY()), CoordinatesType.CONTEXT_RELATIVE);
            values.add(new Region(adjustedLocation, size, CoordinatesType.SCREENSHOT_AS_IS));
        }
        return values;
    }
}

