/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowDataWithScreenshot;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.ScaleProviderIdentityFactory;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.diagnostics.TimedAppOutput;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.events.ValidationResult;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.IgnoreRegionByRectangle;
import com.applitools.eyes.positioning.NullRegionProvider;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.scaling.FixedScaleProviderFactory;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.selenium.ContextBasedScaleProviderFactory;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.capture.DomCapture;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshot;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshotFactory;
import com.applitools.eyes.selenium.capture.FullPageCaptureAlgorithm;
import com.applitools.eyes.selenium.capture.ImageProviderFactory;
import com.applitools.eyes.selenium.config.Configuration;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.ISeleniumFrameCheckTarget;
import com.applitools.eyes.selenium.fluent.IgnoreRegionByElement;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionProvider;
import com.applitools.eyes.selenium.positioning.ElementPositionProvider;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensationFactory;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.regionVisibility.MoveToRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.NopRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.RegionVisibilityStrategy;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Eyes
extends EyesBase {
    private FrameChain originalFC;
    private WebElement scrollRootElement;
    private PositionProvider currentFramePositionProvider;
    public static final double UNKNOWN_DEVICE_PIXEL_RATIO = 0.0;
    public static final double DEFAULT_DEVICE_PIXEL_RATIO = 1.0;
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private static final int RESPONSE_TIME_DEFAULT_DEADLINE = 10;
    private static final int RESPONSE_TIME_DEFAULT_DIFF_FROM_DEADLINE = 20;
    private static final int DEFAULT_WAIT_BEFORE_SCREENSHOTS = 100;
    private EyesWebDriver driver;
    private boolean doNotGetTitle = false;
    private boolean checkFrameOrElement = false;
    private Region regionToCheck = null;
    private String originalOverflow;
    private ImageRotation rotation;
    private double devicePixelRatio = 0.0;
    private PropertyHandler<RegionVisibilityStrategy> regionVisibilityStrategyHandler;
    private ElementPositionProvider elementPositionProvider;
    private SeleniumJavaScriptExecutor jsExecutor;
    private UserAgent userAgent;
    private ImageProvider imageProvider;
    private RegionPositionCompensation regionPositionCompensation;
    private WebElement targetElement = null;
    private PositionMemento positionMemento;
    private Region effectiveViewport = Region.EMPTY;
    private EyesScreenshotFactory screenshotFactory;
    private boolean stitchContent = false;

    public PositionProvider getCurrentFramePositionProvider() {
        return this.currentFramePositionProvider;
    }

    public Region getRegionToCheck() {
        return this.regionToCheck;
    }

    public void setRegionToCheck(Region regionToCheck) {
        this.regionToCheck = regionToCheck;
    }

    protected void ensureConfiguration() {
        this.config = new Configuration();
    }

    private Configuration getConfig() {
        return (Configuration)this.config;
    }

    public boolean getHideCaret() {
        return this.getConfig().getHideCaret();
    }

    public void setHideCaret(boolean hideCaret) {
        this.getConfig().setHideCaret(hideCaret);
    }

    public boolean shouldStitchContent() {
        return this.stitchContent;
    }

    public Eyes() {
        this.regionVisibilityStrategyHandler = new SimplePropertyHandler();
        this.regionVisibilityStrategyHandler.set((Object)new MoveToRegionVisibilityStrategy(this.logger));
        EyesTargetLocator.initLogger(this.logger);
    }

    public String getBaseAgentId() {
        return "eyes.selenium.java/3.38";
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.getConfig().setForceFullPageScreenshot(shouldForce);
    }

    public boolean getForceFullPageScreenshot() {
        return this.getConfig().getForceFullPageScreenshot();
    }

    public void setWaitBeforeScreenshots(int waitBeforeScreenshots) {
        this.getConfig().setWaitBeforeScreenshots(waitBeforeScreenshots);
    }

    public int getWaitBeforeScreenshots() {
        return this.getConfig().getWaitBeforeScreenshots();
    }

    public void setScrollToRegion(boolean shouldScroll) {
        this.regionVisibilityStrategyHandler = shouldScroll ? new ReadOnlyPropertyHandler(this.logger, (Object)new MoveToRegionVisibilityStrategy(this.logger)) : new ReadOnlyPropertyHandler(this.logger, (Object)new NopRegionVisibilityStrategy(this.logger));
    }

    public boolean getScrollToRegion() {
        return !(this.regionVisibilityStrategyHandler.get() instanceof NopRegionVisibilityStrategy);
    }

    public void setStitchMode(StitchMode mode) {
        this.logger.verbose("setting stitch mode to " + (Object)((Object)mode));
        this.getConfig().setStitchMode(mode);
        if (this.driver != null) {
            this.setPositionProvider(this.createPositionProvider());
        }
    }

    public StitchMode getStitchMode() {
        return this.getConfig().getStitchMode();
    }

    public void setHideScrollbars(boolean shouldHide) {
        this.getConfig().setHideScrollbars(shouldHide);
    }

    public boolean getHideScrollbars() {
        return this.getConfig().getHideScrollbars();
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        if (this.driver != null) {
            this.driver.setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public WebDriver open(WebDriver driver, Configuration configuration) {
        this.config = configuration;
        return this.open(driver);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.config.setAppName(appName);
        this.config.setTestName(testName);
        this.config.setViewportSize(viewportSize);
        return this.open(driver);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        this.config.setAppName(appName);
        this.config.setTestName(testName);
        return this.open(driver);
    }

    protected WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        this.config.setAppName(appName);
        this.config.setTestName(testName);
        this.config.setViewportSize(viewportSize);
        this.config.setSessionType(sessionType);
        return this.open(driver);
    }

    protected WebDriver open(WebDriver driver) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return driver;
        }
        this.initDriver(driver);
        this.screenshotFactory = new EyesWebDriverScreenshotFactory(this.logger, this.driver);
        this.openBase();
        String uaString = this.sessionStartInfo.getEnvironment().getInferred();
        if (uaString != null) {
            if (uaString.startsWith("useragent:")) {
                uaString = uaString.substring(10);
            }
            this.userAgent = UserAgent.ParseUserAgentString((String)uaString, (boolean)true);
        }
        this.imageProvider = ImageProviderFactory.getImageProvider(this.userAgent, this, this.logger, this.driver);
        this.regionPositionCompensation = RegionPositionCompensationFactory.getRegionPositionCompensation(this.userAgent, this, this.logger);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.devicePixelRatio = 0.0;
        this.jsExecutor = new SeleniumJavaScriptExecutor(this.driver);
        this.driver.setRotation(this.rotation);
        return this.driver;
    }

    private void initDriver(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesWebDriver(this.logger, this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesWebDriver) {
            this.driver = (EyesWebDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        if (EyesSeleniumUtils.isMobileDevice(driver)) {
            this.regionVisibilityStrategyHandler.set((Object)new NopRegionVisibilityStrategy(this.logger));
        }
    }

    private PositionProvider createPositionProvider() {
        return this.createPositionProvider(this.scrollRootElement);
    }

    private PositionProvider createPositionProvider(WebElement scrollRootElement) {
        StitchMode stitchMode = this.getStitchMode();
        this.logger.verbose("initializing position provider. stitchMode: " + (Object)((Object)stitchMode));
        switch (stitchMode) {
            case CSS: {
                return new CssTranslatePositionProvider(this.logger, this.jsExecutor, scrollRootElement);
            }
        }
        return new ScrollPositionProvider(this.logger, this.jsExecutor);
    }

    protected WebDriver open(WebDriver driver, String appName, String testName, SessionType sessionType) {
        return this.open(driver, appName, testName, null, sessionType);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.window().timeout(matchTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWindow(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.open(driver, appName, testName, viewportSize);
        try {
            this.checkWindow(testName);
            this.close();
        }
        finally {
            this.abortIfNotClosed();
        }
    }

    public void testWindow(WebDriver driver, String appName, String testName) {
        this.testWindow(driver, appName, testName, null);
    }

    public void testWindow(WebDriver driver, String testName, RectangleSize viewportSize) {
        this.testWindow(driver, null, testName, viewportSize);
    }

    public void testWindow(WebDriver driver, String testName) {
        this.testWindow(driver, testName, (RectangleSize)null);
    }

    public void testResponseTime(final WebDriver driver, String appName, String testName, final WebDriverAction action, int deadline, int timeout) {
        this.open(driver, appName, testName, SessionType.PROGRESSION);
        Runnable runnableAction = null;
        if (action != null) {
            runnableAction = new Runnable(){

                @Override
                public void run() {
                    action.drive(driver);
                }
            };
        }
        MatchWindowDataWithScreenshot result = super.testResponseTimeBase((RegionProvider)NullRegionProvider.INSTANCE, runnableAction, deadline, timeout, 5000L);
        this.logger.verbose("Checking if deadline was exceeded...");
        boolean deadlineExceeded = true;
        if (result != null) {
            TimedAppOutput tao = (TimedAppOutput)result.getMatchWindowData().getAppOutput();
            long resultElapsed = tao.getElapsed();
            long deadlineMs = deadline * 1000;
            this.logger.verbose(String.format("Deadline: %d, Elapsed time for match: %d", deadlineMs, resultElapsed));
            deadlineExceeded = resultElapsed > deadlineMs;
        }
        this.logger.verbose("Deadline exceeded? " + deadlineExceeded);
        this.closeResponseTime(deadlineExceeded);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline) {
        this.testResponseTime(driver, appName, testName, action, deadline, deadline + 20);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action) {
        this.testResponseTime(driver, appName, testName, action, 10, 30);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline) {
        this.testResponseTime(driver, appName, testName, null, deadline, deadline + 20);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName) {
        this.testResponseTime(driver, appName, testName, null, 10, 30);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline, int timeout, RectangleSize viewportSize) {
        Eyes.setViewportSize(driver, viewportSize);
        this.testResponseTime(driver, appName, testName, action, deadline, timeout);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, action, deadline, deadline + 20, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, action, 10, 30, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline, int timeout, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, null, deadline, timeout, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, deadline, deadline + 20, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, 10, 30, viewportSize);
    }

    public void check(ICheckSettings ... checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check(ICheckSettings[%d]): Ignored", checkSettings.length));
            return;
        }
        boolean originalForceFPS = this.getConfig().getForceFullPageScreenshot();
        if (checkSettings.length > 1) {
            this.getConfig().setForceFullPageScreenshot(true);
        }
        Hashtable<Integer, GetRegion> getRegions = new Hashtable<Integer, GetRegion>();
        Hashtable<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary = new Hashtable<Integer, ICheckSettingsInternal>();
        for (int i = 0; i < checkSettings.length; ++i) {
            ISeleniumCheckTarget seleniumCheckTarget;
            ICheckSettings settings = checkSettings[i];
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)settings;
            ((Dictionary)checkSettingsInternalDictionary).put(i, checkSettingsInternal);
            Region targetRegion = checkSettingsInternal.getTargetRegion();
            if (targetRegion != null) {
                ((Dictionary)getRegions).put(i, (GetRegion)new IgnoreRegionByRectangle(targetRegion));
                continue;
            }
            ISeleniumCheckTarget iSeleniumCheckTarget = seleniumCheckTarget = settings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)settings : null;
            if (seleniumCheckTarget == null) continue;
            WebElement targetElement = this.getTargetElement(seleniumCheckTarget);
            if (targetElement == null && seleniumCheckTarget.getFrameChain().size() == 1) {
                targetElement = this.getFrameElement(seleniumCheckTarget.getFrameChain().get(0));
            }
            if (targetElement == null) continue;
            ((Dictionary)getRegions).put(i, new IgnoreRegionByElement(targetElement));
        }
        this.scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
        this.currentFramePositionProvider = null;
        this.matchRegions(getRegions, checkSettingsInternalDictionary, checkSettings);
        this.getConfig().setForceFullPageScreenshot(originalForceFPS);
    }

    private void matchRegions(Dictionary<Integer, GetRegion> getRegions, Dictionary<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary, ICheckSettings[] checkSettings) {
        if (getRegions.size() == 0) {
            return;
        }
        this.originalFC = this.driver.getFrameChain().clone();
        FrameChain originalFC = this.tryHideScrollbars();
        Region bBox = this.findBoundingBox(getRegions, checkSettings);
        MatchWindowTask mwt = new MatchWindowTask(this.logger, this.serverConnector, this.runningSession, this.getMatchTimeout(), (EyesBase)this);
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory);
        BufferedImage screenshotImage = algo.getStitchedRegion(Region.EMPTY, bBox, (PositionProvider)this.positionProviderHandler.get());
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage, null, bBox.getNegativeLocation());
        for (int i = 0; i < checkSettings.length; ++i) {
            if (!((Hashtable)getRegions).containsKey(i)) continue;
            GetRegion getRegion = getRegions.get(i);
            ICheckSettingsInternal checkSettingsInternal = checkSettingsInternalDictionary.get(i);
            List<EyesScreenshot> subScreenshots = this.getSubScreenshots(screenshot, getRegion);
            this.matchRegion(checkSettingsInternal, mwt, subScreenshots);
        }
        this.tryRestoreScrollbars(originalFC);
        ((EyesTargetLocator)this.driver.switchTo()).frames(this.originalFC);
    }

    private List<EyesScreenshot> getSubScreenshots(EyesWebDriverScreenshot screenshot, GetRegion getRegion) {
        ArrayList<EyesScreenshot> subScreenshots = new ArrayList<EyesScreenshot>();
        for (Region r : getRegion.getRegions((EyesBase)this, (EyesScreenshot)screenshot, true)) {
            this.logger.verbose("original sub-region: " + r);
            r = this.regionPositionCompensation.compensateRegionPosition(r, this.devicePixelRatio);
            this.logger.verbose("sub-region after compensation: " + r);
            EyesWebDriverScreenshot subScreenshot = screenshot.getSubScreenshotForRegion(r, false);
            subScreenshots.add(subScreenshot);
        }
        return subScreenshots;
    }

    private void matchRegion(ICheckSettingsInternal checkSettingsInternal, MatchWindowTask mwt, List<EyesScreenshot> subScreenshots) {
        String name = checkSettingsInternal.getName();
        for (EyesScreenshot subScreenshot : subScreenshots) {
            this.debugScreenshotsProvider.save(subScreenshot.getImage(), String.format("subscreenshot_%s", name));
            ImageMatchSettings ims = mwt.createImageMatchSettings(checkSettingsInternal, subScreenshot);
            AppOutput appOutput = new AppOutput(name, ImageUtils.base64FromImage((BufferedImage)subScreenshot.getImage()), null);
            AppOutputWithScreenshot appOutputWithScreenshot = new AppOutputWithScreenshot(appOutput, subScreenshot);
            MatchResult matchResult = mwt.performMatch(new Trigger[0], appOutputWithScreenshot, name, false, ims);
            this.logger.verbose("matchResult.asExcepted: " + matchResult.getAsExpected());
        }
    }

    private Region findBoundingBox(Dictionary<Integer, GetRegion> getRegions, ICheckSettings[] checkSettings) {
        RectangleSize rectSize = this.getViewportSize();
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, new BufferedImage(rectSize.getWidth(), rectSize.getHeight(), 1));
        return this.findBoundingBox(getRegions, checkSettings, screenshot);
    }

    private Region findBoundingBox(Dictionary<Integer, GetRegion> getRegions, ICheckSettings[] checkSettings, EyesScreenshot screenshot) {
        Region bBox = null;
        for (int i = 0; i < checkSettings.length; ++i) {
            GetRegion getRegion = getRegions.get(i);
            if (getRegion == null) continue;
            List regions = getRegion.getRegions((EyesBase)this, screenshot, true);
            for (Region region : regions) {
                if (bBox == null) {
                    bBox = new Region(region);
                    continue;
                }
                bBox = bBox.expandToContain(region);
            }
        }
        return bBox;
    }

    private WebElement getFrameElement(FrameLocator frameLocator) {
        WebElement frameReference = frameLocator.getFrameReference();
        if (frameReference == null) {
            By selector = frameLocator.getFrameSelector();
            List<WebElement> possibleFrames = null;
            if (selector != null) {
                possibleFrames = this.driver.findElements(selector);
            } else {
                Integer frameIndex;
                String nameOrId = frameLocator.getFrameNameOrId();
                if (nameOrId != null && (possibleFrames = this.driver.findElementsById(nameOrId)).size() == 0 && (possibleFrames = this.driver.findElementsByName(nameOrId)).size() == 0 && (frameIndex = frameLocator.getFrameIndex()) != null) {
                    possibleFrames = this.driver.findElements(By.cssSelector((String)String.format("iframe:nth-of-type(%d)", frameIndex)));
                }
            }
            if (possibleFrames != null && possibleFrames.size() > 0) {
                frameReference = possibleFrames.get(0);
            }
        }
        return frameReference;
    }

    private WebElement getTargetElement(ISeleniumCheckTarget seleniumCheckTarget) {
        assert (seleniumCheckTarget != null);
        By targetSelector = seleniumCheckTarget.getTargetSelector();
        WebElement targetElement = seleniumCheckTarget.getTargetElement();
        if (targetElement == null && targetSelector != null) {
            targetElement = this.driver.findElement(targetSelector);
        }
        return targetElement;
    }

    public void check(String name, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check('%s', %s): Ignored", name, checkSettings));
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        checkSettings = checkSettings.withName(name);
        this.check(checkSettings);
    }

    public String tryCaptureDom() {
        ElementPositionProvider positionProvider = new ElementPositionProvider(this.logger, this.driver, this.scrollRootElement);
        DomCapture domCapture = new DomCapture(this);
        String fullWindowDom = domCapture.getFullWindowDom(this.driver, positionProvider);
        if (this.domCaptureListener != null) {
            this.domCaptureListener.onDomCaptureComplete(fullWindowDom);
        }
        return fullWindowDom;
    }

    public void check(ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check(%s): Ignored", checkSettings));
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        ISeleniumCheckTarget seleniumCheckTarget = checkSettings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)checkSettings : null;
        String name = checkSettingsInternal.getName();
        this.scrollRootElement = this.getScrollRootElement(seleniumCheckTarget);
        this.currentFramePositionProvider = null;
        this.setPositionProvider(this.createPositionProvider());
        this.logger.verbose(String.format("check(\"%s\", checkSettings) - begin", name));
        ValidationInfo validationInfo = this.fireValidationWillStartEvent(name);
        if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
            this.logger.verbose("URL: " + this.driver.getCurrentUrl());
        }
        this.stitchContent = checkSettingsInternal.getStitchContent();
        final Region targetRegion = checkSettingsInternal.getTargetRegion();
        this.originalFC = this.driver.getFrameChain().clone();
        int switchedToFrameCount = this.switchToFrame(seleniumCheckTarget);
        this.regionToCheck = null;
        MatchResult result = null;
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        FrameChain originalFC = null;
        if (targetRegion != null) {
            this.logger.verbose("have target region");
            originalFC = this.tryHideScrollbars();
            result = this.checkWindowBase(new RegionProvider(){

                public Region getRegion() {
                    return new Region(targetRegion.getLocation(), targetRegion.getSize(), CoordinatesType.CONTEXT_RELATIVE);
                }
            }, name, false, checkSettings);
        } else if (seleniumCheckTarget != null) {
            WebElement targetElement = this.getTargetElement(seleniumCheckTarget);
            if (targetElement != null) {
                this.logger.verbose("have target element");
                originalFC = this.tryHideScrollbars();
                this.targetElement = targetElement;
                result = this.stitchContent ? this.checkElement(name, checkSettings) : this.checkRegion(name, checkSettings);
                this.targetElement = null;
            } else if (seleniumCheckTarget.getFrameChain().size() > 0) {
                this.logger.verbose("have frame chain");
                originalFC = this.tryHideScrollbars();
                result = this.stitchContent ? this.checkFullFrameOrElement(name, checkSettings) : this.checkFrameFluent(name, checkSettings);
            } else {
                this.logger.verbose("default case");
                if (!EyesSeleniumUtils.isMobileDevice(this.driver)) {
                    switchTo.defaultContent();
                    originalFC = this.tryHideScrollbars();
                    this.currentFramePositionProvider = this.createPositionProvider(this.driver.findElement(By.tagName((String)"html")));
                }
                result = this.checkWindowBase((RegionProvider)NullRegionProvider.INSTANCE, name, false, checkSettings);
                switchTo.frames(this.originalFC);
            }
        }
        if (result == null) {
            result = new MatchResult();
        }
        while (switchedToFrameCount > 0) {
            this.driver.switchTo().parentFrame();
            --switchedToFrameCount;
        }
        if (this.positionMemento != null) {
            ((PositionProvider)this.positionProviderHandler.get()).restoreState(this.positionMemento);
            this.positionMemento = null;
        }
        switchTo.resetScroll();
        if (originalFC != null) {
            this.tryRestoreScrollbars(originalFC);
        }
        this.trySwitchToFrames(this.driver, switchTo, this.originalFC);
        this.stitchContent = false;
        ValidationResult validationResult = new ValidationResult();
        validationResult.setAsExpected(result.getAsExpected());
        this.getSessionEventHandlers().validationEnded(this.getAUTSessionId(), validationInfo.getValidationId(), validationResult);
        this.logger.verbose("check - done!");
    }

    protected MatchResult checkFrameFluent(String name, ICheckSettings checkSettings) {
        FrameChain frameChain = this.driver.getFrameChain().clone();
        Frame targetFrame = frameChain.pop();
        this.targetElement = targetFrame.getReference();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        switchTo.framesDoScroll(frameChain);
        MatchResult result = this.checkRegion(name, checkSettings);
        this.targetElement = null;
        return result;
    }

    private int switchToFrame(ISeleniumCheckTarget checkTarget) {
        if (checkTarget == null) {
            return 0;
        }
        List<FrameLocator> frameChain = checkTarget.getFrameChain();
        int switchedToFrameCount = 0;
        for (FrameLocator frameLocator : frameChain) {
            if (!this.switchToFrame(frameLocator)) continue;
            ++switchedToFrameCount;
        }
        return switchedToFrameCount;
    }

    private boolean switchToFrame(ISeleniumFrameCheckTarget frameTarget) {
        WebElement frameElement;
        WebDriver.TargetLocator switchTo = this.driver.switchTo();
        if (frameTarget.getFrameIndex() != null) {
            switchTo.frame(frameTarget.getFrameIndex().intValue());
            return true;
        }
        if (frameTarget.getFrameNameOrId() != null) {
            switchTo.frame(frameTarget.getFrameNameOrId());
            return true;
        }
        if (frameTarget.getFrameReference() != null && (frameElement = frameTarget.getFrameReference()) != null) {
            switchTo.frame(frameElement);
            return true;
        }
        if (frameTarget.getFrameSelector() != null && (frameElement = this.driver.findElement(frameTarget.getFrameSelector())) != null) {
            switchTo.frame(frameElement);
            return true;
        }
        return false;
    }

    private MatchResult checkFullFrameOrElement(String name, ICheckSettings checkSettings) {
        this.checkFrameOrElement = true;
        this.logger.verbose("enter");
        MatchResult result = this.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return Eyes.this.getFullFrameOrElementRegion();
            }
        }, name, false, checkSettings);
        this.checkFrameOrElement = false;
        return result;
    }

    private Region getFullFrameOrElementRegion() {
        this.logger.verbose("checkFrameOrElement: " + this.checkFrameOrElement);
        if (this.checkFrameOrElement) {
            FrameChain fc = this.ensureFrameVisible();
            ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
            BufferedImage screenshotImage = this.imageProvider.getImage();
            this.debugScreenshotsProvider.save(screenshotImage, "checkFullFrameOrElement");
            scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
            EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
            switchTo.frames(fc);
            EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            this.logger.verbose("replacing regionToCheck");
            this.setRegionToCheck(screenshot.getFrameWindow());
        }
        return Region.EMPTY;
    }

    private FrameChain ensureFrameVisible() {
        this.logger.verbose("scrollRootElement_: " + this.scrollRootElement);
        FrameChain originalFC = this.driver.getFrameChain().clone();
        FrameChain fc = this.driver.getFrameChain().clone();
        while (fc.size() > 0) {
            this.logger.verbose("fc.Count: " + fc.size());
            EyesTargetLocator.parentFrame(this.driver.getRemoteWebDriver().switchTo(), fc);
            Frame prevFrame = fc.pop();
            Frame frame = fc.peek();
            WebElement scrollRootElement = null;
            if (fc.size() == this.originalFC.size()) {
                this.logger.verbose("PositionProvider: " + this.positionProviderHandler.get());
                this.positionMemento = ((PositionProvider)this.positionProviderHandler.get()).getState();
                scrollRootElement = this.scrollRootElement;
            } else {
                if (frame != null) {
                    scrollRootElement = frame.getScrollRootElement();
                }
                if (scrollRootElement == null) {
                    scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
                }
            }
            this.logger.verbose("scrollRootElement: " + scrollRootElement);
            PositionProvider positionProvider = this.getElementPositionProvider(scrollRootElement);
            positionProvider.setPosition(prevFrame.getLocation());
            Region reg = new Region(Location.ZERO, prevFrame.getInnerSize());
            this.effectiveViewport.intersect(reg);
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
        return originalFC;
    }

    private void ensureElementVisible(WebElement element) {
        if (this.targetElement == null || !this.getScrollToRegion()) {
            return;
        }
        if (EyesSeleniumUtils.isMobileDevice((WebDriver)this.driver.getRemoteWebDriver())) {
            this.logger.log("NATIVE context identified, skipping 'ensure element visible'");
            return;
        }
        FrameChain originalFC = this.driver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        EyesRemoteWebElement eyesRemoteWebElement = new EyesRemoteWebElement(this.logger, this.driver, element);
        Region elementBounds = eyesRemoteWebElement.getBounds();
        Location currentFrameOffset = originalFC.getCurrentFrameOffset();
        elementBounds = elementBounds.offset(currentFrameOffset.getX(), currentFrameOffset.getY());
        Region viewportBounds = this.getViewportScrollBounds();
        this.logger.verbose("viewportBounds: " + viewportBounds + " ; elementBounds: " + elementBounds);
        if (!viewportBounds.contains(elementBounds)) {
            WebElement scrollRootElement;
            this.ensureFrameVisible();
            Point p = element.getLocation();
            Location elementLocation = new Location(p.getX(), p.getY());
            if (originalFC.size() > 0 && !element.equals(originalFC.peek().getReference())) {
                switchTo.frames(originalFC);
                scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
            } else {
                scrollRootElement = this.scrollRootElement;
            }
            PositionProvider positionProvider = this.getElementPositionProvider(scrollRootElement);
            positionProvider.setPosition(elementLocation);
        }
    }

    private Region getViewportScrollBounds() {
        Location location;
        if (!this.getScrollToRegion()) {
            this.logger.log("WARNING: no region visibility strategy! returning an empty region!");
            return Region.EMPTY;
        }
        FrameChain originalFrameChain = this.driver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        switchTo.defaultContent();
        ScrollPositionProvider spp = new ScrollPositionProvider(this.logger, this.jsExecutor);
        try {
            location = spp.getCurrentPosition();
        }
        catch (EyesDriverOperationException e) {
            this.logger.log("WARNING: " + e.getMessage());
            this.logger.log("Assuming position is 0,0");
            location = new Location(0, 0);
        }
        Region viewportBounds = new Region(location, this.getViewportSize());
        switchTo.frames(originalFrameChain);
        return viewportBounds;
    }

    private MatchResult checkRegion(String name, ICheckSettings checkSettings) {
        MatchResult result = this.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                Point p = Eyes.this.targetElement.getLocation();
                Dimension d = Eyes.this.targetElement.getSize();
                return new Region(p.getX(), p.getY(), d.getWidth(), d.getHeight(), CoordinatesType.CONTEXT_RELATIVE);
            }
        }, name, false, checkSettings);
        this.logger.verbose("Done! trying to scroll back to original position.");
        return result;
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(final Region region, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkRegion([%s], %d, '%s'): Ignored", region, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.logger.verbose(String.format("checkRegion([%s], %d, '%s')", region, matchTimeout, tag));
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return region;
            }
        }, tag, false, matchTimeout);
    }

    public void checkRegion(WebElement element) {
        this.check((String)null, (ICheckSettings)Target.region(element));
    }

    public void checkRegion(WebElement element, boolean stitchContent) {
        this.check((String)null, (ICheckSettings)Target.region(element).fully(stitchContent));
    }

    public void checkRegion(WebElement element, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element));
    }

    public void checkRegion(WebElement element, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.region(element).fully(stitchContent));
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag) {
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout));
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegion(By selector) {
        this.check((String)null, (ICheckSettings)Target.region(selector));
    }

    public void checkRegion(By selector, boolean stitchContent) {
        this.check((String)null, (ICheckSettings)Target.region(selector).fully(stitchContent));
    }

    public void checkRegion(By selector, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector));
    }

    public void checkRegion(By selector, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.region(selector).fully(stitchContent));
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout));
    }

    public void checkRegion(By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector) {
        this.checkRegionInFrame(frameIndex, selector, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, null, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag) {
        this.checkRegionInFrame(frameIndex, selector, tag, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameIndex, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(String frameNameOrId, By selector) {
        this.checkRegionInFrame(frameNameOrId, selector, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, null, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(WebElement frameReference, By selector) {
        this.checkRegionInFrame(frameReference, selector, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, null, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag) {
        this.checkRegionInFrame(frameReference, selector, tag, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameReference, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    protected ScaleProviderFactory updateScalingParams() {
        if (this.devicePixelRatio == 0.0 && this.scaleProviderHandler.get() instanceof NullScaleProvider) {
            ScaleProviderFactory factory;
            this.logger.verbose("Trying to extract device pixel ratio...");
            try {
                this.devicePixelRatio = EyesSeleniumUtils.getDevicePixelRatio(this.jsExecutor);
            }
            catch (Exception e) {
                this.logger.verbose("Failed to extract device pixel ratio! Using default.");
                this.devicePixelRatio = 1.0;
            }
            this.logger.verbose(String.format("Device pixel ratio: %f", this.devicePixelRatio));
            this.logger.verbose("Setting scale provider...");
            try {
                factory = this.getScaleProviderFactory();
            }
            catch (Exception e) {
                this.logger.verbose("Failed to set ContextBasedScaleProvider.");
                this.logger.verbose("Using FixedScaleProvider instead...");
                factory = new FixedScaleProviderFactory(1.0 / this.devicePixelRatio, this.scaleProviderHandler);
            }
            this.logger.verbose("Done!");
            return factory;
        }
        SimplePropertyHandler nullProvider = new SimplePropertyHandler();
        return new ScaleProviderIdentityFactory((ScaleProvider)this.scaleProviderHandler.get(), (PropertyHandler)nullProvider);
    }

    private ScaleProviderFactory getScaleProviderFactory() {
        WebElement element = this.driver.findElement(By.tagName((String)"html"));
        RectangleSize entireSize = EyesSeleniumUtils.getEntireElementSize(this.jsExecutor, element);
        return new ContextBasedScaleProviderFactory(this.logger, entireSize, (RectangleSize)this.viewportSizeHandler.get(), this.devicePixelRatio, false, (PropertyHandler<ScaleProvider>)this.scaleProviderHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCurrentFrame(int matchTimeout, String tag) {
        try {
            this.logger.verbose(String.format("CheckCurrentFrame(%d, '%s')", matchTimeout, tag));
            this.checkFrameOrElement = true;
            this.logger.verbose("Getting screenshot as base64..");
            String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            this.logger.verbose("Done! Creating image object...");
            BufferedImage screenshotImage = ImageUtils.imageFromBase64((String)screenshot64);
            ScaleProvider scaleProvider = this.updateScalingParams().getScaleProvider(screenshotImage.getWidth());
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (ScaleProvider)scaleProvider);
            this.logger.verbose("Done! Building required object...");
            EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            this.logger.verbose("Done!");
            this.logger.verbose("replacing regionToCheck");
            this.setRegionToCheck(screenshot.getFrameWindow());
            super.checkWindowBase((RegionProvider)NullRegionProvider.INSTANCE, tag, false, matchTimeout);
        }
        finally {
            this.checkFrameOrElement = false;
            this.regionToCheck = null;
        }
    }

    public void checkFrame(String frameNameOrId) {
        this.check((String)null, (ICheckSettings)Target.frame(frameNameOrId));
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).fully());
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).timeout(matchTimeout).fully());
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, -1, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%d, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        ArgumentGuard.greaterThanOrEqualToZero((long)frameIndex, (String)"frameIndex");
        this.logger.log(String.format("CheckFrame(%d, %d, '%s')", frameIndex, matchTimeout, tag));
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).timeout(matchTimeout));
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.timeout(matchTimeout).fully());
    }

    public void checkFrame(String[] framesPath, String tag) {
        this.checkFrame(framesPath, -1, tag);
    }

    public void checkFrame(String[] framesPath) {
        this.checkFrame(framesPath, -1, null);
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(framePath, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(String[] framePath, By selector, String tag) {
        this.checkRegionInFrame(framePath, selector, -1, tag);
    }

    public void checkRegionInFrame(String[] framePath, By selector) {
        this.checkRegionInFrame(framePath, selector, -1, null);
    }

    public void checkElement(WebElement element) {
        this.check((String)null, (ICheckSettings)Target.region(element).fully());
    }

    public void checkElement(WebElement element, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).fully());
    }

    private MatchResult checkElement(String name, ICheckSettings checkSettings) {
        return this.checkElement(this.targetElement, name, checkSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatchResult checkElement(WebElement element, String name, ICheckSettings checkSettings) {
        MatchResult result;
        EyesRemoteWebElement eyesElement = element instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)element : new EyesRemoteWebElement(this.logger, this.driver, element);
        this.regionToCheck = null;
        PositionMemento originalPositionMemento = ((PositionProvider)this.positionProviderHandler.get()).getState();
        this.ensureElementVisible(this.targetElement);
        ScrollPositionProvider scrollPositionProvider = new ScrollPositionProvider(this.logger, this.jsExecutor);
        Location originalScrollPosition = scrollPositionProvider.getCurrentPosition();
        String originalOverflow = null;
        Point pl = eyesElement.getLocation();
        try {
            this.checkFrameOrElement = true;
            String displayStyle = eyesElement.getComputedStyle("display");
            if (this.getConfig().getHideScrollbars()) {
                originalOverflow = eyesElement.getOverflow();
                eyesElement.setOverflow("hidden");
            }
            int elementWidth = eyesElement.getClientWidth();
            int elementHeight = eyesElement.getClientHeight();
            this.elementPositionProvider = !displayStyle.equals("inline") && elementHeight <= this.effectiveViewport.getHeight() && elementWidth <= this.effectiveViewport.getWidth() ? new ElementPositionProvider(this.logger, this.driver, (WebElement)eyesElement) : null;
            int borderLeftWidth = eyesElement.getComputedStyleInteger("border-left-width");
            int borderTopWidth = eyesElement.getComputedStyleInteger("border-top-width");
            Region elementRegion = new Region(pl.getX() + borderLeftWidth, pl.getY() + borderTopWidth, elementWidth, elementHeight, CoordinatesType.SCREENSHOT_AS_IS);
            this.logger.verbose("Element region: " + elementRegion);
            this.logger.verbose("replacing regionToCheck");
            this.regionToCheck = elementRegion;
            if (!this.effectiveViewport.isSizeEmpty()) {
                this.regionToCheck.intersect(this.effectiveViewport);
            }
            result = this.checkWindowBase((RegionProvider)NullRegionProvider.INSTANCE, name, false, checkSettings);
            if (originalOverflow != null) {
                eyesElement.setOverflow(originalOverflow);
            }
            this.checkFrameOrElement = false;
        }
        catch (Throwable throwable) {
            if (originalOverflow != null) {
                eyesElement.setOverflow(originalOverflow);
            }
            this.checkFrameOrElement = false;
            ((PositionProvider)this.positionProviderHandler.get()).restoreState(originalPositionMemento);
            scrollPositionProvider.setPosition(originalScrollPosition);
            this.regionToCheck = null;
            this.elementPositionProvider = null;
            throw throwable;
        }
        ((PositionProvider)this.positionProviderHandler.get()).restoreState(originalPositionMemento);
        scrollPositionProvider.setPosition(originalScrollPosition);
        this.regionToCheck = null;
        this.elementPositionProvider = null;
        return result;
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.check((String)null, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully());
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        elementRegion = this.lastScreenshot.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        this.addMouseTriggerBase(action, elementRegion, elementRegion.getMiddleOffset());
    }

    public void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring '%s' (different frame)", text));
            return;
        }
        this.addTextTriggerBase(control, text);
    }

    public void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        this.addTextTrigger(elementRegion, text);
    }

    public RectangleSize getViewportSize() {
        RectangleSize viewportSize = (RectangleSize)this.viewportSizeHandler.get();
        if (viewportSize == null) {
            viewportSize = this.driver.getDefaultContentViewportSize();
        }
        return viewportSize;
    }

    public static RectangleSize getViewportSize(WebDriver driver) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        return EyesSeleniumUtils.getViewportSizeOrDisplaySize(new Logger(), driver);
    }

    protected void setViewportSize(RectangleSize size) {
        if (this.viewportSizeHandler instanceof ReadOnlyPropertyHandler) {
            this.logger.verbose("Ignored (viewport size given explicitly)");
            return;
        }
        FrameChain originalFrame = this.driver.getFrameChain();
        this.driver.switchTo().defaultContent();
        try {
            EyesSeleniumUtils.setViewportSize(this.logger, this.driver, size);
            this.effectiveViewport = new Region(Location.ZERO, size);
        }
        catch (EyesException e) {
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
            throw new TestFailedException("Failed to set the viewport size", (Throwable)e);
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        this.viewportSizeHandler.set((Object)new RectangleSize(size.getWidth(), size.getHeight()));
    }

    public static void setViewportSize(WebDriver driver, RectangleSize size) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        EyesSeleniumUtils.setViewportSize(new Logger(), driver, size);
    }

    protected void beforeOpen() {
    }

    private void trySwitchToFrames(WebDriver driver, EyesTargetLocator switchTo, FrameChain frames) {
        if (EyesSeleniumUtils.isMobileDevice(driver)) {
            return;
        }
        try {
            switchTo.frames(frames);
        }
        catch (WebDriverException e) {
            this.logger.log("WARNING: Failed to switch to original frame chain! " + e.getMessage());
        }
    }

    private FrameChain tryHideScrollbars() {
        if (EyesSeleniumUtils.isMobileDevice(this.driver)) {
            return new FrameChain(this.logger);
        }
        if (this.getConfig().getHideScrollbars() || this.getConfig().getStitchMode() == StitchMode.CSS && this.stitchContent) {
            FrameChain originalFC = this.driver.getFrameChain().clone();
            FrameChain fc = this.driver.getFrameChain().clone();
            Frame frame = fc.peek();
            if (fc.size() > 0) {
                while (fc.size() > 0) {
                    this.logger.verbose("fc.Count = " + fc.size());
                    if (this.stitchContent || fc.size() != originalFC.size()) {
                        if (frame != null) {
                            frame.hideScrollbars(this.driver);
                        } else {
                            this.logger.verbose("hiding scrollbars of element (1): " + this.scrollRootElement);
                            EyesSeleniumUtils.setOverflow(this.driver, "hidden", this.scrollRootElement);
                        }
                    }
                    this.driver.switchTo().parentFrame();
                    fc.pop();
                    frame = fc.peek();
                }
            } else {
                this.logger.verbose("hiding scrollbars of element (2): " + this.scrollRootElement);
                this.originalOverflow = EyesSeleniumUtils.setOverflow(this.driver, "hidden", this.scrollRootElement);
            }
            this.logger.verbose("switching back to original frame");
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
            this.logger.verbose("done hiding scrollbars.");
            return originalFC;
        }
        return new FrameChain(this.logger);
    }

    private void tryRestoreScrollbars(FrameChain frameChain) {
        if (EyesSeleniumUtils.isMobileDevice(this.driver)) {
            return;
        }
        if (this.getConfig().getHideScrollbars() || this.getConfig().getStitchMode() == StitchMode.CSS && this.stitchContent) {
            ((EyesTargetLocator)this.driver.switchTo()).frames(frameChain);
            FrameChain originalFC = frameChain.clone();
            FrameChain fc = frameChain.clone();
            if (fc.size() > 0) {
                while (fc.size() > 0) {
                    Frame frame = fc.pop();
                    frame.returnToOriginalOverflow(this.driver);
                    EyesTargetLocator.parentFrame(this.driver.getRemoteWebDriver().switchTo(), fc);
                }
            } else {
                this.logger.verbose("returning overflow of element to its original value: " + this.scrollRootElement);
                EyesSeleniumUtils.setOverflow(this.driver, this.originalOverflow, this.scrollRootElement);
            }
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
            this.logger.verbose("done restoring scrollbars.");
        } else {
            this.logger.verbose("no need to restore scrollbars.");
        }
        this.driver.getFrameChain().clear();
    }

    protected EyesScreenshot getSubScreenshot(EyesScreenshot screenshot, Region region, ICheckSettingsInternal checkSettingsInternal) {
        ISeleniumCheckTarget seleniumCheckTarget = checkSettingsInternal instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)checkSettingsInternal : null;
        this.logger.verbose("original region: " + region);
        region = this.regionPositionCompensation.compensateRegionPosition(region, this.devicePixelRatio);
        this.logger.verbose("compensated region: " + region);
        if (seleniumCheckTarget == null) {
            return screenshot.getSubScreenshot(region, false);
        }
        if (seleniumCheckTarget.getFrameChain().size() > 0) {
            return screenshot.getSubScreenshot(region, false);
        }
        return ((EyesWebDriverScreenshot)screenshot).getSubScreenshotForRegion(region, false);
    }

    protected EyesScreenshot getScreenshot() {
        EyesWebDriverScreenshot result;
        this.logger.verbose("getScreenshot()");
        FrameChain originalFrameChain = this.driver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory);
        Object activeElement = null;
        if (this.getHideCaret()) {
            try {
                activeElement = this.driver.executeScript("var activeElement = document.activeElement; activeElement && activeElement.blur(); return activeElement;", new Object[0]);
            }
            catch (WebDriverException e) {
                this.logger.verbose("WARNING: Cannot hide caret! " + e.getMessage());
            }
        }
        if (this.checkFrameOrElement) {
            BufferedImage entireFrameOrElement;
            this.logger.verbose("Check frame/element requested");
            switchTo.frames(originalFrameChain);
            if (this.elementPositionProvider == null) {
                WebElement scrollRootElement = this.driver.findElement(By.tagName((String)"html"));
                PositionProvider positionProvider = this.getElementPositionProvider(scrollRootElement);
                entireFrameOrElement = algo.getStitchedRegion(this.regionToCheck, null, positionProvider);
            } else {
                entireFrameOrElement = algo.getStitchedRegion(this.regionToCheck, null, this.elementPositionProvider);
            }
            this.logger.verbose("Building screenshot object...");
            result = new EyesWebDriverScreenshot(this.logger, this.driver, entireFrameOrElement, new RectangleSize(entireFrameOrElement.getWidth(), entireFrameOrElement.getHeight()));
        } else if (this.getConfig().getForceFullPageScreenshot() || this.stitchContent) {
            this.logger.verbose("Full page screenshot requested.");
            Location originalFramePosition = originalFrameChain.size() > 0 ? originalFrameChain.getDefaultContentScrollPosition() : Location.ZERO;
            switchTo.defaultContent();
            BufferedImage fullPageImage = algo.getStitchedRegion(Region.EMPTY, null, (PositionProvider)this.positionProviderHandler.get());
            switchTo.frames(originalFrameChain);
            result = new EyesWebDriverScreenshot(this.logger, this.driver, fullPageImage, null, originalFramePosition);
        } else {
            CutProvider cutProvider;
            this.ensureElementVisible(this.targetElement);
            this.logger.verbose("Screenshot requested...");
            BufferedImage screenshotImage = this.imageProvider.getImage();
            this.debugScreenshotsProvider.save(screenshotImage, "original");
            ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
            if (scaleProvider.getScaleRatio() != 1.0) {
                this.logger.verbose("scaling...");
                screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (ScaleProvider)scaleProvider);
                this.debugScreenshotsProvider.save(screenshotImage, "scaled");
            }
            if (!((cutProvider = (CutProvider)this.cutProviderHandler.get()) instanceof NullCutProvider)) {
                this.logger.verbose("cutting...");
                screenshotImage = cutProvider.cut(screenshotImage);
                this.debugScreenshotsProvider.save(screenshotImage, "cut");
            }
            this.logger.verbose("Creating screenshot object...");
            result = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
        }
        if (this.getHideCaret() && activeElement != null) {
            try {
                this.driver.executeScript("arguments[0].focus();", activeElement);
            }
            catch (WebDriverException e) {
                this.logger.verbose("WARNING: Could not return focus to active element! " + e.getMessage());
            }
        }
        this.logger.verbose("Done!");
        return result;
    }

    private FullPageCaptureAlgorithm createFullPageCaptureAlgorithm(ScaleProviderFactory scaleProviderFactory) {
        return new FullPageCaptureAlgorithm(this.logger, this.regionPositionCompensation, this.getWaitBeforeScreenshots(), this.debugScreenshotsProvider, this.screenshotFactory, new ScrollPositionProvider(this.logger, this.jsExecutor), scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), this.getStitchOverlap(), this.imageProvider);
    }

    protected String getTitle() {
        if (!this.doNotGetTitle) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                this.logger.verbose("failed (" + ex.getMessage() + ")");
                this.doNotGetTitle = true;
            }
        }
        return "";
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = super.getAppEnvironment();
        RemoteWebDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() == null) {
            this.logger.log("No OS set, checking for mobile OS...");
            if (EyesSeleniumUtils.isMobileDevice((WebDriver)underlyingDriver)) {
                String platformName = null;
                this.logger.log("Mobile device detected! Checking device type..");
                if (EyesSeleniumUtils.isAndroid((WebDriver)underlyingDriver)) {
                    this.logger.log("Android detected.");
                    platformName = "Android";
                } else if (EyesSeleniumUtils.isIOS((WebDriver)underlyingDriver)) {
                    this.logger.log("iOS detected.");
                    platformName = "iOS";
                } else {
                    this.logger.log("Unknown device type.");
                }
                if (platformName != null) {
                    String majorVersion;
                    String os = platformName;
                    String platformVersion = EyesSeleniumUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
                    if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                        os = os + " " + majorVersion;
                    }
                    this.logger.verbose("Setting OS: " + os);
                    appEnv.setOs(os);
                }
            } else {
                this.logger.log("No mobile OS detected.");
            }
        }
        this.logger.log("Done!");
        return appEnv;
    }

    private WebElement getScrollRootElement(IScrollRootElementContainer scrollRootElementContainer) {
        if (scrollRootElementContainer == null) {
            return this.driver.findElement(By.tagName((String)"html"));
        }
        WebElement scrollRootElement = scrollRootElementContainer.getScrollRootElement();
        if (scrollRootElement == null) {
            By scrollRootSelector = scrollRootElementContainer.getScrollRootSelector();
            scrollRootElement = this.driver.findElement(scrollRootSelector != null ? scrollRootSelector : By.tagName((String)"html"));
        }
        return scrollRootElement;
    }

    private PositionProvider getElementPositionProvider(WebElement scrollRootElement) {
        PositionProvider positionProvider = ((EyesRemoteWebElement)scrollRootElement).getPositionProvider();
        if (positionProvider == null) {
            positionProvider = this.createPositionProvider(scrollRootElement);
            ((EyesRemoteWebElement)scrollRootElement).setPositionProvider(positionProvider);
        }
        this.logger.verbose("position provider: " + positionProvider);
        this.currentFramePositionProvider = positionProvider;
        return positionProvider;
    }

    private PositionProvider getElementPositionProvider() {
        return this.elementPositionProvider == null ? (PositionProvider)this.positionProviderHandler.get() : this.elementPositionProvider;
    }

    protected String getAUTSessionId() {
        try {
            return this.driver.getRemoteWebDriver().getSessionId().toString();
        }
        catch (Exception e) {
            this.logger.log("WARNING: Failed to get AUT session ID! (maybe driver is not available?). Error: " + e.getMessage());
            return "";
        }
    }

    protected Object getAgentSetup() {
        return new EyesSeleniumAgentSetup();
    }

    public IServerConnector getServerConnector() {
        return this.serverConnector;
    }

    class EyesSeleniumAgentSetup {
        private RemoteWebDriver remoteWebDriver;

        public EyesSeleniumAgentSetup() {
            this.remoteWebDriver = Eyes.this.driver.getRemoteWebDriver();
        }

        public String getSeleniumSessionId() {
            return this.remoteWebDriver.getSessionId().toString();
        }

        public WebDriverInfo getWebDriver() {
            return new WebDriverInfo();
        }

        public double getDevicePixelRatio() {
            return Eyes.this.getDevicePixelRatio();
        }

        public String getCutProvider() {
            return ((CutProvider)Eyes.this.cutProviderHandler.get()).getClass().getName();
        }

        public String getScaleProvider() {
            return ((ScaleProvider)Eyes.this.scaleProviderHandler.get()).getClass().getName();
        }

        public StitchMode getStitchMode() {
            return Eyes.this.getStitchMode();
        }

        public boolean getHideScrollbars() {
            return Eyes.this.getHideScrollbars();
        }

        public boolean getForceFullPageScreenshot() {
            return Eyes.this.getForceFullPageScreenshot();
        }

        class WebDriverInfo {
            WebDriverInfo() {
            }

            public String getName() {
                return EyesSeleniumAgentSetup.this.remoteWebDriver.getClass().getName();
            }

            public Capabilities getCapabilities() {
                return EyesSeleniumAgentSetup.this.remoteWebDriver.getCapabilities();
            }
        }
    }

    public static interface WebDriverAction {
        public void drive(WebDriver var1);
    }
}

