/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.IDownloadListener;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.selenium.Eyes;
import com.applitools.eyes.selenium.positioning.ElementPositionProvider;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriterSettings;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Phaser;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class DomCapture {
    private static String CAPTURE_FRAME_SCRIPT;
    private static String CAPTURE_CSSOM_SCRIPT;
    private final Phaser treePhaser = new Phaser(1);
    private final Phaser mainPhaser = new Phaser(1);
    private static IServerConnector mServerConnector;
    private WebDriver mDriver;
    private final Logger mLogger;
    private Stack<Integer> frameIndices = new Stack();

    public DomCapture(Eyes eyes) {
        mServerConnector = eyes.getServerConnector();
        this.mLogger = eyes.getLogger();
    }

    public String getFullWindowDom(WebDriver driver, ElementPositionProvider positionProvider) {
        this.mDriver = driver;
        Location initialPosition = positionProvider.getCurrentPosition();
        positionProvider.setPosition(Location.ZERO);
        Map<String, Object> dom = this.GetWindowDom();
        positionProvider.setPosition(initialPosition);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString(dom);
            return json;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public Map<String, Object> GetWindowDom() {
        Map argsObj = this.initMapDom();
        Map<String, Object> result = this.getFrameDom_(argsObj);
        return result;
    }

    private Map initMapDom() {
        HashMap<String, String[]> argsObj = new HashMap<String, String[]>();
        argsObj.put("styleProps", new String[]{"background-color", "background-image", "background-size", "color", "border-width", "border-color", "border-style", "padding", "margin"});
        argsObj.put("attributeProps", null);
        argsObj.put("rectProps", new String[]{"right", "bottom", "height", "width", "top", "left"});
        argsObj.put("ignoredTagNames", new String[]{"HEAD", "SCRIPT"});
        return argsObj;
    }

    private Map<String, Object> getFrameDom_(Map<String, Object> argsObj) {
        Map<String, Object> executeScriptMap;
        this.mLogger.verbose("Trying to get DOM from mDriver");
        long startingTime = System.currentTimeMillis();
        String executeScripString = (String)((JavascriptExecutor)this.mDriver).executeScript(CAPTURE_FRAME_SCRIPT, new Object[]{argsObj});
        this.mLogger.verbose("Finished capturing DOM in - " + (System.currentTimeMillis() - startingTime));
        startingTime = System.currentTimeMillis();
        try {
            executeScriptMap = this.parseStringToMap(executeScripString);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this.mLogger.verbose("Finished converting DOM map in - " + (System.currentTimeMillis() - startingTime));
        startingTime = System.currentTimeMillis();
        try {
            this.traverseDomTree(this.mDriver, argsObj, executeScriptMap, -1, new URL(this.mDriver.getCurrentUrl()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.mainPhaser.arriveAndAwaitAdvance();
        this.mLogger.verbose("Finished going over DOM CSS in - " + (System.currentTimeMillis() - startingTime));
        return executeScriptMap;
    }

    private void traverseDomTree(WebDriver mDriver, Map<String, Object> argsObj, final Map<String, Object> domTree, int frameIndex, URL baseUrl) {
        this.mLogger.verbose("DomCapture.traverseDomTree  baseUrl - " + baseUrl);
        Map<String, Object> dom = null;
        Object tagNameObj = domTree.get("tagName");
        boolean frameHasContent = true;
        if (null == tagNameObj) {
            return;
        }
        if (frameIndex > -1) {
            try {
                mDriver.switchTo().frame(frameIndex);
                this.frameIndices.push(0);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Exception)e);
                mDriver.switchTo().parentFrame();
                return;
            }
            String srcUrl = null;
            Object childNodes = domTree.get("childNodes");
            List childNodesAsMap = null;
            if (childNodes != null) {
                childNodesAsMap = (List)childNodes;
            }
            if (childNodesAsMap == null || childNodesAsMap.isEmpty()) {
                Map attrsNode;
                Object srcUrlObj;
                String json = (String)((JavascriptExecutor)mDriver).executeScript(CAPTURE_FRAME_SCRIPT, new Object[]{argsObj});
                try {
                    dom = this.parseStringToMap(json);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                frameHasContent = false;
                domTree.put("childNodes", new Object[]{dom});
                Object attrsNodeObj = domTree.get("attributes");
                if (null != attrsNodeObj && null != (srcUrlObj = (attrsNode = (Map)attrsNodeObj).get("src"))) {
                    srcUrl = (String)srcUrlObj;
                }
                if (srcUrl == null) {
                    this.mLogger.log("WARNING! IFRAME WITH NO SRC");
                }
                try {
                    if (srcUrl.contains("img.bbystatic.com/BestBuy_US/js/tracking/ens-index.html")) {
                        this.mLogger.verbose("sgfwgsdgsdfg");
                    }
                    URL urlHref = new URL(baseUrl, srcUrl);
                    this.traverseDomTree(mDriver, argsObj, dom, -1, urlHref);
                }
                catch (MalformedURLException e) {
                    GeneralUtils.logExceptionStackTrace((Exception)e);
                }
            }
            this.frameIndices.pop();
            mDriver.switchTo().parentFrame();
        }
        if (frameHasContent) {
            String tagName = (String)tagNameObj;
            boolean isHTML = tagName.equalsIgnoreCase("HTML");
            if (isHTML) {
                this.mainPhaser.register();
                this.getFrameBundledCss(baseUrl, new IDownloadListener(){

                    public void onDownloadComplete(String downloadedString) {
                        domTree.put("css", downloadedString);
                        DomCapture.this.mLogger.verbose("Putting css in  - CSS = " + downloadedString);
                        DomCapture.this.mainPhaser.arriveAndDeregister();
                    }

                    public void onDownloadFailed() {
                        DomCapture.this.mLogger.verbose("mainPhaser.arriveAndDeregister()");
                        DomCapture.this.mainPhaser.arriveAndDeregister();
                    }
                });
                this.mLogger.verbose("Finish getFrameBundledCss(baseUrl)");
            }
            this.loop(mDriver, argsObj, domTree, baseUrl);
        }
    }

    private void loop(WebDriver mDriver, Map<String, Object> argsObj, Map<String, Object> domTree, URL baseUrl) {
        this.mLogger.verbose("DomCapture.loop");
        Object childNodesObj = domTree.get("childNodes");
        int index = 0;
        index = -1;
        if (this.frameIndices.size() > 0) {
            index = this.frameIndices.peek();
        }
        if (!(childNodesObj instanceof List)) {
            return;
        }
        List childNodes = (List)childNodesObj;
        for (Object node : childNodes) {
            if (!(node instanceof Map)) continue;
            Map domSubTree = (Map)node;
            this.mLogger.verbose("Current DOM subtree hash : " + domSubTree.hashCode());
            Object tagNameObj = domSubTree.get("tagName");
            String tagName = (String)tagNameObj;
            boolean isIframe = tagName.equalsIgnoreCase("IFRAME");
            if (isIframe) {
                if (this.frameIndices.size() > 0) {
                    this.frameIndices.pop();
                } else {
                    this.mLogger.verbose("frameIndices size is 0");
                }
                this.frameIndices.push(index + 1);
                this.traverseDomTree(mDriver, argsObj, domSubTree, index, baseUrl);
                ++index;
                continue;
            }
            Object childSubNodesObj = domSubTree.get("childNodes");
            if (childSubNodesObj == null || childSubNodesObj instanceof List && ((List)childSubNodesObj).isEmpty()) continue;
            this.traverseDomTree(mDriver, argsObj, domSubTree, -1, baseUrl);
        }
        this.mLogger.verbose("DomCapture.loop - finish");
    }

    private void getFrameBundledCss(URL baseUrl, IDownloadListener listener) {
        URI uri = URI.create(baseUrl.toString());
        if (!uri.isAbsolute()) {
            this.mLogger.log("WARNING! Base URL is not an absolute URL!");
        }
        CssTreeNode root = new CssTreeNode();
        root.setBaseUrl(baseUrl);
        List result = (List)((JavascriptExecutor)this.mDriver).executeScript(CAPTURE_CSSOM_SCRIPT, new Object[0]);
        ArrayList<CssTreeNode> nodes = new ArrayList<CssTreeNode>();
        for (String item : result) {
            String kind = item.substring(0, 5);
            String value = item.substring(5);
            if (kind.equalsIgnoreCase("text:")) {
                this.parseCSS(root, value);
                root.downloadNodeCss();
                continue;
            }
            final CssTreeNode cssTreeNode = new CssTreeNode();
            cssTreeNode.setBaseUrl(root.baseUrl);
            cssTreeNode.setUrlPostfix(value);
            this.downloadCss(cssTreeNode, new IDownloadListener(){

                public void onDownloadComplete(String downloadedString) {
                    DomCapture.this.mLogger.verbose("DomCapture.onDownloadComplete");
                    DomCapture.this.parseCSS(cssTreeNode, downloadedString);
                    if (!cssTreeNode.allImportRules.isEmpty()) {
                        cssTreeNode.downloadNodeCss();
                    }
                }

                public void onDownloadFailed() {
                    DomCapture.this.mLogger.verbose("DomCapture.onDownloadFailed");
                }
            });
            nodes.add(cssTreeNode);
        }
        root.setDecedents(nodes);
        this.treePhaser.arriveAndAwaitAdvance();
        listener.onDownloadComplete(root.calcCss());
    }

    private void downloadCss(final CssTreeNode node, final IDownloadListener listener) {
        this.treePhaser.register();
        this.mLogger.verbose("Given URL to download: " + node.urlPostfix);
        mServerConnector.downloadString(node.urlPostfix, false, new IDownloadListener(){

            public void onDownloadComplete(String downloadedString) {
                DomCapture.this.mLogger.verbose("Download Complete");
                listener.onDownloadComplete(downloadedString);
                DomCapture.this.treePhaser.arriveAndDeregister();
                DomCapture.this.mLogger.verbose("treePhaser.arriveAndDeregister(); " + node.urlPostfix);
                DomCapture.this.mLogger.verbose("current unarrived  - " + DomCapture.this.treePhaser.getUnarrivedParties());
            }

            public void onDownloadFailed() {
                DomCapture.this.treePhaser.arriveAndDeregister();
                DomCapture.this.mLogger.verbose("Download Faild");
                DomCapture.this.mLogger.verbose("treePhaser.arriveAndDeregister(); " + node.urlPostfix);
                DomCapture.this.mLogger.verbose("current unarrived  - " + DomCapture.this.treePhaser.getUnarrivedParties());
            }
        });
    }

    private void parseCSS(CssTreeNode node, String css) {
        if (css == null) {
            return;
        }
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString((String)css, (ECSSVersion)ECSSVersion.CSS30);
        if (cascadingStyleSheet == null) {
            return;
        }
        ICommonsList allRules = cascadingStyleSheet.getAllRules();
        if (allRules == null) {
            return;
        }
        CascadingStyleSheet aCSS = CSSReader.readFromString((String)css, (ECSSVersion)ECSSVersion.CSS30);
        ICommonsList allImportRules = aCSS.getAllImportRules();
        node.setAllImportRules((ICommonsList<CSSImportRule>)allImportRules);
        node.setAllStyleRules((ICommonsList<CSSStyleRule>)aCSS.getAllStyleRules());
    }

    private Map<String, Object> parseStringToMap(String executeScripString) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map executeScriptMap = (Map)mapper.readValue(executeScripString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return executeScriptMap;
    }

    static {
        try {
            CAPTURE_FRAME_SCRIPT = GeneralUtils.readToEnd((InputStream)DomCapture.class.getResourceAsStream("/captureframe.js"));
            CAPTURE_CSSOM_SCRIPT = GeneralUtils.readToEnd((InputStream)DomCapture.class.getResourceAsStream("/capturecssom.js"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mServerConnector = null;
    }

    class CssTreeNode {
        URL baseUrl;
        URL urlPostfix;
        StringBuilder sb = new StringBuilder();
        List<CssTreeNode> decedents = new ArrayList<CssTreeNode>();
        ICommonsList<CSSImportRule> allImportRules;
        ICommonsList<CSSStyleRule> styleRules;

        CssTreeNode() {
        }

        public void setDecedents(List<CssTreeNode> decedents) {
            this.decedents = decedents;
        }

        public void setBaseUrl(URL baseUri) {
            this.baseUrl = baseUri;
        }

        String calcCss() {
            if (this.decedents != null) {
                for (CssTreeNode decedent : this.decedents) {
                    this.sb.append(decedent.calcCss());
                }
            }
            if (this.styleRules != null) {
                for (CSSStyleRule styleRule : this.styleRules) {
                    this.sb.append(styleRule.getAsCSSString((ICSSWriterSettings)new CSSWriterSettings()));
                }
            }
            return this.sb.toString();
        }

        void downloadNodeCss() {
            if (this.allImportRules != null) {
                for (CSSImportRule importRule : this.allImportRules) {
                    final CssTreeNode cssTreeNode = new CssTreeNode();
                    cssTreeNode.setBaseUrl(this.baseUrl);
                    String uri = importRule.getLocation().getURI();
                    cssTreeNode.setUrlPostfix(uri);
                    DomCapture.this.downloadCss(cssTreeNode, new IDownloadListener(){

                        public void onDownloadComplete(String downloadedString) {
                            DomCapture.this.parseCSS(cssTreeNode, downloadedString);
                            if (!cssTreeNode.allImportRules.isEmpty()) {
                                cssTreeNode.downloadNodeCss();
                            }
                        }

                        public void onDownloadFailed() {
                            DomCapture.this.mLogger.verbose("Download Failed");
                        }
                    });
                    this.decedents.add(cssTreeNode);
                }
            }
        }

        public void setUrlPostfix(String urlPostfix) {
            boolean absolute = false;
            try {
                absolute = new URI(urlPostfix).isAbsolute();
                this.urlPostfix = absolute ? new URL(urlPostfix) : new URL(this.baseUrl, urlPostfix);
            }
            catch (MalformedURLException | URISyntaxException e) {
                GeneralUtils.logExceptionStackTrace((Exception)e);
            }
        }

        public void setAllImportRules(ICommonsList<CSSImportRule> allImportRules) {
            this.allImportRules = allImportRules;
        }

        public void setAllStyleRules(ICommonsList<CSSStyleRule> allStyleRules) {
            this.styleRules = allStyleRules;
        }
    }
}

