/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.Logger;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.selenium.Eyes;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class FirefoxScreenshotImageProvider
implements ImageProvider {
    private final Eyes eyes;
    private final Logger logger;
    private final TakesScreenshot tsInstance;

    public FirefoxScreenshotImageProvider(Eyes eyes, Logger logger, TakesScreenshot tsInstance) {
        this.eyes = eyes;
        this.logger = logger;
        this.tsInstance = tsInstance;
    }

    public BufferedImage getImage() {
        EyesWebDriver eyesWebDriver = (EyesWebDriver)this.eyes.getDriver();
        FrameChain frameChain = eyesWebDriver.getFrameChain().clone();
        this.logger.verbose("frameChain size: " + frameChain.size());
        this.logger.verbose("Switching temporarily to default content.");
        eyesWebDriver.switchTo().defaultContent();
        this.logger.verbose("Getting screenshot as base64.");
        String screenshot64 = (String)this.tsInstance.getScreenshotAs(OutputType.BASE64);
        this.logger.verbose("Done getting base64! Creating BufferedImage...");
        BufferedImage image = ImageUtils.imageFromBase64((String)screenshot64);
        this.eyes.getDebugScreenshotsProvider().save(image, "FIREFOX");
        this.logger.verbose("Done. Switching back to original frame.");
        ((EyesTargetLocator)eyesWebDriver.switchTo()).frames(frameChain);
        return image;
    }
}

