/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.frames;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class Frame {
    private final WebElement reference;
    private final Location location;
    private final RectangleSize outerSize;
    private final RectangleSize innerSize;
    private final Location originalLocation;
    private final JavascriptExecutor jsExecutor;
    private final Logger logger;
    private WebElement scrollRootElement;
    private String originalOverflow;

    public Frame(Logger logger, WebElement reference, Location location, RectangleSize outerSize, RectangleSize innerSize, Location originalLocation, JavascriptExecutor jsExecutor) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)reference, (String)"reference");
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)outerSize, (String)"outerSize");
        ArgumentGuard.notNull((Object)innerSize, (String)"innerSize");
        ArgumentGuard.notNull((Object)originalLocation, (String)"originalLocation");
        ArgumentGuard.notNull((Object)jsExecutor, (String)"jsExecutor");
        logger.verbose(String.format("Frame(logger, reference, %s, %s, %s, %s)", location, outerSize, innerSize, originalLocation));
        this.logger = logger;
        this.reference = reference;
        this.location = location;
        this.outerSize = outerSize;
        this.innerSize = innerSize;
        this.originalLocation = originalLocation;
        this.jsExecutor = jsExecutor;
    }

    public WebElement getReference() {
        return this.reference;
    }

    public Location getLocation() {
        return this.location;
    }

    public RectangleSize getOuterSize() {
        return this.outerSize;
    }

    public RectangleSize getInnerSize() {
        return this.innerSize;
    }

    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    public WebElement getScrollRootElement() {
        return this.scrollRootElement;
    }

    public void hideScrollbars(WebDriver driver) {
        if (this.scrollRootElement == null) {
            this.logger.verbose("no scroll root element. selecting default.");
            this.scrollRootElement = driver.findElement(By.tagName((String)"html"));
        }
        this.logger.verbose("hiding scrollbars of element: " + this.scrollRootElement);
        this.originalOverflow = (String)this.jsExecutor.executeScript("var origOF = arguments[0].style.overflow; arguments[0].style.overflow='hidden'; return origOF;", new Object[]{this.scrollRootElement});
    }

    public void returnToOriginalOverflow(WebDriver driver) {
        if (this.scrollRootElement == null) {
            this.logger.verbose("no scroll root element. selecting default.");
            this.scrollRootElement = driver.findElement(By.tagName((String)"html"));
        }
        this.logger.verbose("returning overflow of element to its original value: " + this.scrollRootElement);
        this.jsExecutor.executeScript("arguments[0].style.overflow='" + this.originalOverflow + "';", new Object[]{this.scrollRootElement});
    }
}

