/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionMemento;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;

public class CssTranslatePositionProvider
implements PositionProvider {
    protected final Logger logger;
    protected final IEyesJsExecutor executor;
    private final WebElement scrollRootElement;
    private Location lastSetPosition;

    public CssTranslatePositionProvider(Logger logger, IEyesJsExecutor executor, WebElement scrollRootElement) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        ArgumentGuard.notNull((Object)scrollRootElement, (String)"scrollRootElement");
        this.logger = logger;
        this.executor = executor;
        this.scrollRootElement = scrollRootElement;
        logger.verbose("creating CssTranslatePositionProvider");
    }

    public Location getCurrentPosition() {
        this.logger.verbose("position to return: " + this.lastSetPosition);
        return this.lastSetPosition;
    }

    public void setPosition(Location location) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        this.logger.verbose("CssTranslatePositionProvider - Setting position to: " + location);
        EyesSeleniumUtils.translateTo(this.executor, location);
        this.logger.verbose("Done!");
        this.lastSetPosition = location;
    }

    public RectangleSize getEntireSize() {
        RectangleSize entireSize = EyesSeleniumUtils.getEntireElementSize(this.executor, this.scrollRootElement);
        this.logger.verbose("CssTranslatePositionProvider - Entire size: " + entireSize);
        return entireSize;
    }

    public PositionMemento getState() {
        return new CssTranslatePositionMemento(EyesSeleniumUtils.getCurrentTransform(this.executor), this.lastSetPosition);
    }

    public void restoreState(PositionMemento state) {
        EyesSeleniumUtils.setTransforms(this.executor, ((CssTranslatePositionMemento)state).getTransform());
        this.lastSetPosition = ((CssTranslatePositionMemento)state).getPosition();
    }
}

