/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.wrappers;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.Borders;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ArgumentGuard;
import java.util.List;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesTargetLocator
implements WebDriver.TargetLocator {
    private static Logger logger = null;
    private final EyesWebDriver driver;
    private final ScrollPositionProvider scrollPosition;
    private final WebDriver.TargetLocator targetLocator;
    private PositionMemento defaultContentPositionMemento;

    public static void initLogger(Logger logger) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        EyesTargetLocator.logger = logger;
    }

    private void willSwitchToFrame(WebElement targetFrame) {
        ArgumentGuard.notNull((Object)targetFrame, (String)"targetFrame");
        EyesRemoteWebElement eyesFrame = targetFrame instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)targetFrame : new EyesRemoteWebElement(logger, this.driver, targetFrame);
        Point pl = targetFrame.getLocation();
        Dimension ds = targetFrame.getSize();
        SizeAndBorders sizeAndBorders = eyesFrame.getSizeAndBorders();
        Borders borders = sizeAndBorders.getBorders();
        RectangleSize frameInnerSize = sizeAndBorders.getSize();
        Location contentLocation = new Location(pl.getX() + borders.getLeft(), pl.getY() + borders.getTop());
        Location originalLocation = this.scrollPosition.getCurrentPosition();
        Frame frame = new Frame(logger, targetFrame, contentLocation, new RectangleSize(ds.getWidth(), ds.getHeight()), frameInnerSize, originalLocation, this.driver);
        this.driver.getFrameChain().push(frame);
    }

    public EyesTargetLocator(EyesWebDriver driver, WebDriver.TargetLocator targetLocator) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)targetLocator, (String)"targetLocator");
        this.driver = driver;
        this.targetLocator = targetLocator;
        SeleniumJavaScriptExecutor jsExecutor = new SeleniumJavaScriptExecutor(driver);
        this.scrollPosition = new ScrollPositionProvider(logger, jsExecutor);
    }

    public WebDriver frame(int index) {
        logger.verbose(String.format("(%d)", index));
        logger.verbose("Getting frames list...");
        List<WebElement> frames = this.driver.findElementsByCssSelector("frame, iframe");
        if (index > frames.size()) {
            throw new NoSuchFrameException(String.format("Frame index [%d] is invalid!", index));
        }
        logger.verbose("Done! getting the specific frame...");
        WebElement targetFrame = frames.get(index);
        logger.verbose("Done! Making preparations...");
        this.willSwitchToFrame(targetFrame);
        logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(index);
        logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frame(String nameOrId) {
        logger.verbose(String.format("('%s')", nameOrId));
        logger.verbose("Getting frames by name...");
        List<WebElement> frames = this.driver.findElementsByName(nameOrId);
        if (frames.size() == 0) {
            logger.verbose("No frames Found! Trying by id...");
            frames = this.driver.findElementsById(nameOrId);
            if (frames.size() == 0) {
                throw new NoSuchFrameException(String.format("No frame with name or id '%s' exists!", nameOrId));
            }
        }
        logger.verbose("Done! Making preparations...");
        this.willSwitchToFrame(frames.get(0));
        logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(nameOrId);
        logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frame(WebElement frameElement) {
        logger.verbose("Making preparations...");
        this.willSwitchToFrame(frameElement);
        logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(frameElement);
        logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver parentFrame() {
        logger.verbose("enter");
        if (this.driver.getFrameChain().size() != 0) {
            logger.verbose("Making preparations...");
            this.driver.getFrameChain().pop();
            logger.verbose("Done! Switching to parent frame...");
            EyesTargetLocator.parentFrame(this.targetLocator, this.driver.getFrameChain());
        }
        logger.verbose("Done!");
        return this.driver;
    }

    public static void parentFrame(WebDriver.TargetLocator targetLocator, FrameChain frameChainToParent) {
        logger.verbose("enter (static)");
        try {
            targetLocator.parentFrame();
        }
        catch (Exception WebDriverException) {
            targetLocator.defaultContent();
            for (Frame frame : frameChainToParent) {
                targetLocator.frame(frame.getReference());
            }
        }
    }

    public WebDriver framesDoScroll(FrameChain frameChain) {
        logger.verbose("enter");
        this.driver.switchTo().defaultContent();
        this.defaultContentPositionMemento = this.scrollPosition.getState();
        for (Frame frame : frameChain) {
            logger.verbose("Scrolling by parent scroll position...");
            Location frameLocation = frame.getLocation();
            this.scrollPosition.setPosition(frameLocation);
            logger.verbose("Done! Switching to frame...");
            this.driver.switchTo().frame(frame.getReference());
            logger.verbose("Done!");
        }
        logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver frames(FrameChain frameChain) {
        logger.verbose("enter");
        this.driver.switchTo().defaultContent();
        for (Frame frame : frameChain) {
            this.driver.switchTo().frame(frame.getReference());
        }
        logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver frames(String[] framesPath) {
        logger.verbose("enter");
        for (String frameNameOrId : framesPath) {
            logger.verbose("Switching to frame...");
            this.driver.switchTo().frame(frameNameOrId);
            logger.verbose("Done!");
        }
        logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver window(String nameOrHandle) {
        logger.verbose("enter");
        this.driver.getFrameChain().clear();
        logger.verbose("Done! Switching to window...");
        this.targetLocator.window(nameOrHandle);
        logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver defaultContent() {
        logger.verbose("enter");
        if (this.driver.getFrameChain().size() != 0) {
            logger.verbose("Making preparations...");
            this.driver.getFrameChain().clear();
            logger.verbose("Done! Switching to default content...");
        }
        this.targetLocator.defaultContent();
        logger.verbose("Done!");
        return this.driver;
    }

    public WebElement activeElement() {
        logger.verbose("Switching to element...");
        WebElement element = this.targetLocator.activeElement();
        if (!(element instanceof RemoteWebElement)) {
            throw new EyesException("Not a remote web element!");
        }
        EyesRemoteWebElement result = new EyesRemoteWebElement(logger, this.driver, element);
        logger.verbose("Done!");
        return result;
    }

    public Alert alert() {
        logger.verbose("Switching to alert...");
        Alert result = this.targetLocator.alert();
        logger.verbose("Done!");
        return result;
    }

    public void resetScroll() {
        logger.verbose("enter");
        if (this.defaultContentPositionMemento != null) {
            this.scrollPosition.restoreState(this.defaultContentPositionMemento);
        }
    }
}

