/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.wrappers;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.selenium.AppiumJsCommandExtractor;
import com.applitools.eyes.selenium.Eyes;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.triggers.EyesKeyboard;
import com.applitools.eyes.selenium.triggers.EyesMouse;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesTouchScreen;
import com.applitools.eyes.triggers.MouseTrigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesWebDriver
implements HasCapabilities,
HasInputDevices,
FindsByClassName,
FindsByCssSelector,
FindsById,
FindsByLinkText,
FindsByName,
FindsByTagName,
FindsByXPath,
JavascriptExecutor,
SearchContext,
TakesScreenshot,
WebDriver,
HasTouchScreen {
    private final Logger logger;
    private final Eyes eyes;
    private final RemoteWebDriver driver;
    private final TouchScreen touch;
    private final Map<String, WebElement> elementsIds;
    private final FrameChain frameChain;
    private ImageRotation rotation;
    private RectangleSize defaultContentViewportSize;

    public static BufferedImage normalizeRotation(Logger logger, WebDriver driver, BufferedImage image, ImageRotation rotation) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)image, (String)"image");
        BufferedImage normalizedImage = image;
        if (rotation != null) {
            if (rotation.getRotation() != 0) {
                normalizedImage = ImageUtils.rotateImage((BufferedImage)image, (double)rotation.getRotation());
            }
        } else {
            try {
                logger.verbose("Trying to automatically normalize rotation...");
                if (EyesSeleniumUtils.isMobileDevice(driver) && EyesSeleniumUtils.isLandscapeOrientation(logger, driver) && image.getHeight() > image.getWidth()) {
                    int degrees = EyesSeleniumUtils.isAndroid(driver) ? 90 : -90;
                    normalizedImage = ImageUtils.rotateImage((BufferedImage)image, (double)degrees);
                }
            }
            catch (Exception e) {
                logger.verbose("Got exception: " + e.getMessage());
                logger.verbose("Skipped automatic rotation handling.");
            }
        }
        return normalizedImage;
    }

    public EyesWebDriver(Logger logger, Eyes eyes, RemoteWebDriver driver) throws EyesException {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)((Object)eyes), (String)"eyes");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.logger = logger;
        this.eyes = eyes;
        this.driver = driver;
        this.elementsIds = new HashMap<String, WebElement>();
        this.frameChain = new FrameChain(logger);
        this.defaultContentViewportSize = null;
        RemoteExecuteMethod executeMethod = null;
        try {
            executeMethod = new RemoteExecuteMethod(driver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.touch = null != executeMethod ? new EyesTouchScreen(logger, this, (TouchScreen)new RemoteTouchScreen((ExecuteMethod)executeMethod)) : null;
        logger.verbose("Driver session is " + this.getSessionId());
    }

    public Eyes getEyes() {
        return this.eyes;
    }

    public RemoteWebDriver getRemoteWebDriver() {
        return this.driver;
    }

    public TouchScreen getTouch() {
        return this.touch;
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
    }

    public void get(String s) {
        this.frameChain.clear();
        this.driver.get(s);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        List foundWebElementsList = this.driver.findElements(by);
        ArrayList<WebElement> resultElementsList = new ArrayList<WebElement>(foundWebElementsList.size());
        for (WebElement currentElement : foundWebElementsList) {
            if (currentElement instanceof RemoteWebElement) {
                resultElementsList.add((WebElement)new EyesRemoteWebElement(this.logger, this, (WebElement)((RemoteWebElement)currentElement)));
                this.elementsIds.put(((RemoteWebElement)currentElement).getId(), currentElement);
                continue;
            }
            throw new EyesException(String.format("findElements: element is not a RemoteWebElement: %s", by));
        }
        return resultElementsList;
    }

    public WebElement findElement(By by) {
        Object webElement = this.driver.findElement(by);
        if (!(webElement instanceof RemoteWebElement)) {
            throw new EyesException("findElement: Element is not a RemoteWebElement: " + by);
        }
        webElement = new EyesRemoteWebElement(this.logger, this, (WebElement)webElement);
        this.elementsIds.put(((RemoteWebElement)webElement).getId(), (WebElement)webElement);
        return webElement;
    }

    public Map<String, WebElement> getElementIds() {
        return this.elementsIds;
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return new EyesTargetLocator(this, this.driver.switchTo());
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public Mouse getMouse() {
        return new EyesMouse(this.logger, this, this.driver.getMouse());
    }

    public Keyboard getKeyboard() {
        return new EyesKeyboard(this.logger, this, this.driver.getKeyboard());
    }

    public WebElement findElementByClassName(String className) {
        return this.findElement(By.className((String)className));
    }

    public List<WebElement> findElementsByClassName(String className) {
        return this.findElements(By.className((String)className));
    }

    public WebElement findElementByCssSelector(String cssSelector) {
        return this.findElement(By.cssSelector((String)cssSelector));
    }

    public List<WebElement> findElementsByCssSelector(String cssSelector) {
        return this.findElements(By.cssSelector((String)cssSelector));
    }

    public WebElement findElementById(String id) {
        return this.findElement(By.id((String)id));
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElements(By.id((String)id));
    }

    public WebElement findElementByLinkText(String linkText) {
        return this.findElement(By.linkText((String)linkText));
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        return this.findElements(By.linkText((String)linkText));
    }

    public WebElement findElementByPartialLinkText(String partialLinkText) {
        return this.findElement(By.partialLinkText((String)partialLinkText));
    }

    public List<WebElement> findElementsByPartialLinkText(String partialLinkText) {
        return this.findElements(By.partialLinkText((String)partialLinkText));
    }

    public WebElement findElementByName(String name) {
        return this.findElement(By.name((String)name));
    }

    public List<WebElement> findElementsByName(String name) {
        return this.findElements(By.name((String)name));
    }

    public WebElement findElementByTagName(String tagName) {
        return this.findElement(By.tagName((String)tagName));
    }

    public List<WebElement> findElementsByTagName(String tagName) {
        return this.findElements(By.tagName((String)tagName));
    }

    public WebElement findElementByXPath(String path) {
        return this.findElement(By.xpath((String)path));
    }

    public List<WebElement> findElementsByXPath(String path) {
        return this.findElements(By.xpath((String)path));
    }

    public Capabilities getCapabilities() {
        return this.driver.getCapabilities();
    }

    public Object executeScript(String script, Object ... args) {
        Trigger trigger;
        if (AppiumJsCommandExtractor.isAppiumJsCommand(script) && (trigger = AppiumJsCommandExtractor.extractTrigger(this.elementsIds, this.driver.manage().window().getSize(), script, args)) != null && trigger instanceof MouseTrigger) {
            MouseTrigger mt = (MouseTrigger)trigger;
            this.eyes.addMouseTrigger(mt.getMouseAction(), mt.getControl(), mt.getLocation());
        }
        Object result = this.driver.executeScript(script, args);
        return result;
    }

    public Object executeAsyncScript(String script, Object ... args) {
        Trigger trigger;
        if (AppiumJsCommandExtractor.isAppiumJsCommand(script) && (trigger = AppiumJsCommandExtractor.extractTrigger(this.elementsIds, this.driver.manage().window().getSize(), script, args)) != null && trigger instanceof MouseTrigger) {
            MouseTrigger mt = (MouseTrigger)trigger;
            this.eyes.addMouseTrigger(mt.getMouseAction(), mt.getControl(), mt.getLocation());
        }
        return this.driver.executeAsyncScript(script, args);
    }

    public RectangleSize getDefaultContentViewportSize(boolean forceQuery) {
        this.logger.verbose("getDefaultContentViewportSize(forceQuery: " + forceQuery + ")");
        if (this.defaultContentViewportSize != null && !forceQuery) {
            this.logger.verbose("Using cached viewport size: " + this.defaultContentViewportSize);
            return this.defaultContentViewportSize;
        }
        EyesTargetLocator switchTo = (EyesTargetLocator)this.switchTo();
        FrameChain currentFrames = this.getFrameChain().clone();
        if (currentFrames.size() > 0) {
            switchTo.defaultContent();
        }
        this.logger.verbose("Extracting viewport size...");
        this.defaultContentViewportSize = EyesSeleniumUtils.getViewportSizeOrDisplaySize(this.logger, this);
        this.logger.verbose("Done! Viewport size: " + this.defaultContentViewportSize);
        if (currentFrames.size() > 0) {
            switchTo.frames(currentFrames);
        }
        return this.defaultContentViewportSize;
    }

    public RectangleSize getDefaultContentViewportSize() {
        return this.getDefaultContentViewportSize(true);
    }

    public FrameChain getFrameChain() {
        return this.frameChain;
    }

    public <X> X getScreenshotAs(OutputType<X> xOutputType) throws WebDriverException {
        String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
        BufferedImage screenshot = ImageUtils.imageFromBase64((String)screenshot64);
        screenshot = EyesWebDriver.normalizeRotation(this.logger, (WebDriver)this.driver, screenshot, this.rotation);
        screenshot64 = ImageUtils.base64FromImage((BufferedImage)screenshot);
        return (X)xOutputType.convertFromBase64Png(screenshot64);
    }

    public String getUserAgent() {
        String userAgent;
        try {
            userAgent = (String)this.driver.executeScript("return navigator.userAgent", new Object[0]);
            this.logger.verbose("user agent: " + userAgent);
        }
        catch (Exception e) {
            this.logger.verbose("Failed to obtain user-agent string");
            userAgent = null;
        }
        return userAgent;
    }

    private String getSessionId() {
        return this.driver.getSessionId().toString();
    }
}

