/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.EyesScreenshotFactory;
import com.applitools.eyes.ImageProvider;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.PositionMemento;
import com.applitools.eyes.PositionProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RegionProvider;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.selenium.EyesDriverOperationException;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class FullPageCaptureAlgorithm {
    private static final int MAX_SCROLL_BAR_SIZE = 50;
    private static final int MIN_SCREENSHOT_PART_HEIGHT = 10;
    private final Logger logger;

    public FullPageCaptureAlgorithm(Logger logger) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public BufferedImage getStitchedRegion(ImageProvider imageProvider, RegionProvider regionProvider, PositionProvider originProvider, PositionProvider positionProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, int waitBeforeScreenshots, EyesScreenshotFactory screenshotFactory) {
        RectangleSize entireSize;
        Location currentPosition;
        this.logger.verbose("getStitchedRegion()");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        ArgumentGuard.notNull((Object)positionProvider, (String)"positionProvider");
        this.logger.verbose(String.format("Region to check: %s", regionProvider.getRegion()));
        this.logger.verbose(String.format("Coordinates type: %s", regionProvider.getCoordinatesType()));
        int SCALE_MARGIN_PX = 5;
        PositionMemento originalPosition = originProvider.getState();
        int setPositionRetries = 3;
        do {
            originProvider.setPosition(new Location(0, 0));
            GeneralUtils.sleep((long)waitBeforeScreenshots);
        } while ((currentPosition = originProvider.getCurrentPosition()).getX() != 0 && currentPosition.getY() != 0 && --setPositionRetries > 0);
        if (currentPosition.getX() != 0 || currentPosition.getY() != 0) {
            originProvider.restoreState(originalPosition);
            throw new EyesException("Couldn't set position to the top/left corner!");
        }
        this.logger.verbose("Getting top/left image...");
        BufferedImage image = imageProvider.getImage();
        ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(image.getWidth());
        double pixelRatio = 1.0 / scaleProvider.getScaleRatio();
        cutProvider = cutProvider.scale(pixelRatio);
        image = cutProvider.cut(image);
        this.logger.verbose("Done! Creating screenshot object...");
        EyesScreenshot screenshot = screenshotFactory.makeScreenshot(image);
        this.logger.verbose("Done! Getting region in screenshot...");
        Region regionInScreenshot = screenshot.convertRegionLocation(regionProvider.getRegion(), regionProvider.getCoordinatesType(), CoordinatesType.SCREENSHOT_AS_IS);
        this.logger.verbose("Done! Region in screenshot: " + regionInScreenshot);
        regionInScreenshot = regionInScreenshot.scale(pixelRatio);
        this.logger.verbose("Scaled region: " + regionInScreenshot);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.verbose("Region after intersect: " + regionInScreenshot);
        if (!regionInScreenshot.isEmpty()) {
            image = ImageUtils.getImagePart((BufferedImage)image, (Region)regionInScreenshot);
        }
        image = ImageUtils.scaleImage((BufferedImage)image, (ScaleProvider)scaleProvider);
        try {
            entireSize = positionProvider.getEntireSize();
            this.logger.verbose("Entire size of region context: " + entireSize);
        }
        catch (EyesDriverOperationException e) {
            this.logger.log("WARNING: Failed to extract entire size of region context" + e.getMessage());
            this.logger.log("Using image size instead: " + image.getWidth() + "x" + image.getHeight());
            entireSize = new RectangleSize(image.getWidth(), image.getHeight());
        }
        if (image.getWidth() >= entireSize.getWidth() && image.getHeight() >= entireSize.getHeight()) {
            originProvider.restoreState(originalPosition);
            return image;
        }
        RectangleSize partImageSize = new RectangleSize(image.getWidth(), Math.max(image.getHeight() - 50, 10));
        this.logger.verbose(String.format("Total size: %s, image part size: %s", entireSize, partImageSize));
        Region entirePage = new Region(Location.ZERO, entireSize);
        Iterable imageParts = entirePage.getSubRegions(partImageSize);
        this.logger.verbose("Creating stitchedImage container. Size: " + entireSize);
        BufferedImage stitchedImage = new BufferedImage(entireSize.getWidth(), entireSize.getHeight(), image.getType());
        this.logger.verbose("Done! Adding initial screenshot..");
        Raster initialPart = image.getData();
        this.logger.verbose(String.format("Initial part:(0,0)[%d x %d]", initialPart.getWidth(), initialPart.getHeight()));
        stitchedImage.getRaster().setRect(0, 0, initialPart);
        this.logger.verbose("Done!");
        Location lastSuccessfulLocation = new Location(0, 0);
        RectangleSize lastSuccessfulPartSize = new RectangleSize(initialPart.getWidth(), initialPart.getHeight());
        PositionMemento originalStitchedState = positionProvider.getState();
        this.logger.verbose("Getting the rest of the image parts...");
        BufferedImage partImage = null;
        for (Region partRegion : imageParts) {
            if (partRegion.getLeft() == 0 && partRegion.getTop() == 0) continue;
            this.logger.verbose(String.format("Taking screenshot for %s", partRegion));
            positionProvider.setPosition(partRegion.getLocation());
            GeneralUtils.sleep((long)waitBeforeScreenshots);
            currentPosition = positionProvider.getCurrentPosition();
            this.logger.verbose(String.format("Set position to %s", currentPosition));
            this.logger.verbose("Getting image...");
            partImage = imageProvider.getImage();
            partImage = cutProvider.cut(partImage);
            this.logger.verbose("Done!");
            if (!regionInScreenshot.isEmpty()) {
                partImage = ImageUtils.getImagePart((BufferedImage)partImage, (Region)regionInScreenshot);
            }
            partImage = ImageUtils.scaleImage((BufferedImage)partImage, (ScaleProvider)scaleProvider);
            this.logger.verbose("Stitching part into the image container...");
            stitchedImage.getRaster().setRect(currentPosition.getX(), currentPosition.getY(), partImage.getData());
            this.logger.verbose("Done!");
            lastSuccessfulLocation = currentPosition;
        }
        if (partImage != null) {
            lastSuccessfulPartSize = new RectangleSize(partImage.getWidth(), partImage.getHeight());
        }
        this.logger.verbose("Stitching done!");
        positionProvider.restoreState(originalStitchedState);
        originProvider.restoreState(originalPosition);
        int actualImageWidth = lastSuccessfulLocation.getX() + lastSuccessfulPartSize.getWidth();
        int actualImageHeight = lastSuccessfulLocation.getY() + lastSuccessfulPartSize.getHeight();
        this.logger.verbose("Extracted entire size: " + entireSize);
        this.logger.verbose("Actual stitched size: " + actualImageWidth + "x" + actualImageHeight);
        if (actualImageWidth < stitchedImage.getWidth() || actualImageHeight < stitchedImage.getHeight()) {
            this.logger.verbose("Trimming unnecessary margins..");
            stitchedImage = ImageUtils.getImagePart((BufferedImage)stitchedImage, (Region)new Region(0, 0, actualImageWidth, actualImageHeight));
            this.logger.verbose("Done!");
        }
        return stitchedImage;
    }
}

