/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.ScaleProvider;
import com.applitools.utils.ArgumentGuard;

public class ContextBasedScaleProvider
implements ScaleProvider {
    private static final int ALLOWED_VS_DEVIATION = 1;
    private static final int ALLOWED_DCES_DEVIATION = 10;
    private static final int UNKNOWN_SCALE_RATIO = 0;
    private double scaleRatio;
    private double devicePixelRatio;
    private RectangleSize topLevelContextEntireSize;
    private RectangleSize viewportSize;

    public ContextBasedScaleProvider(RectangleSize topLevelContextEntireSize, RectangleSize viewportSize, double devicePixelRatio) {
        this.topLevelContextEntireSize = topLevelContextEntireSize;
        this.viewportSize = viewportSize;
        this.devicePixelRatio = devicePixelRatio;
        this.scaleRatio = 0.0;
    }

    public double getScaleRatio() {
        ArgumentGuard.isValidState((this.scaleRatio != 0.0 ? 1 : 0) != 0, (String)"scaleRatio not defined yet");
        return this.scaleRatio;
    }

    public void updateScaleRatio(int imageToScaleWidth) {
        int viewportWidth = this.viewportSize.getWidth();
        int dcesWidth = this.topLevelContextEntireSize.getWidth();
        this.scaleRatio = imageToScaleWidth >= viewportWidth - 1 && imageToScaleWidth <= viewportWidth + 1 || imageToScaleWidth >= dcesWidth - 10 && imageToScaleWidth <= dcesWidth + 10 ? 1.0 : 1.0 / this.devicePixelRatio;
    }
}

