/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.PositionMemento;
import com.applitools.eyes.PositionProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.selenium.EyesDriverOperationException;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.ScrollPositionMemento;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriverException;

public class ScrollPositionProvider
implements PositionProvider {
    protected final Logger logger;
    protected final JavascriptExecutor executor;

    public ScrollPositionProvider(Logger logger, JavascriptExecutor executor) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        this.logger = logger;
        this.executor = executor;
    }

    public Location getCurrentPosition() {
        Location result;
        this.logger.verbose("getCurrentScrollPosition()");
        try {
            result = EyesSeleniumUtils.getCurrentScrollPosition(this.executor);
        }
        catch (WebDriverException e) {
            throw new EyesDriverOperationException("Failed to extract current scroll position!");
        }
        this.logger.verbose(String.format("Current position: %s", result));
        return result;
    }

    public void setPosition(Location location) {
        this.logger.verbose(String.format("Scrolling to %s", location));
        EyesSeleniumUtils.setCurrentScrollPosition(this.executor, location);
        this.logger.verbose("Done scrolling!");
    }

    public RectangleSize getEntireSize() {
        RectangleSize result = EyesSeleniumUtils.getCurrentFrameContentEntireSize(this.executor);
        this.logger.verbose(String.format("Entire size: %s", result));
        return result;
    }

    public PositionMemento getState() {
        return new ScrollPositionMemento(this.getCurrentPosition());
    }

    public void restoreState(PositionMemento state) {
        ScrollPositionMemento s = (ScrollPositionMemento)state;
        this.setPosition(new Location(s.getX(), s.getY()));
    }
}

