/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.rendering;

import com.applitools.ICheckSettings;
import com.applitools.ICheckSettingsInternal;
import com.applitools.connectivity.Cookie;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.NullLogHandler;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.RunningTest;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.debug.FileDebugScreenshotsProvider;
import com.applitools.eyes.debug.NullDebugScreenshotProvider;
import com.applitools.eyes.dom.DomScriptUtils;
import com.applitools.eyes.dom.ScriptExecutor;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.selenium.ClassicRunner0;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.ISeleniumEyes;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.ISeleniumFrameCheckTarget;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.rendering.WebElementRegion;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.triggers.VisualGridRunner0;
import com.applitools.eyes.visualgrid.model.AttributeData;
import com.applitools.eyes.visualgrid.model.BlobData;
import com.applitools.eyes.visualgrid.model.DeviceSize;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.VisualGridOption;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.CheckTask;
import com.applitools.eyes.visualgrid.services.IEyes;
import com.applitools.eyes.visualgrid.services.VisualGridRunningTest;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.utils.URIBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class VisualGridEyes
implements ISeleniumEyes {
    private final Logger logger;
    private final String eyesId = UUID.randomUUID().toString();
    private final VisualGridRunner0 runner;
    final Map<String, RunningTest> testList = Collections.synchronizedMap(new HashMap());
    private boolean isOpen = false;
    private EyesSeleniumDriver webDriver;
    private String url;
    private Boolean isDisabled = Boolean.FALSE;
    private final ConfigurationProvider configurationProvider;
    private UserAgent userAgent = null;
    private RectangleSize viewportSize;
    private final List<PropertyData> properties = new ArrayList<PropertyData>();
    private ImageProvider imageProvider;
    private DebugScreenshotsProvider debugScreenshotsProvider = new NullDebugScreenshotProvider();
    private static final String GET_ELEMENT_XPATH_JS = "var el = arguments[0];var xpath = '';do { var parent = el.parentElement; var index = 1; if (parent !== null) {  var children = parent.children;  for (var childIdx in children) {    var child = children[childIdx];    if (child === el) break;    if (child.tagName === el.tagName) index++;  }}xpath = '/' + el.tagName + '[' + index + ']' + xpath; el = parent;} while (el !== null);return '/' + xpath;";

    public VisualGridEyes(VisualGridRunner0 renderingGridManager, ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        ArgumentGuard.notNull((Object)renderingGridManager, (String)"renderingGridRunner");
        this.runner = renderingGridManager;
        this.logger = renderingGridManager.getLogger();
    }

    public void setLogHandler(LogHandler logHandler) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        this.logger.setLogHandler(logHandler);
        if (!logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public LogHandler getLogHandler() {
        if (this.getIsDisabled().booleanValue()) {
            return NullLogHandler.instance;
        }
        return this.logger.getLogHandler();
    }

    public void apiKey(String apiKey) {
        this.setApiKey(apiKey);
    }

    public void serverUrl(String serverUrl) {
        this.setServerUrl(serverUrl);
    }

    public void setImageProvider(ImageProvider imageProvider) {
        this.imageProvider = imageProvider;
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        DebugScreenshotsProvider prev = this.debugScreenshotsProvider;
        this.debugScreenshotsProvider = saveDebugScreenshots ? new FileDebugScreenshotsProvider(this.logger) : new NullDebugScreenshotProvider();
        this.debugScreenshotsProvider.setPrefix(prev.getPrefix());
        this.debugScreenshotsProvider.setPath(prev.getPath());
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.debugScreenshotsProvider.setPath(pathToSave);
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.debugScreenshotsProvider.setPrefix(prefix);
    }

    @Override
    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) throws EyesException {
        this.logger.log(TraceLevel.Info, Collections.singleton(this.eyesId), Stage.OPEN, Type.CALLED, new Pair[]{Pair.of((Object)"appName", (Object)appName), Pair.of((Object)"testName", (Object)testName), Pair.of((Object)"viewportSize", (Object)(viewportSize == null ? "default" : viewportSize))});
        this.getConfiguration().setAppName(appName).setTestName(testName);
        if (viewportSize != null && !viewportSize.isEmpty()) {
            this.getConfiguration().setViewportSize(new RectangleSize(viewportSize));
        }
        return this.open(driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebDriver open(WebDriver webDriver) {
        if (this.getIsDisabled().booleanValue()) {
            return webDriver;
        }
        this.runner.setApiKey(this.getApiKey());
        this.runner.setServerUrl(this.getServerUrl().toString());
        this.runner.setProxy(this.getProxy());
        ArgumentGuard.notNull((Object)webDriver, (String)"webDriver");
        ArgumentGuard.notNullOrEmpty((String)this.getConfiguration().getAppName(), (String)"appIdOrName");
        ArgumentGuard.notNullOrEmpty((String)this.getConfiguration().getTestName(), (String)"scenarioIdOrName");
        if (this.isOpen) {
            return this.webDriver != null ? this.webDriver : webDriver;
        }
        this.isOpen = true;
        this.initDriver(webDriver);
        String uaString = this.webDriver.getUserAgent();
        if (uaString != null) {
            this.userAgent = UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        }
        this.setViewportSize(this.webDriver);
        this.ensureBrowsers();
        if (this.getConfiguration().getBatch() == null) {
            this.getConfiguration().setBatch(new BatchInfo(null));
        }
        List browserInfoList = this.getConfiguration().getBrowsersInfo();
        this.getConfiguration().setViewportSize(this.viewportSize);
        if (this.getConfiguration().getBrowsersInfo() == null) {
            RectangleSize viewportSize = this.getConfiguration().getViewportSize();
            this.getConfiguration().addBrowser(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, this.getConfiguration().getBaselineEnvName()));
        }
        if (this.runner.getAgentId() == null) {
            this.runner.setAgentId(this.getFullAgentId());
        }
        this.runner.setLogger(this.logger);
        ArrayList<VisualGridRunningTest> newTests = new ArrayList<VisualGridRunningTest>();
        ServerConnector serverConnector = this.runner.getServerConnector();
        String agentRunId = String.format("%s_%s", this.getConfiguration().getTestName(), UUID.randomUUID().toString());
        for (RenderBrowserInfo browserInfo : browserInfoList) {
            Map deviceSizes;
            if (browserInfo.getEmulationInfo() != null) {
                deviceSizes = serverConnector.getDevicesSizes("/emulated-devices-sizes");
                browserInfo.setEmulationDeviceSize((DeviceSize)deviceSizes.get(browserInfo.getEmulationInfo().getDeviceName()));
            }
            if (browserInfo.getIosDeviceInfo() != null) {
                deviceSizes = serverConnector.getDevicesSizes("/ios-devices-sizes");
                browserInfo.setIosDeviceSize((DeviceSize)deviceSizes.get(browserInfo.getIosDeviceInfo().getDeviceName()));
            }
            VisualGridRunningTest test = new VisualGridRunningTest(this.logger, this.eyesId, this.getConfiguration(), browserInfo, this.properties, serverConnector, agentRunId);
            this.testList.put(test.getTestId(), (RunningTest)test);
            newTests.add(test);
        }
        try {
            this.runner.open((IEyes)this, newTests);
        }
        catch (Throwable t) {
            Map<String, RunningTest> map = this.testList;
            synchronized (map) {
                for (RunningTest runningTest : this.testList.values()) {
                    runningTest.openFailed(t);
                }
            }
            throw t;
        }
        return this.webDriver != null ? this.webDriver : webDriver;
    }

    private void ensureBrowsers() {
        if (this.getConfiguration().getBrowsersInfo().isEmpty()) {
            this.getConfiguration().getBrowsersInfo().add(new RenderBrowserInfo(this.viewportSize, BrowserType.CHROME));
        }
    }

    void setViewportSize(EyesSeleniumDriver webDriver) {
        List browserInfoList;
        this.viewportSize = this.getConfiguration().getViewportSize();
        if (this.viewportSize == null && (browserInfoList = this.getConfiguration().getBrowsersInfo()) != null && !browserInfoList.isEmpty()) {
            for (RenderBrowserInfo deviceInfo : browserInfoList) {
                if (deviceInfo.getEmulationInfo() != null || deviceInfo.getIosDeviceInfo() != null) continue;
                this.viewportSize = new RectangleSize(deviceInfo.getWidth(), deviceInfo.getHeight());
            }
        }
        if (this.viewportSize == null) {
            this.viewportSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)webDriver);
        }
        try {
            EyesDriverUtils.setViewportSize((Logger)this.logger, (WebDriver)webDriver, (RectangleSize)this.viewportSize);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.OPEN, (Throwable)e, (String[])new String[0]);
        }
    }

    private void initDriver(WebDriver webDriver) {
        if (webDriver instanceof RemoteWebDriver) {
            SeleniumEyes seleniumEyes = new SeleniumEyes(this.configurationProvider, new ClassicRunner0());
            this.webDriver = new EyesSeleniumDriver(this.logger, seleniumEyes, (RemoteWebDriver)webDriver);
        }
        this.url = webDriver.getCurrentUrl();
    }

    public TestResults close(boolean throwException) {
        this.closeAsync();
        return this.waitForEyesToFinish(throwException);
    }

    public TestResults abortIfNotClosed() {
        this.abortAsync();
        return this.waitForEyesToFinish(false);
    }

    public TestResults abort() {
        return this.abortIfNotClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAsync() {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        this.logger.log(this.eyesId, Stage.CLOSE, Type.CALLED, new Pair[0]);
        this.isOpen = false;
        Map<String, RunningTest> map = this.testList;
        synchronized (map) {
            for (RunningTest runningTest : this.testList.values()) {
                runningTest.issueClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAsync() {
        this.logger.log(this.eyesId, Stage.CLOSE, Type.CALLED, new Pair[0]);
        Map<String, RunningTest> map = this.testList;
        synchronized (map) {
            for (RunningTest runningTest : this.testList.values()) {
                runningTest.issueAbort((Throwable)new EyesException(String.format("Didn't close test %s. Aborted the test", this.getConfiguration().getTestName())), false);
            }
        }
    }

    private TestResults waitForEyesToFinish(boolean throwException) {
        while (!this.isCompleted()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        List<TestResultContainer> allResults = this.getAllTestResults();
        TestResultContainer errorResult = null;
        TestResults firstResult = null;
        for (TestResultContainer result : allResults) {
            if (firstResult == null) {
                firstResult = result.getTestResults();
            }
            if (result.getException() == null) continue;
            errorResult = result;
            break;
        }
        if (errorResult != null) {
            if (throwException) {
                throw new Error(errorResult.getException());
            }
            return errorResult.getTestResults();
        }
        return firstResult;
    }

    public boolean getIsOpen() {
        return !this.isEyesClosed();
    }

    public String getApiKey() {
        return this.getConfiguration().getApiKey() == null ? this.runner.getApiKey() : this.getConfiguration().getApiKey();
    }

    public void setApiKey(String apiKey) {
        this.getConfiguration().setApiKey(apiKey);
    }

    public void setIsDisabled(Boolean disabled) {
        this.isDisabled = disabled;
    }

    public Boolean getIsDisabled() {
        return this.isDisabled == null ? this.runner.getIsDisabled() : this.isDisabled.booleanValue();
    }

    public URI getServerUrl() {
        String serverUrl = this.getConfiguration().getServerUrl() == null ? this.runner.getServerUrl() : this.getConfiguration().getServerUrl().toString();
        try {
            return new URI(serverUrl);
        }
        catch (URISyntaxException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            return null;
        }
    }

    public void setServerUrl(String serverUrl) {
        this.getConfiguration().setServerUrl(serverUrl);
    }

    public void proxy(AbstractProxySettings abstractProxySettings) {
        this.getConfiguration().setProxy(abstractProxySettings);
    }

    public AbstractProxySettings getProxy() {
        return this.getConfiguration().getProxy() == null ? this.runner.getProxy() : this.getConfiguration().getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEyesClosed() {
        boolean isVGEyesClosed = true;
        Map<String, RunningTest> map = this.testList;
        synchronized (map) {
            for (RunningTest runningTest : this.testList.values()) {
                isVGEyesClosed = isVGEyesClosed && runningTest.isCompleted();
            }
        }
        return isVGEyesClosed;
    }

    public void check(ICheckSettings ... checkSettings) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        for (ICheckSettings checkSetting : checkSettings) {
            this.check(checkSetting);
        }
    }

    public void check(String name, ICheckSettings checkSettings) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        if (name != null) {
            checkSettings = checkSettings.withName(name);
        }
        this.check(checkSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(ICheckSettings checkSettings) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        String source = this.webDriver.getCurrentUrl();
        this.logger.log(TraceLevel.Info, Collections.singleton(this.eyesId), Stage.CHECK, Type.CALLED, new Pair[]{Pair.of((Object)"configuration", (Object)this.getConfiguration()), Pair.of((Object)"checkSettings", (Object)checkSettings), Pair.of((Object)"source", (Object)source)});
        FrameChain originalFC = this.webDriver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.webDriver.switchTo();
        try {
            ArgumentGuard.notOfType((Object)checkSettings, ICheckSettings.class, (String)"checkSettings");
            if (checkSettings instanceof ISeleniumCheckTarget) {
                ((ISeleniumCheckTarget)checkSettings).init(this.logger, this.webDriver);
            }
            this.waitBeforeDomSnapshot();
            checkSettings = this.switchFramesAsNeeded(checkSettings, switchTo);
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
            SeleniumCheckSettings seleniumCheckSettings = (SeleniumCheckSettings)checkSettings;
            List<VisualGridSelector[]> regionsXPaths = this.getRegionsXPaths(checkSettingsInternal);
            this.trySetTargetSelector(seleniumCheckSettings);
            checkSettingsInternal = this.updateCheckSettings(checkSettings);
            Map<Integer, List<RunningTest>> requiredWidths = this.mapRunningTestsToRequiredBrowserWidth(seleniumCheckSettings);
            if (requiredWidths.isEmpty()) {
                this.captureDomForResourceCollection(0, this.testList.values(), switchTo, checkSettingsInternal, regionsXPaths, source);
                return;
            }
            for (Map.Entry<Integer, List<RunningTest>> entry : requiredWidths.entrySet()) {
                this.captureDomForResourceCollection(entry.getKey(), (Collection<RunningTest>)entry.getValue(), switchTo, checkSettingsInternal, regionsXPaths, source);
            }
            HashSet<String> testIds = new HashSet<String>();
            Map<String, RunningTest> map = this.testList;
            synchronized (map) {
                for (RunningTest runningTest : this.testList.values()) {
                    testIds.add(runningTest.getTestId());
                }
            }
            try {
                EyesDriverUtils.setViewportSize((Logger)this.logger, (WebDriver)this.webDriver, (RectangleSize)this.viewportSize);
                Thread.sleep(300L);
            }
            catch (Throwable throwable) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)throwable, (String[])testIds.toArray(new String[0]));
            }
        }
        catch (Throwable e) {
            Error error = new Error(e);
            Map<String, RunningTest> map = this.testList;
            synchronized (map) {
                for (RunningTest runningTest : this.testList.values()) {
                    runningTest.setTestInExceptionMode((Throwable)error);
                }
            }
        }
        finally {
            switchTo.frames(originalFC);
        }
    }

    private ICheckSettings switchFramesAsNeeded(ICheckSettings checkSettings, EyesTargetLocator switchTo) {
        int switchedToCount = this.switchToFrame((ISeleniumCheckTarget)checkSettings);
        boolean isFullPage = this.isFullPage((ICheckSettingsInternal)checkSettings);
        if (switchedToCount > 0 && isFullPage) {
            FrameChain frameChain = this.webDriver.getFrameChain().clone();
            Frame frame = frameChain.pop();
            checkSettings = ((SeleniumCheckSettings)checkSettings).region(frame.getReference());
            switchTo.parentFrame();
        }
        return checkSettings;
    }

    private boolean isFullPage(ICheckSettingsInternal checkSettingsInternal) {
        boolean isFullPage = true;
        Boolean b = checkSettingsInternal.isStitchContent();
        if (b != null) {
            isFullPage = b;
        } else {
            b = this.getConfiguration().isForceFullPageScreenshot();
            if (b != null) {
                isFullPage = b;
            }
        }
        return isFullPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<RunningTest>> mapRunningTestsToRequiredBrowserWidth(SeleniumCheckSettings seleniumCheckSettings) {
        boolean isDefaultLayoutBreakpointsSet;
        List layoutBreakpoint;
        if (!seleniumCheckSettings.getLayoutBreakpoints().isEmpty() || seleniumCheckSettings.isDefaultLayoutBreakpointsSet().booleanValue()) {
            layoutBreakpoint = seleniumCheckSettings.getLayoutBreakpoints();
            isDefaultLayoutBreakpointsSet = seleniumCheckSettings.isDefaultLayoutBreakpointsSet();
        } else {
            layoutBreakpoint = this.getConfiguration().getLayoutBreakpoints();
            isDefaultLayoutBreakpointsSet = this.getConfiguration().isDefaultLayoutBreakpointsSet();
        }
        HashSet<String> testIds = new HashSet<String>();
        Map<String, RunningTest> map = this.testList;
        synchronized (map) {
            for (RunningTest runningTest : this.testList.values()) {
                testIds.add(runningTest.getTestId());
            }
            HashMap<Integer, List<RunningTest>> requiredWidths = new HashMap<Integer, List<RunningTest>>();
            if (isDefaultLayoutBreakpointsSet || !layoutBreakpoint.isEmpty()) {
                for (RunningTest runningTest : this.testList.values()) {
                    int width = runningTest.getBrowserInfo().getDeviceSize().getWidth();
                    if (width <= 0) {
                        width = this.viewportSize.getWidth();
                    }
                    if (!layoutBreakpoint.isEmpty()) {
                        for (int i = layoutBreakpoint.size() - 1; i >= 0; --i) {
                            if (width < (Integer)layoutBreakpoint.get(i)) continue;
                            width = (Integer)layoutBreakpoint.get(i);
                            break;
                        }
                        if (width < (Integer)layoutBreakpoint.get(0)) {
                            width = (Integer)layoutBreakpoint.get(0) - 1;
                            this.logger.log(TraceLevel.Warn, testIds, Stage.CHECK, Type.DOM_SCRIPT, new Pair[]{Pair.of((Object)"message", (Object)String.format("Device width is smaller than the smallest breakpoint %d", layoutBreakpoint.get(0)))});
                        }
                    }
                    if (requiredWidths.containsKey(width)) {
                        ((List)requiredWidths.get(width)).add(runningTest);
                        continue;
                    }
                    ArrayList<RunningTest> list = new ArrayList<RunningTest>();
                    list.add(runningTest);
                    requiredWidths.put(width, list);
                }
            }
            return requiredWidths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureDomForResourceCollection(int width, Collection<RunningTest> tests, EyesTargetLocator switchTo, ICheckSettingsInternal checkSettingsInternal, List<VisualGridSelector[]> regionsXPaths, String source) throws Exception {
        HashSet<String> testIds = new HashSet<String>();
        Map<String, RunningTest> map = this.testList;
        synchronized (map) {
            for (RunningTest runningTest : tests) {
                testIds.add(runningTest.getTestId());
            }
        }
        if (width != 0) {
            try {
                EyesDriverUtils.setViewportSize((Logger)this.logger, (WebDriver)this.webDriver, (RectangleSize)new RectangleSize(width, this.viewportSize.getHeight()));
                Thread.sleep(300L);
            }
            catch (Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)t, (String[])testIds.toArray(new String[0]));
            }
        }
        if (width != 0) {
            RectangleSize viewportSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)this.webDriver);
            this.logger.log(TraceLevel.Info, testIds, Stage.CHECK, Type.DOM_SCRIPT, new Pair[]{Pair.of((Object)"requiredWidth", (Object)width), Pair.of((Object)"viewportSize", (Object)viewportSize)});
            BufferedImage bufferedImage = this.imageProvider.getImage();
            this.debugScreenshotsProvider.save(bufferedImage, String.format("snapshot_%s", viewportSize));
        }
        FrameData scriptResult = this.captureDomSnapshot(testIds, switchTo);
        String[] blobsUrls = new String[scriptResult.getBlobs().size()];
        for (int i = 0; i < scriptResult.getBlobs().size(); ++i) {
            blobsUrls[i] = ((BlobData)scriptResult.getBlobs().get(i)).getUrl();
        }
        this.logger.log(TraceLevel.Info, testIds, Stage.CHECK, Type.DOM_SCRIPT, new Pair[]{Pair.of((Object)"cdtSize", (Object)scriptResult.getCdt().size()), Pair.of((Object)"blobs", (Object)blobsUrls), Pair.of((Object)"resourceUrls", (Object)scriptResult.getResourceUrls())});
        ArrayList<CheckTask> checkTasks = new ArrayList<CheckTask>();
        Map<String, RunningTest> map2 = this.testList;
        synchronized (map2) {
            for (RunningTest runningTest : tests) {
                if (runningTest.isCloseTaskIssued()) continue;
                checkTasks.add(runningTest.issueCheck((ICheckSettings)checkSettingsInternal, regionsXPaths, source));
            }
        }
        if (checkTasks.isEmpty()) {
            this.logger.log(TraceLevel.Warn, testIds, Stage.CHECK, null, new Pair[]{Pair.of((Object)"message", (Object)"No check tasks created. Tests were probably aborted")});
            return;
        }
        scriptResult.setUserAgent(this.userAgent);
        this.runner.setDebugResourceWriter(this.getConfiguration().getDebugResourceWriter());
        this.runner.check(scriptResult, checkTasks);
    }

    FrameData captureDomSnapshot(Set<String> testIds, EyesTargetLocator switchTo) throws Exception {
        ScriptExecutor executor = new ScriptExecutor(){

            public Object execute(String script) {
                return VisualGridEyes.this.webDriver.executeScript(script, new Object[0]);
            }
        };
        FrameData frameData = DomScriptUtils.runDomSnapshot((Logger)this.logger, (ScriptExecutor)executor, testIds, (UserAgent)this.userAgent, (boolean)true, (boolean)this.getConfiguration().isDisableBrowserFetching());
        this.analyzeFrameData(testIds, frameData, switchTo);
        return frameData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeFrameData(Set<String> testIds, FrameData frameData, EyesTargetLocator switchTo) {
        Set cookies;
        FrameChain frameChain = this.webDriver.getFrameChain().clone();
        HashSet<Cookie> sdkCookies = new HashSet<Cookie>();
        if (this.getConfiguration().isUseCookies().booleanValue() && (cookies = this.webDriver.manage().getCookies()) != null) {
            for (org.openqa.selenium.Cookie cookie : cookies) {
                Cookie sdkCookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getExpiry());
                sdkCookies.add(sdkCookie);
            }
        }
        frameData.setCookies(sdkCookies);
        for (FrameData.CrossFrame crossFrame : frameData.getCrossFrames()) {
            if (crossFrame.getSelector() == null) continue;
            try {
                WebElement frame = this.webDriver.findElement(By.cssSelector((String)crossFrame.getSelector()));
                if (!this.switchToFrame(testIds, frame, switchTo)) continue;
                FrameData result = this.captureDomSnapshot(testIds, switchTo);
                try {
                    String url = GeneralUtils.sanitizeURL((String)result.getUrl());
                    URIBuilder builder = new URIBuilder(url);
                    builder.addParameter("applitools-iframe", UUID.randomUUID().toString());
                    result.setUrl(builder.toString());
                }
                catch (Throwable t) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)t, (String[])testIds.toArray(new String[0]));
                }
                frameData.addFrame(result);
                List attributeData = (List)((Map)frameData.getCdt().get(crossFrame.getIndex())).get("attributes");
                attributeData.add(new AttributeData("data-applitools-src", result.getUrl()));
            }
            catch (Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)t, (String[])testIds.toArray(new String[0]));
            }
            finally {
                switchTo.frames(frameChain);
            }
        }
        for (FrameData frame : frameData.getFrames()) {
            if (frame.getSelector() == null) continue;
            try {
                WebElement frameElement = this.webDriver.findElement(By.cssSelector((String)frame.getSelector()));
                if (!this.switchToFrame(testIds, frameElement, switchTo)) continue;
                this.analyzeFrameData(testIds, frame, switchTo);
            }
            catch (Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)t, (String[])testIds.toArray(new String[0]));
            }
            finally {
                switchTo.frames(frameChain);
            }
        }
    }

    private boolean switchToFrame(Set<String> testIds, WebElement frame, EyesTargetLocator switchTo) {
        EyesRemoteWebElement htmlBeforeSwitch = (EyesRemoteWebElement)this.webDriver.findElement(By.tagName((String)"html"));
        String idBeforeSwitch = htmlBeforeSwitch.getId();
        switchTo.frame(frame);
        EyesRemoteWebElement htmlAfterSwitch = (EyesRemoteWebElement)this.webDriver.findElement(By.tagName((String)"html"));
        String idAfterSwitch = htmlAfterSwitch.getId();
        if (idBeforeSwitch.equals(idAfterSwitch)) {
            this.logger.log(TraceLevel.Warn, testIds, Stage.CHECK, Type.DOM_SCRIPT, "Failed switching to cross origin iframe. Ignoring");
            this.webDriver.getFrameChain().pop();
            return false;
        }
        return true;
    }

    private void waitBeforeDomSnapshot() {
        int waitBeforeScreenshots = this.getConfiguration().getWaitBeforeScreenshots();
        try {
            Thread.sleep(waitBeforeScreenshots);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    ICheckSettingsInternal updateCheckSettings(ICheckSettings checkSettings) {
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        MatchLevel matchLevel = checkSettingsInternal.getMatchLevel();
        Boolean fully = checkSettingsInternal.isStitchContent();
        Boolean sendDom = checkSettingsInternal.isSendDom();
        Boolean ignoreDisplacements = checkSettingsInternal.isIgnoreDisplacements();
        if (matchLevel == null) {
            checkSettings = checkSettings.matchLevel(this.getConfiguration().getMatchLevel());
        }
        if (fully == null) {
            Boolean isForceFullPageScreenshot = this.getConfiguration().isForceFullPageScreenshot();
            boolean stitchContent = isForceFullPageScreenshot == null ? checkSettings.isCheckWindow() : isForceFullPageScreenshot;
            checkSettings = checkSettings.fully(Boolean.valueOf(stitchContent));
        }
        if (sendDom == null) {
            Boolean isSendDom = this.getConfiguration().isSendDom();
            checkSettings = checkSettings.sendDom(Boolean.valueOf(isSendDom == null || isSendDom != false));
        }
        if (ignoreDisplacements == null) {
            checkSettings = checkSettings.ignoreDisplacements(this.getConfiguration().getIgnoreDisplacements());
        }
        ArrayList options = new ArrayList();
        options.addAll(this.getConfiguration().getVisualGridOptions());
        options.addAll(checkSettingsInternal.getVisualGridOptions());
        checkSettings = checkSettings.visualGridOptions(options.size() > 0 ? options.toArray(new VisualGridOption[0]) : null);
        return (ICheckSettingsInternal)checkSettings;
    }

    private void trySetTargetSelector(SeleniumCheckSettings checkSettings) {
    }

    private int switchToFrame(ISeleniumCheckTarget checkTarget) {
        return 0;
    }

    private boolean switchToFrame(ISeleniumFrameCheckTarget frameTarget) {
        WebElement frameElement;
        WebDriver.TargetLocator switchTo = this.webDriver.switchTo();
        if (frameTarget.getFrameIndex() != null) {
            switchTo.frame(frameTarget.getFrameIndex().intValue());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameNameOrId() != null) {
            switchTo.frame(frameTarget.getFrameNameOrId());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameReference() != null) {
            switchTo.frame(frameTarget.getFrameReference());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameSelector() != null && (frameElement = this.webDriver.findElement(frameTarget.getFrameSelector())) != null) {
            switchTo.frame(frameElement);
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        return false;
    }

    private void updateFrameScrollRoot(IScrollRootElementContainer frameTarget) {
        WebElement rootElement = EyesSeleniumUtils.getScrollRootElement(this.logger, this.webDriver, frameTarget);
        Frame frame = this.webDriver.getFrameChain().peek();
        frame.setScrollRootElement(rootElement);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Map<String, RunningTest> getAllRunningTests() {
        return this.testList;
    }

    public String toString() {
        return "SeleniumVGEyes - url: " + this.url;
    }

    public void setServerConnector(ServerConnector serverConnector) {
        if (serverConnector != null && serverConnector.getAgentId() == null) {
            serverConnector.setAgentId(this.getFullAgentId());
        }
        this.runner.setServerConnector(serverConnector);
    }

    public String getFullAgentId() {
        String agentId = this.getConfiguration().getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    private Configuration getConfiguration() {
        return this.configurationProvider.get();
    }

    private String getBaseAgentId() {
        return "eyes.selenium.visualgrid.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    public void setBatch(BatchInfo batch) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        this.getConfiguration().setBatch(batch);
    }

    private List<VisualGridSelector[]> getRegionsXPaths(ICheckSettingsInternal csInternal) {
        List<WebElementRegion>[] elementLists;
        ArrayList<VisualGridSelector[]> result = new ArrayList<VisualGridSelector[]>();
        for (List<WebElementRegion> elementList : elementLists = this.collectSeleniumRegions(csInternal)) {
            ArrayList<VisualGridSelector> xPaths = new ArrayList<VisualGridSelector>();
            for (WebElementRegion webElementRegion : elementList) {
                if (webElementRegion.getElement() == null) continue;
                String xpath = (String)this.webDriver.executeScript(GET_ELEMENT_XPATH_JS, webElementRegion.getElement());
                xPaths.add(new VisualGridSelector(xpath, webElementRegion.getRegion()));
            }
            result.add(xPaths.toArray(new VisualGridSelector[0]));
        }
        return result;
    }

    private List<WebElementRegion>[] collectSeleniumRegions(ICheckSettingsInternal csInternal) {
        CheckSettings settings = (CheckSettings)csInternal;
        return null;
    }

    private List<WebElementRegion> getElementsFromRegions(List regionsProvider) {
        ArrayList<WebElementRegion> elements = new ArrayList<WebElementRegion>();
        for (Object getRegion : regionsProvider) {
            if (!(getRegion instanceof IGetSeleniumRegion)) continue;
            IGetSeleniumRegion getSeleniumRegion = (IGetSeleniumRegion)getRegion;
            List webElements = getSeleniumRegion.getElements();
            for (WebElement webElement : webElements) {
                elements.add(new WebElementRegion(webElement, getRegion));
            }
        }
        return elements;
    }

    public void addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public EyesSeleniumDriver getDriver() {
        return this.webDriver;
    }

    public IBatchCloser getBatchCloser() {
        return (IBatchCloser)this.testList.values().iterator().next();
    }

    public String getBatchId() {
        return this.getConfiguration().getBatch().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TestResultContainer> getAllTestResults() {
        ArrayList<TestResultContainer> allResults = new ArrayList<TestResultContainer>();
        Map<String, RunningTest> map = this.testList;
        synchronized (map) {
            for (RunningTest runningTest : this.testList.values()) {
                if (!runningTest.isCompleted()) {
                    if (this.runner.getError() != null) {
                        throw new EyesException("Execution crashed", this.runner.getError());
                    }
                    return null;
                }
                allResults.add(runningTest.getTestResultContainer());
            }
        }
        return allResults;
    }

    public boolean isCompleted() {
        return this.getAllTestResults() != null;
    }
}

