/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.utils.ArgumentGuard;
import org.apache.commons.lang3.tuple.Pair;

public class ContextBasedScaleProvider
implements ScaleProvider {
    private static final int ALLOWED_VS_DEVIATION = 1;
    private static final int ALLOWED_DCES_DEVIATION = 10;
    private static final int UNKNOWN_SCALE_RATIO = 0;
    private final Logger logger;
    private final double devicePixelRatio;
    private final RectangleSize topLevelContextEntireSize;
    private final RectangleSize viewportSize;
    private final boolean isMobileDevice;
    private double scaleRatio;

    private static double getScaleRatioToViewport(int viewportWidth, int imageToScaleWidth, double currentScaleRatio) {
        int scaledImageWidth = (int)Math.round((double)imageToScaleWidth * currentScaleRatio);
        double fromScaledToViewportRatio = (double)viewportWidth / (double)scaledImageWidth;
        return currentScaleRatio * fromScaledToViewportRatio;
    }

    public ContextBasedScaleProvider(Logger logger, RectangleSize topLevelContextEntireSize, RectangleSize viewportSize, double devicePixelRatio, boolean isMobileDevice) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.topLevelContextEntireSize = topLevelContextEntireSize;
        this.viewportSize = viewportSize;
        this.devicePixelRatio = devicePixelRatio;
        this.isMobileDevice = isMobileDevice;
        this.scaleRatio = 0.0;
    }

    public double getScaleRatio() {
        ArgumentGuard.isValidState((this.scaleRatio != 0.0 ? 1 : 0) != 0, (String)"scaleRatio not defined yet");
        return this.scaleRatio;
    }

    public void updateScaleRatio(int imageToScaleWidth) {
        int viewportWidth = this.viewportSize.getWidth();
        int dcesWidth = this.topLevelContextEntireSize.getWidth();
        if (imageToScaleWidth >= viewportWidth - 1 && imageToScaleWidth <= viewportWidth + 1 || imageToScaleWidth >= dcesWidth - 10 && imageToScaleWidth <= dcesWidth + 10) {
            this.scaleRatio = 1.0;
        } else {
            this.scaleRatio = 1.0 / this.devicePixelRatio;
            if (this.isMobileDevice) {
                this.scaleRatio = ContextBasedScaleProvider.getScaleRatioToViewport(viewportWidth, imageToScaleWidth, this.scaleRatio);
            }
            this.logger.log(TraceLevel.Info, null, Stage.GENERAL, new Pair[]{Pair.of((Object)"scaleRatio", (Object)this.scaleRatio)});
        }
    }
}

